/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.request;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.RequestUpdateResultOutcome;
import java.util.HashMap;
import java.util.Set;

public final class RequestUpdateOutcomes {
    private static final String[] zzazR = new String[]{"requestId", "outcome"};
    private final int zzYm;
    private final HashMap<String, Integer> zzazS;

    private RequestUpdateOutcomes(int statusCode, HashMap<String, Integer> outcomeMap) {
        this.zzYm = statusCode;
        this.zzazS = outcomeMap;
    }

    public int getRequestOutcome(String requestId) {
        zzx.zzb(this.zzazS.containsKey(requestId), (Object)("Request " + requestId + " was not part of the update operation!"));
        return this.zzazS.get(requestId);
    }

    public Set<String> getRequestIds() {
        return this.zzazS.keySet();
    }

    public static RequestUpdateOutcomes zzaa(DataHolder dataHolder) {
        Builder builder = new Builder();
        builder.zzgj(dataHolder.getStatusCode());
        int n = dataHolder.getCount();
        for (int i = 0; i < n; ++i) {
            int n2 = dataHolder.zzbt(i);
            builder.zzx(dataHolder.zzd("requestId", i, n2), dataHolder.zzc("outcome", i, n2));
        }
        return builder.zzvF();
    }

    public static final class Builder {
        private HashMap<String, Integer> zzazS = new HashMap();
        private int zzYm = 0;

        public Builder zzx(String string2, int n) {
            if (RequestUpdateResultOutcome.isValid(n)) {
                this.zzazS.put(string2, n);
            }
            return this;
        }

        public Builder zzgj(int n) {
            this.zzYm = n;
            return this;
        }

        public RequestUpdateOutcomes zzvF() {
            return new RequestUpdateOutcomes(this.zzYm, this.zzazS);
        }
    }
}

