/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzmo;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzazY;
    private final String zzazZ;
    private final String zzaAa;
    private final long zzaAb;
    private final long zzaAc;
    private final String zzaAd;
    private final Uri zzaAe;
    private final Uri zzaAf;
    private final PlayerEntity zzaAg;
    private final String zzaAh;
    private final String zzaAi;
    private final String zzaAj;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzazY = score.getRank();
        this.zzazZ = zzx.zzw(score.getDisplayRank());
        this.zzaAa = zzx.zzw(score.getDisplayScore());
        this.zzaAb = score.getRawScore();
        this.zzaAc = score.getTimestampMillis();
        this.zzaAd = score.getScoreHolderDisplayName();
        this.zzaAe = score.getScoreHolderIconImageUri();
        this.zzaAf = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzaAg = player == null ? null : (PlayerEntity)player.freeze();
        this.zzaAh = score.getScoreTag();
        this.zzaAi = score.getScoreHolderIconImageUrl();
        this.zzaAj = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzazY;
    }

    @Override
    public String getDisplayRank() {
        return this.zzazZ;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzazZ, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzaAa;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaAa, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzaAb;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzaAc;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzaAg == null) {
            return this.zzaAd;
        }
        return this.zzaAg.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaAg == null) {
            zzmo.zzb(this.zzaAd, dataOut);
            return;
        }
        this.zzaAg.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzaAg == null) {
            return this.zzaAe;
        }
        return this.zzaAg.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzaAg == null) {
            return this.zzaAi;
        }
        return this.zzaAg.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzaAg == null) {
            return this.zzaAf;
        }
        return this.zzaAg.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzaAg == null) {
            return this.zzaAj;
        }
        return this.zzaAg.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzaAg;
    }

    @Override
    public String getScoreTag() {
        return this.zzaAh;
    }

    public LeaderboardScore zzvI() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzw.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzw.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && zzw.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && zzw.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && zzw.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && zzw.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && zzw.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && zzw.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && zzw.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && zzw.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && zzw.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzw.zzv(leaderboardScore).zzg("Rank", leaderboardScore.getRank()).zzg("DisplayRank", leaderboardScore.getDisplayRank()).zzg("Score", leaderboardScore.getRawScore()).zzg("DisplayScore", leaderboardScore.getDisplayScore()).zzg("Timestamp", leaderboardScore.getTimestampMillis()).zzg("DisplayName", leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).zzg("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzvI();
    }
}

