/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.internal.constants.TimeSpan;
import java.util.HashMap;

public final class ScoreSubmissionData {
    private static final String[] zzazR = new String[]{"leaderboardId", "playerId", "timeSpan", "hasResult", "rawScore", "formattedScore", "newBest", "scoreTag"};
    private String zzazT;
    private String zzYf;
    private int zzYm;
    private HashMap<Integer, Result> zzaAx;

    public ScoreSubmissionData(DataHolder dataHolder) {
        this.zzYm = dataHolder.getStatusCode();
        this.zzaAx = new HashMap();
        int n = dataHolder.getCount();
        zzx.zzaa(n == 3);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            int n2 = dataHolder.zzbt(i);
            if (i == 0) {
                this.zzazT = dataHolder.zzd("leaderboardId", i, n2);
                this.zzYf = dataHolder.zzd("playerId", i, n2);
            }
            if (!(bl = dataHolder.zze("hasResult", i, n2))) continue;
            Result result = new Result(dataHolder.zzb("rawScore", i, n2), dataHolder.zzd("formattedScore", i, n2), dataHolder.zzd("scoreTag", i, n2), dataHolder.zze("newBest", i, n2));
            this.zza(result, dataHolder.zzc("timeSpan", i, n2));
        }
    }

    public String getLeaderboardId() {
        return this.zzazT;
    }

    public String getPlayerId() {
        return this.zzYf;
    }

    public Result getScoreResult(int timeSpan) {
        return this.zzaAx.get(timeSpan);
    }

    private void zza(Result result, int n) {
        this.zzaAx.put(n, result);
    }

    public String toString() {
        zzw.zza zza2 = zzw.zzv(this).zzg("PlayerId", this.zzYf).zzg("StatusCode", this.zzYm);
        for (int i = 0; i < 3; ++i) {
            Result result = this.zzaAx.get(i);
            zza2.zzg("TimesSpan", TimeSpan.zzfZ(i));
            zza2.zzg("Result", result == null ? "null" : result.toString());
        }
        return zza2.toString();
    }

    public static final class Result {
        public final long rawScore;
        public final String formattedScore;
        public final String scoreTag;
        public final boolean newBest;

        public Result(long rawScore, String formattedScore, String scoreTag, boolean newBest) {
            this.rawScore = rawScore;
            this.formattedScore = formattedScore;
            this.scoreTag = scoreTag;
            this.newBest = newBest;
        }

        public String toString() {
            return zzw.zzv(this).zzg("RawScore", this.rawScore).zzg("FormattedScore", this.formattedScore).zzg("ScoreTag", this.scoreTag).zzg("NewBest", this.newBest).toString();
        }
    }
}

