/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final String zzavC;
    private final long zzaAz;
    private final int zzaAA;
    private final ParticipantEntity zzaAB;
    private final ArrayList<ParticipantEntity> zzaAC;
    private final int zzaAD;
    private final int zzaAE;

    InvitationEntity(Invitation invitation) {
        this.mVersionCode = 2;
        this.zzaAy = new GameEntity(invitation.getGame());
        this.zzavC = invitation.getInvitationId();
        this.zzaAz = invitation.getCreationTimestamp();
        this.zzaAA = invitation.getInvitationType();
        this.zzaAD = invitation.getVariant();
        this.zzaAE = invitation.getAvailableAutoMatchSlots();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n = arrayList.size();
        this.zzaAC = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Participant participant2 = (Participant)arrayList.get(i);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.zzaAC.add((ParticipantEntity)participant2.freeze());
        }
        zzx.zzb(participant, (Object)"Must have a valid inviter!");
        this.zzaAB = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzavC = invitationId;
        this.zzaAz = creationTimestamp;
        this.zzaAA = invitationType;
        this.zzaAB = inviter;
        this.zzaAC = participants;
        this.zzaAD = variant;
        this.zzaAE = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public String getInvitationId() {
        return this.zzavC;
    }

    @Override
    public Participant getInviter() {
        return this.zzaAB;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaAz;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaAC);
    }

    @Override
    public int getInvitationType() {
        return this.zzaAA;
    }

    @Override
    public int getVariant() {
        return this.zzaAD;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.zzaAE;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.zza(this);
    }

    static int zza(Invitation invitation) {
        return zzw.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.zza(this, obj);
    }

    static boolean zza(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return zzw.equal(invitation2.getGame(), invitation.getGame()) && zzw.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && zzw.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && zzw.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && zzw.equal(invitation2.getInviter(), invitation.getInviter()) && zzw.equal(invitation2.getParticipants(), invitation.getParticipants()) && zzw.equal(invitation2.getVariant(), invitation.getVariant()) && zzw.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.zzb(this);
    }

    static String zzb(Invitation invitation) {
        return zzw.zzv(invitation).zzg("Game", invitation.getGame()).zzg("InvitationId", invitation.getInvitationId()).zzg("CreationTimestamp", invitation.getCreationTimestamp()).zzg("InvitationType", invitation.getInvitationType()).zzg("Inviter", invitation.getInviter()).zzg("Participants", invitation.getParticipants()).zzg("Variant", invitation.getVariant()).zzg("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            InvitationEntityCreator.zza(this, dest, flags);
        } else {
            this.zzaAy.writeToParcel(dest, flags);
            dest.writeString(this.zzavC);
            dest.writeLong(this.zzaAz);
            dest.writeInt(this.zzaAA);
            this.zzaAB.writeToParcel(dest, flags);
            int n = this.zzaAC.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzaAC.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity zzee(Parcel parcel) {
            int n;
            boolean bl = InvitationEntity.zzd(InvitationEntity.zzoT());
            if (bl || InvitationEntity.zzck(InvitationEntity.class.getCanonicalName())) {
                return super.zzee(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n2 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n3 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n3);
            for (n = 0; n < n3; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            int n4 = 0;
            return new InvitationEntity(2, gameEntity, string2, l2, n2, participantEntity, arrayList, n, n4);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzee(x0);
        }
    }
}

