/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.zzmo;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzawg;
    private final String zzTa;
    private final Uri zzatu;
    private final Uri zzatv;
    private final int zzys;
    private final String zzavf;
    private final boolean zzaAG;
    private final PlayerEntity zzaux;
    private final int zzVl;
    private final ParticipantResult zzaAH;
    private final String zzatF;
    private final String zzatG;

    public ParticipantEntity(Participant participant) {
        this.mVersionCode = 3;
        this.zzawg = participant.getParticipantId();
        this.zzTa = participant.getDisplayName();
        this.zzatu = participant.getIconImageUri();
        this.zzatv = participant.getHiResImageUri();
        this.zzys = participant.getStatus();
        this.zzavf = participant.zzut();
        this.zzaAG = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.zzaux = player == null ? null : new PlayerEntity(player);
        this.zzVl = participant.getCapabilities();
        this.zzaAH = participant.getResult();
        this.zzatF = participant.getIconImageUrl();
        this.zzatG = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.mVersionCode = versionCode;
        this.zzawg = participantId;
        this.zzTa = displayName;
        this.zzatu = iconImageUri;
        this.zzatv = hiResImageUri;
        this.zzys = status;
        this.zzavf = clientAddress;
        this.zzaAG = connectedToRoom;
        this.zzaux = player;
        this.zzVl = capabilities;
        this.zzaAH = result;
        this.zzatF = iconImageUrl;
        this.zzatG = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public int getStatus() {
        return this.zzys;
    }

    @Override
    public String zzut() {
        return this.zzavf;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.zzaAG;
    }

    @Override
    public String getDisplayName() {
        if (this.zzaux == null) {
            return this.zzTa;
        }
        return this.zzaux.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.zzaux == null) {
            zzmo.zzb(this.zzTa, dataOut);
            return;
        }
        this.zzaux.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.zzaux == null) {
            return this.zzatu;
        }
        return this.zzaux.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.zzaux == null) {
            return this.zzatF;
        }
        return this.zzaux.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.zzaux == null) {
            return this.zzatv;
        }
        return this.zzaux.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.zzaux == null) {
            return this.zzatG;
        }
        return this.zzaux.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.zzawg;
    }

    @Override
    public Player getPlayer() {
        return this.zzaux;
    }

    @Override
    public ParticipantResult getResult() {
        return this.zzaAH;
    }

    @Override
    public int getCapabilities() {
        return this.zzVl;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.zza(this);
    }

    static int zza(Participant participant) {
        return zzw.hashCode(participant.getPlayer(), participant.getStatus(), participant.zzut(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.zza(this, obj);
    }

    static boolean zza(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return zzw.equal(participant2.getPlayer(), participant.getPlayer()) && zzw.equal(participant2.getStatus(), participant.getStatus()) && zzw.equal(participant2.zzut(), participant.zzut()) && zzw.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && zzw.equal(participant2.getDisplayName(), participant.getDisplayName()) && zzw.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && zzw.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && zzw.equal(participant2.getCapabilities(), participant.getCapabilities()) && zzw.equal(participant2.getResult(), participant.getResult()) && zzw.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.zzb(this);
    }

    static String zzb(Participant participant) {
        return zzw.zzv(participant).zzg("ParticipantId", participant.getParticipantId()).zzg("Player", participant.getPlayer()).zzg("Status", participant.getStatus()).zzg("ClientAddress", participant.zzut()).zzg("ConnectedToRoom", participant.isConnectedToRoom()).zzg("DisplayName", participant.getDisplayName()).zzg("IconImage", participant.getIconImageUri()).zzg("IconImageUrl", participant.getIconImageUrl()).zzg("HiResImage", participant.getHiResImageUri()).zzg("HiResImageUrl", participant.getHiResImageUrl()).zzg("Capabilities", participant.getCapabilities()).zzg("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzoU()) {
            ParticipantEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzawg);
            dest.writeString(this.zzTa);
            dest.writeString(this.zzatu == null ? null : this.zzatu.toString());
            dest.writeString(this.zzatv == null ? null : this.zzatv.toString());
            dest.writeInt(this.zzys);
            dest.writeString(this.zzavf);
            dest.writeInt(this.zzaAG ? 1 : 0);
            dest.writeInt(this.zzaux == null ? 0 : 1);
            if (this.zzaux != null) {
                this.zzaux.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity zzef(Parcel parcel) {
            boolean bl = ParticipantEntity.zzd(ParticipantEntity.zzoT());
            if (bl || ParticipantEntity.zzck(ParticipantEntity.class.getCanonicalName())) {
                return super.zzef(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl2 = parcel.readInt() > 0;
            boolean bl3 = parcel.readInt() > 0;
            int n2 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl3 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n, string6, bl2, playerEntity, n2, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzef(x0);
        }
    }
}

