/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.zzmo;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final Parcelable.Creator<TurnBasedMatchEntity> CREATOR = new TurnBasedMatchEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final String zzavX;
    private final String zzaAV;
    private final long zzaAz;
    private final String zzaBd;
    private final long zzauA;
    private final String zzaBe;
    private final int zzaBf;
    private final int zzaAD;
    private final int mVersion;
    private final byte[] zzaBg;
    private final ArrayList<ParticipantEntity> zzaAC;
    private final String zzaBh;
    private final byte[] zzaBi;
    private final int zzaBj;
    private final Bundle zzaAT;
    private final int zzaBk;
    private final boolean zzaBl;
    private final String zzaqZ;
    private final String zzaBm;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.mVersionCode = 2;
        this.zzaAy = new GameEntity(match.getGame());
        this.zzavX = match.getMatchId();
        this.zzaAV = match.getCreatorId();
        this.zzaAz = match.getCreationTimestamp();
        this.zzaBd = match.getLastUpdaterId();
        this.zzauA = match.getLastUpdatedTimestamp();
        this.zzaBe = match.getPendingParticipantId();
        this.zzaBf = match.getStatus();
        this.zzaBk = match.getTurnStatus();
        this.zzaAD = match.getVariant();
        this.mVersion = match.getVersion();
        this.zzaBh = match.getRematchId();
        this.zzaBj = match.getMatchNumber();
        this.zzaAT = match.getAutoMatchCriteria();
        this.zzaBl = match.isLocallyModified();
        this.zzaqZ = match.getDescription();
        this.zzaBm = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.zzaBg = null;
        } else {
            this.zzaBg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaBg, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.zzaBi = null;
        } else {
            this.zzaBi = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.zzaBi, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n = arrayList.size();
        this.zzaAC = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaAC.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzavX = matchId;
        this.zzaAV = creatorId;
        this.zzaAz = creationTimestamp;
        this.zzaBd = lastUpdaterId;
        this.zzauA = lastUpdatedTimestamp;
        this.zzaBe = pendingParticipantId;
        this.zzaBf = matchStatus;
        this.zzaBk = turnStatus;
        this.zzaAD = variant;
        this.mVersion = version;
        this.zzaBg = data;
        this.zzaAC = participants;
        this.zzaBh = rematchId;
        this.zzaBi = previousData;
        this.zzaBj = matchNumber;
        this.zzaAT = autoMatchCriteria;
        this.zzaBl = isLocallyModified;
        this.zzaqZ = description;
        this.zzaBm = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public String getMatchId() {
        return this.zzavX;
    }

    @Override
    public String getCreatorId() {
        return this.zzaAV;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaAz;
    }

    @Override
    public String getLastUpdaterId() {
        return this.zzaBd;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzauA;
    }

    @Override
    public String getPendingParticipantId() {
        return this.zzaBe;
    }

    @Override
    public int getStatus() {
        return this.zzaBf;
    }

    @Override
    public int getTurnStatus() {
        return this.zzaBk;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.zzaBm;
    }

    @Override
    public Participant getDescriptionParticipant() {
        String string2 = this.getDescriptionParticipantId();
        if (string2 == null) {
            return null;
        }
        return this.getParticipant(string2);
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaqZ, dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzaAD;
    }

    @Override
    public byte[] getData() {
        return this.zzaBg;
    }

    @Override
    public int getVersion() {
        return this.mVersion;
    }

    @Override
    public String getRematchId() {
        return this.zzaBh;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.zzaBi;
    }

    @Override
    public int getMatchNumber() {
        return this.zzaBj;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzaAT;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.zzaAT == null) {
            return 0;
        }
        return this.zzaAT.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.zzaBf == 2 && this.zzaBh == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.zzaBl;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.zzc(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzaAC);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.zza(this);
    }

    static int zza(TurnBasedMatch turnBasedMatch) {
        return zzw.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.zza((TurnBasedMatch)this, obj);
    }

    static boolean zza(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return zzw.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && zzw.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && zzw.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && zzw.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && zzw.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && zzw.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && zzw.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && zzw.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && zzw.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && zzw.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && zzw.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && zzw.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && zzw.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && zzw.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && zzw.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && zzw.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && zzw.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && zzw.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.zzb(this);
    }

    static String zzb(TurnBasedMatch turnBasedMatch) {
        return zzw.zzv(turnBasedMatch).zzg("Game", turnBasedMatch.getGame()).zzg("MatchId", turnBasedMatch.getMatchId()).zzg("CreatorId", turnBasedMatch.getCreatorId()).zzg("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).zzg("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).zzg("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).zzg("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).zzg("MatchStatus", turnBasedMatch.getStatus()).zzg("TurnStatus", turnBasedMatch.getTurnStatus()).zzg("Description", turnBasedMatch.getDescription()).zzg("Variant", turnBasedMatch.getVariant()).zzg("Data", turnBasedMatch.getData()).zzg("Version", turnBasedMatch.getVersion()).zzg("Participants", turnBasedMatch.getParticipants()).zzg("RematchId", turnBasedMatch.getRematchId()).zzg("PreviousData", turnBasedMatch.getPreviousMatchData()).zzg("MatchNumber", turnBasedMatch.getMatchNumber()).zzg("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).zzg("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).zzg("LocallyModified", turnBasedMatch.isLocallyModified()).zzg("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.zza(this, out, flags);
    }

    static int zza(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> zzc(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant zzc(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

