/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;

public final class MilestoneRef
extends zzc
implements Milestone {
    MilestoneRef(DataHolder holder, int dataRow) {
        super(holder, dataRow);
    }

    @Override
    public String getMilestoneId() {
        return this.getString("external_milestone_id");
    }

    @Override
    public long getCurrentProgress() {
        long l2;
        switch (this.getState()) {
            case 3: 
            case 4: {
                l2 = this.getTargetProgress();
                break;
            }
            case 1: {
                l2 = 0L;
                break;
            }
            case 2: {
                l2 = this.getLong("current_value");
                if (this.getLong("quest_state") == 6L) break;
                l2 -= this.zzvO();
                break;
            }
            default: {
                l2 = 0L;
            }
        }
        if (l2 < 0L) {
            GamesLog.zzz("MilestoneRef", "Current progress should never be negative");
            l2 = 0L;
        }
        if (l2 > this.getTargetProgress()) {
            GamesLog.zzz("MilestoneRef", "Current progress should never exceed target progress");
            l2 = this.getTargetProgress();
        }
        return l2;
    }

    @Override
    public String getEventId() {
        return this.getString("external_event_id");
    }

    private long zzvO() {
        return this.getLong("initial_value");
    }

    @Override
    public long getTargetProgress() {
        return this.getLong("target_value");
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.getByteArray("completion_reward_data");
    }

    @Override
    public int getState() {
        return this.getInteger("milestone_state");
    }

    @Override
    public Milestone freeze() {
        return new MilestoneEntity(this);
    }

    @Override
    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    @Override
    public boolean equals(Object obj) {
        return MilestoneEntity.zza(this, obj);
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        MilestoneEntity milestoneEntity = (MilestoneEntity)this.freeze();
        milestoneEntity.writeToParcel(dest, flags);
    }
}

