/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzmo;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final String zzaBq;
    private final long zzaBr;
    private final Uri zzaBs;
    private final String zzaBt;
    private final String zzaqZ;
    private final long zzaBu;
    private final long zzauA;
    private final Uri zzaBv;
    private final String zzaBw;
    private final String mName;
    private final long zzaBx;
    private final long zzaBy;
    private final int mState;
    private final int zzWJ;
    private final ArrayList<MilestoneEntity> zzaBz;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzaAy = new GameEntity(quest.getGame());
        this.zzaBq = quest.getQuestId();
        this.zzaBr = quest.getAcceptedTimestamp();
        this.zzaqZ = quest.getDescription();
        this.zzaBs = quest.getBannerImageUri();
        this.zzaBt = quest.getBannerImageUrl();
        this.zzaBu = quest.getEndTimestamp();
        this.zzaBv = quest.getIconImageUri();
        this.zzaBw = quest.getIconImageUrl();
        this.zzauA = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzaBx = quest.zzvQ();
        this.zzaBy = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzWJ = quest.getType();
        List<Milestone> list = quest.zzvP();
        int n = list.size();
        this.zzaBz = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaBz.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzaBq = questId;
        this.zzaBr = acceptedTimestamp;
        this.zzaBs = bannerImageUri;
        this.zzaBt = bannerImageUrl;
        this.zzaqZ = description;
        this.zzaBu = endTimestamp;
        this.zzauA = lastUpdatedTimestamp;
        this.zzaBv = iconImageUri;
        this.zzaBw = iconImageUrl;
        this.mName = name;
        this.zzaBx = notifyTimestamp;
        this.zzaBy = startTimestamp;
        this.mState = state;
        this.zzWJ = type;
        this.zzaBz = milestones;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzaBq;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzmo.zzb(this.mName, dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaqZ, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzaBv;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzaBw;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzaBs;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzaBt;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzvP().get(0);
    }

    @Override
    public List<Milestone> zzvP() {
        return new ArrayList<Milestone>(this.zzaBz);
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzWJ;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzaBr;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzaBu;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzauA;
    }

    @Override
    public long zzvQ() {
        return this.zzaBx;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzaBy;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzaBx <= System.currentTimeMillis() + 1800000L;
    }

    @Override
    public Quest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzw.hashCode(quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzvP(), quest.getName(), quest.zzvQ(), quest.getStartTimestamp(), quest.getState());
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzw.equal(quest2.getGame(), quest.getGame()) && zzw.equal(quest2.getQuestId(), quest.getQuestId()) && zzw.equal(quest2.getAcceptedTimestamp(), quest.getAcceptedTimestamp()) && zzw.equal(quest2.getBannerImageUri(), quest.getBannerImageUri()) && zzw.equal(quest2.getDescription(), quest.getDescription()) && zzw.equal(quest2.getEndTimestamp(), quest.getEndTimestamp()) && zzw.equal(quest2.getIconImageUri(), quest.getIconImageUri()) && zzw.equal(quest2.getLastUpdatedTimestamp(), quest.getLastUpdatedTimestamp()) && zzw.equal(quest2.zzvP(), quest.zzvP()) && zzw.equal(quest2.getName(), quest.getName()) && zzw.equal(quest2.zzvQ(), quest.zzvQ()) && zzw.equal(quest2.getStartTimestamp(), quest.getStartTimestamp()) && zzw.equal(quest2.getState(), quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzw.zzv(quest).zzg("Game", quest.getGame()).zzg("QuestId", quest.getQuestId()).zzg("AcceptedTimestamp", quest.getAcceptedTimestamp()).zzg("BannerImageUri", quest.getBannerImageUri()).zzg("BannerImageUrl", quest.getBannerImageUrl()).zzg("Description", quest.getDescription()).zzg("EndTimestamp", quest.getEndTimestamp()).zzg("IconImageUri", quest.getIconImageUri()).zzg("IconImageUrl", quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzvP()).zzg("Name", quest.getName()).zzg("NotifyTimestamp", quest.zzvQ()).zzg("StartTimestamp", quest.getStartTimestamp()).zzg("State", quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

