/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final Parcelable.Creator<GameRequestEntity> CREATOR = new GameRequestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final PlayerEntity zzaBA;
    private final byte[] zzaBg;
    private final String zzBY;
    private final ArrayList<PlayerEntity> zzaBB;
    private final int zzWJ;
    private final long zzaAz;
    private final long zzaBC;
    private final Bundle zzaBD;
    private final int zzys;

    public GameRequestEntity(GameRequest request) {
        this.mVersionCode = 2;
        this.zzaAy = new GameEntity(request.getGame());
        this.zzaBA = new PlayerEntity(request.getSender());
        this.zzBY = request.getRequestId();
        this.zzWJ = request.getType();
        this.zzaAz = request.getCreationTimestamp();
        this.zzaBC = request.getExpirationTimestamp();
        this.zzys = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.zzaBg = null;
        } else {
            this.zzaBg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzaBg, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n = list.size();
        this.zzaBB = new ArrayList(n);
        this.zzaBD = new Bundle();
        for (int i = 0; i < n; ++i) {
            Player player = (Player)list.get(i).freeze();
            String string2 = player.getPlayerId();
            this.zzaBB.add((PlayerEntity)player);
            this.zzaBD.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzaBA = sender;
        this.zzaBg = data;
        this.zzBY = requestId;
        this.zzaBB = recipients;
        this.zzWJ = type;
        this.zzaAz = creationTimestamp;
        this.zzaBC = expirationTimestamp;
        this.zzaBD = recipientStatuses;
        this.zzys = status;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRequestId() {
        return this.zzBY;
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public Player getSender() {
        return this.zzaBA;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.zzaBB);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.zzaBg;
    }

    @Override
    public int getType() {
        return this.zzWJ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaAz;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.zzaBC;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.zzaBD.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.zzys;
    }

    public Bundle zzvR() {
        return this.zzaBD;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.zza(this);
    }

    static int zza(GameRequest gameRequest) {
        return zzw.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.zzb(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.zza(this, obj);
    }

    static boolean zza(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return zzw.equal(gameRequest2.getGame(), gameRequest.getGame()) && zzw.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && zzw.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && zzw.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.zzb(gameRequest2), GameRequestEntity.zzb(gameRequest)) && zzw.equal(gameRequest2.getType(), gameRequest.getType()) && zzw.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && zzw.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] zzb(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n = list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = gameRequest.getRecipientStatus(list.get(i).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.zzc(this);
    }

    static String zzc(GameRequest gameRequest) {
        return zzw.zzv(gameRequest).zzg("Game", gameRequest.getGame()).zzg("Sender", gameRequest.getSender()).zzg("Recipients", gameRequest.getRecipients()).zzg("Data", gameRequest.getData()).zzg("RequestId", gameRequest.getRequestId()).zzg("Type", gameRequest.getType()).zzg("CreationTimestamp", gameRequest.getCreationTimestamp()).zzg("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.zza(this, dest, flags);
    }
}

