/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataEntityCreator;
import com.google.android.gms.internal.zzmo;

public final class SnapshotMetadataEntity
implements SafeParcelable,
SnapshotMetadata {
    public static final Parcelable.Creator<SnapshotMetadataEntity> CREATOR = new SnapshotMetadataEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaAy;
    private final PlayerEntity zzaBN;
    private final String zzavx;
    private final Uri zzaBK;
    private final String zzaBO;
    private final String zzajf;
    private final String zzaqZ;
    private final long zzaBP;
    private final long zzaBQ;
    private final float zzaBR;
    private final String zzaBS;
    private final boolean zzaBT;
    private final long zzaBU;
    private final String zzaBV;

    public SnapshotMetadataEntity(SnapshotMetadata snapshotMetadata) {
        this.mVersionCode = 6;
        this.zzaAy = new GameEntity(snapshotMetadata.getGame());
        this.zzaBN = new PlayerEntity(snapshotMetadata.getOwner());
        this.zzavx = snapshotMetadata.getSnapshotId();
        this.zzaBK = snapshotMetadata.getCoverImageUri();
        this.zzaBO = snapshotMetadata.getCoverImageUrl();
        this.zzaBR = snapshotMetadata.getCoverImageAspectRatio();
        this.zzajf = snapshotMetadata.getTitle();
        this.zzaqZ = snapshotMetadata.getDescription();
        this.zzaBP = snapshotMetadata.getLastModifiedTimestamp();
        this.zzaBQ = snapshotMetadata.getPlayedTime();
        this.zzaBS = snapshotMetadata.getUniqueName();
        this.zzaBT = snapshotMetadata.hasChangePending();
        this.zzaBU = snapshotMetadata.getProgressValue();
        this.zzaBV = snapshotMetadata.getDeviceName();
    }

    SnapshotMetadataEntity(int versionCode, GameEntity game, PlayerEntity owner, String snapshotId, Uri coverImageUri, String coverImageUrl, String title, String description, long lastModifiedTimestamp, long playedTime, float coverImageAspectRatio, String uniqueName, boolean changePending, long progressValue, String deviceName) {
        this.mVersionCode = versionCode;
        this.zzaAy = game;
        this.zzaBN = owner;
        this.zzavx = snapshotId;
        this.zzaBK = coverImageUri;
        this.zzaBO = coverImageUrl;
        this.zzaBR = coverImageAspectRatio;
        this.zzajf = title;
        this.zzaqZ = description;
        this.zzaBP = lastModifiedTimestamp;
        this.zzaBQ = playedTime;
        this.zzaBS = uniqueName;
        this.zzaBT = changePending;
        this.zzaBU = progressValue;
        this.zzaBV = deviceName;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public Game getGame() {
        return this.zzaAy;
    }

    @Override
    public Player getOwner() {
        return this.zzaBN;
    }

    @Override
    public String getSnapshotId() {
        return this.zzavx;
    }

    @Override
    public Uri getCoverImageUri() {
        return this.zzaBK;
    }

    @Override
    public String getCoverImageUrl() {
        return this.zzaBO;
    }

    @Override
    public float getCoverImageAspectRatio() {
        return this.zzaBR;
    }

    @Override
    public String getUniqueName() {
        return this.zzaBS;
    }

    @Override
    public String getTitle() {
        return this.zzajf;
    }

    @Override
    public String getDescription() {
        return this.zzaqZ;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzmo.zzb(this.zzaqZ, dataOut);
    }

    @Override
    public long getLastModifiedTimestamp() {
        return this.zzaBP;
    }

    @Override
    public long getPlayedTime() {
        return this.zzaBQ;
    }

    @Override
    public boolean hasChangePending() {
        return this.zzaBT;
    }

    @Override
    public long getProgressValue() {
        return this.zzaBU;
    }

    @Override
    public String getDeviceName() {
        return this.zzaBV;
    }

    @Override
    public SnapshotMetadata freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return SnapshotMetadataEntity.zza(this);
    }

    static int zza(SnapshotMetadata snapshotMetadata) {
        return zzw.hashCode(snapshotMetadata.getGame(), snapshotMetadata.getOwner(), snapshotMetadata.getSnapshotId(), snapshotMetadata.getCoverImageUri(), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio()), snapshotMetadata.getTitle(), snapshotMetadata.getDescription(), snapshotMetadata.getLastModifiedTimestamp(), snapshotMetadata.getPlayedTime(), snapshotMetadata.getUniqueName(), snapshotMetadata.hasChangePending(), snapshotMetadata.getProgressValue(), snapshotMetadata.getDeviceName());
    }

    public boolean equals(Object obj) {
        return SnapshotMetadataEntity.zza(this, obj);
    }

    static boolean zza(SnapshotMetadata snapshotMetadata, Object object) {
        if (!(object instanceof SnapshotMetadata)) {
            return false;
        }
        if (snapshotMetadata == object) {
            return true;
        }
        SnapshotMetadata snapshotMetadata2 = (SnapshotMetadata)object;
        return zzw.equal(snapshotMetadata2.getGame(), snapshotMetadata.getGame()) && zzw.equal(snapshotMetadata2.getOwner(), snapshotMetadata.getOwner()) && zzw.equal(snapshotMetadata2.getSnapshotId(), snapshotMetadata.getSnapshotId()) && zzw.equal(snapshotMetadata2.getCoverImageUri(), snapshotMetadata.getCoverImageUri()) && zzw.equal(Float.valueOf(snapshotMetadata2.getCoverImageAspectRatio()), Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())) && zzw.equal(snapshotMetadata2.getTitle(), snapshotMetadata.getTitle()) && zzw.equal(snapshotMetadata2.getDescription(), snapshotMetadata.getDescription()) && zzw.equal(snapshotMetadata2.getLastModifiedTimestamp(), snapshotMetadata.getLastModifiedTimestamp()) && zzw.equal(snapshotMetadata2.getPlayedTime(), snapshotMetadata.getPlayedTime()) && zzw.equal(snapshotMetadata2.getUniqueName(), snapshotMetadata.getUniqueName()) && zzw.equal(snapshotMetadata2.hasChangePending(), snapshotMetadata.hasChangePending()) && zzw.equal(snapshotMetadata2.getProgressValue(), snapshotMetadata.getProgressValue()) && zzw.equal(snapshotMetadata2.getDeviceName(), snapshotMetadata.getDeviceName());
    }

    public String toString() {
        return SnapshotMetadataEntity.zzb(this);
    }

    static String zzb(SnapshotMetadata snapshotMetadata) {
        return zzw.zzv(snapshotMetadata).zzg("Game", snapshotMetadata.getGame()).zzg("Owner", snapshotMetadata.getOwner()).zzg("SnapshotId", snapshotMetadata.getSnapshotId()).zzg("CoverImageUri", snapshotMetadata.getCoverImageUri()).zzg("CoverImageUrl", snapshotMetadata.getCoverImageUrl()).zzg("CoverImageAspectRatio", Float.valueOf(snapshotMetadata.getCoverImageAspectRatio())).zzg("Description", snapshotMetadata.getDescription()).zzg("LastModifiedTimestamp", snapshotMetadata.getLastModifiedTimestamp()).zzg("PlayedTime", snapshotMetadata.getPlayedTime()).zzg("UniqueName", snapshotMetadata.getUniqueName()).zzg("ChangePending", snapshotMetadata.hasChangePending()).zzg("ProgressValue", snapshotMetadata.getProgressValue()).zzg("DeviceName", snapshotMetadata.getDeviceName()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        SnapshotMetadataEntityCreator.zza(this, out, flags);
    }
}

