/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.stats;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.stats.PlayerStats;
import com.google.android.gms.games.stats.PlayerStatsEntityCreator;

public class PlayerStatsEntity
implements SafeParcelable,
PlayerStats {
    public static final Parcelable.Creator<PlayerStatsEntity> CREATOR = new PlayerStatsEntityCreator();
    private final int mVersionCode;
    private final float zzaBX;
    private final float zzaBY;
    private final int zzaBZ;
    private final int zzaCa;
    private final int zzaCb;
    private final float zzaCc;
    private final float zzaCd;

    public PlayerStatsEntity(PlayerStats playerStats) {
        this.mVersionCode = 1;
        this.zzaBX = playerStats.getAverageSessionLength();
        this.zzaBY = playerStats.zzvT();
        this.zzaBZ = playerStats.getDaysSinceLastPlayed();
        this.zzaCa = playerStats.getNumberOfPurchases();
        this.zzaCb = playerStats.getNumberOfSessions();
        this.zzaCc = playerStats.getSessionPercentile();
        this.zzaCd = playerStats.getSpendPercentile();
    }

    PlayerStatsEntity(int versionCode, float averageSessionLength, float churnProbability, int daysSinceLastPlayed, int numberOfPurchases, int numberOfSessions, float sessionPercentile, float spendPercentile) {
        this.mVersionCode = versionCode;
        this.zzaBX = averageSessionLength;
        this.zzaBY = churnProbability;
        this.zzaBZ = daysSinceLastPlayed;
        this.zzaCa = numberOfPurchases;
        this.zzaCb = numberOfSessions;
        this.zzaCc = sessionPercentile;
        this.zzaCd = spendPercentile;
    }

    @Override
    public float getAverageSessionLength() {
        return this.zzaBX;
    }

    @Override
    public float zzvT() {
        return this.zzaBY;
    }

    @Override
    public int getDaysSinceLastPlayed() {
        return this.zzaBZ;
    }

    @Override
    public int getNumberOfPurchases() {
        return this.zzaCa;
    }

    @Override
    public int getNumberOfSessions() {
        return this.zzaCb;
    }

    @Override
    public float getSessionPercentile() {
        return this.zzaCc;
    }

    @Override
    public float getSpendPercentile() {
        return this.zzaCd;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public PlayerStats zzvU() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerStatsEntity.zza(this);
    }

    static int zza(PlayerStats playerStats) {
        return zzw.hashCode(Float.valueOf(playerStats.getAverageSessionLength()), Float.valueOf(playerStats.zzvT()), playerStats.getDaysSinceLastPlayed(), playerStats.getNumberOfPurchases(), playerStats.getNumberOfSessions(), Float.valueOf(playerStats.getSessionPercentile()), Float.valueOf(playerStats.getSpendPercentile()));
    }

    public boolean equals(Object obj) {
        return PlayerStatsEntity.zza(this, obj);
    }

    static boolean zza(PlayerStats playerStats, Object object) {
        if (!(object instanceof PlayerStats)) {
            return false;
        }
        if (playerStats == object) {
            return true;
        }
        PlayerStats playerStats2 = (PlayerStats)object;
        return zzw.equal(Float.valueOf(playerStats2.getAverageSessionLength()), Float.valueOf(playerStats.getAverageSessionLength())) && zzw.equal(Float.valueOf(playerStats2.zzvT()), Float.valueOf(playerStats.zzvT())) && zzw.equal(playerStats2.getDaysSinceLastPlayed(), playerStats.getDaysSinceLastPlayed()) && zzw.equal(playerStats2.getNumberOfPurchases(), playerStats.getNumberOfPurchases()) && zzw.equal(playerStats2.getNumberOfSessions(), playerStats.getNumberOfSessions()) && zzw.equal(Float.valueOf(playerStats2.getSessionPercentile()), Float.valueOf(playerStats.getSessionPercentile())) && zzw.equal(Float.valueOf(playerStats2.getSpendPercentile()), Float.valueOf(playerStats.getSpendPercentile()));
    }

    public String toString() {
        return PlayerStatsEntity.zzb(this);
    }

    static String zzb(PlayerStats playerStats) {
        return zzw.zzv(playerStats).zzg("AverageSessionLength", Float.valueOf(playerStats.getAverageSessionLength())).zzg("ChurnProbability", Float.valueOf(playerStats.zzvT())).zzg("DaysSinceLastPlayed", playerStats.getDaysSinceLastPlayed()).zzg("NumberOfPurchases", playerStats.getNumberOfPurchases()).zzg("NumberOfSessions", playerStats.getNumberOfSessions()).zzg("SessionPercentile", Float.valueOf(playerStats.getSessionPercentile())).zzg("SpendPercentile", Float.valueOf(playerStats.getSpendPercentile())).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerStatsEntityCreator.zza(this, out, flags);
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzvU();
    }
}

