/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.Task;

public class OneoffTask
extends Task {
    private final long zzaCC;
    private final long zzaCD;
    public static final Parcelable.Creator<OneoffTask> CREATOR = new Parcelable.Creator<OneoffTask>(){

        public OneoffTask zzes(Parcel parcel) {
            return new OneoffTask(parcel);
        }

        public OneoffTask[] zzgC(int n) {
            return new OneoffTask[n];
        }

        public /* synthetic */ Object[] newArray(int x0) {
            return this.zzgC(x0);
        }

        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzes(x0);
        }
    };

    private OneoffTask(Builder builder) {
        super(builder);
        this.zzaCC = builder.zzaCE;
        this.zzaCD = builder.zzaCF;
    }

    @Deprecated
    private OneoffTask(Parcel in) {
        super(in);
        this.zzaCC = in.readLong();
        this.zzaCD = in.readLong();
    }

    @Override
    public void toBundle(Bundle bundle) {
        super.toBundle(bundle);
        bundle.putLong("window_start", this.zzaCC);
        bundle.putLong("window_end", this.zzaCD);
    }

    public long getWindowStart() {
        return this.zzaCC;
    }

    public long getWindowEnd() {
        return this.zzaCD;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        super.writeToParcel(parcel, flags);
        parcel.writeLong(this.zzaCC);
        parcel.writeLong(this.zzaCD);
    }

    public String toString() {
        return super.toString() + " " + "windowStart=" + this.getWindowStart() + " " + "windowEnd=" + this.getWindowEnd();
    }

    public static class Builder
    extends Task.Builder {
        private long zzaCE = -1L;
        private long zzaCF = -1L;

        public Builder() {
            this.isPersisted = false;
        }

        public Builder setExecutionWindow(long windowStartDelaySeconds, long windowEndDelaySeconds) {
            this.zzaCE = windowStartDelaySeconds;
            this.zzaCF = windowEndDelaySeconds;
            return this;
        }

        @Override
        public Builder setService(Class<? extends GcmTaskService> gcmTaskService) {
            this.gcmTaskService = gcmTaskService.getName();
            return this;
        }

        @Override
        public Builder setRequiredNetwork(int requiredNetworkState) {
            this.requiredNetworkState = requiredNetworkState;
            return this;
        }

        @Override
        public Builder setRequiresCharging(boolean requiresCharging) {
            this.requiresCharging = requiresCharging;
            return this;
        }

        @Override
        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public Builder setPersisted(boolean isPersisted) {
            this.isPersisted = isPersisted;
            return this;
        }

        @Override
        public Builder setUpdateCurrent(boolean updateCurrent) {
            this.updateCurrent = updateCurrent;
            return this;
        }

        @Override
        public Builder setExtras(Bundle extras) {
            this.extras = extras;
            return this;
        }

        @Override
        protected void checkConditions() {
            super.checkConditions();
            if (this.zzaCE == -1L || this.zzaCF == -1L) {
                throw new IllegalArgumentException("Must specify an execution window using setExecutionWindow.");
            }
            if (this.zzaCE >= this.zzaCF) {
                throw new IllegalArgumentException("Window start must be shorter than window end.");
            }
        }

        @Override
        public OneoffTask build() {
            this.checkConditions();
            return new OneoffTask(this);
        }
    }
}

