/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.zzc;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    public static final int EXTRAS_LIMIT_BYTES = 10240;
    private final String zzaCN;
    private final String mTag;
    private final boolean zzaCO;
    private final boolean zzaCP;
    private final int zzaCQ;
    private final boolean zzaCR;
    private final zzc zzaCS;
    private final Bundle mExtras;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzaCN = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzaCO = builder.updateCurrent;
        this.zzaCP = builder.isPersisted;
        this.zzaCQ = builder.requiredNetworkState;
        this.zzaCR = builder.requiresCharging;
        this.zzaCS = builder.zzaCT;
        this.mExtras = builder.extras;
    }

    @Deprecated
    Task(Parcel in) {
        Log.e((String)"Task", (String)"Constructing a Task object using a parcel.");
        this.zzaCN = in.readString();
        this.mTag = in.readString();
        this.zzaCO = in.readInt() == 1;
        this.zzaCP = in.readInt() == 1;
        this.zzaCQ = 2;
        this.zzaCR = false;
        this.zzaCS = zzc.zzaCI;
        this.mExtras = null;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzaCO);
        bundle.putBoolean("persisted", this.zzaCP);
        bundle.putString("service", this.zzaCN);
        bundle.putInt("requiredNetwork", this.zzaCQ);
        bundle.putBoolean("requiresCharging", this.zzaCR);
        bundle.putBundle("retryStrategy", this.zzaCS.zzz(new Bundle()));
        bundle.putBundle("extras", this.mExtras);
    }

    public String getServiceName() {
        return this.zzaCN;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzaCO;
    }

    public boolean isPersisted() {
        return this.zzaCP;
    }

    public int getRequiredNetwork() {
        return this.zzaCQ;
    }

    public boolean getRequiresCharging() {
        return this.zzaCR;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.zzaCN);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzaCO ? 1 : 0);
        parcel.writeInt(this.zzaCP ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static void zza(zzc zzc2) {
        if (zzc2 != null) {
            int n = zzc2.zzvZ();
            if (n != 1 && n != 0) {
                throw new IllegalArgumentException("Must provide a valid RetryPolicy: " + n);
            }
            int n2 = zzc2.zzwa();
            int n3 = zzc2.zzwb();
            if (n == 0 && n2 < 0) {
                throw new IllegalArgumentException("InitialBackoffSeconds can't be negative: " + n2);
            }
            if (n == 1 && n2 < 10) {
                throw new IllegalArgumentException("RETRY_POLICY_LINEAR must have an initial backoff at least 10 seconds.");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("MaximumBackoffSeconds must be greater than InitialBackoffSeconds: " + zzc2.zzwb());
            }
        }
    }

    public static void zzA(Bundle bundle) {
        if (bundle != null) {
            Parcel parcel = Parcel.obtain();
            bundle.writeToParcel(parcel, 0);
            int n = parcel.dataSize();
            if (n > 10240) {
                parcel.recycle();
                throw new IllegalArgumentException("Extras exceeding maximum size(10240 bytes): " + n);
            }
            parcel.recycle();
            for (String string2 : bundle.keySet()) {
                if (Task.zzz(bundle.get(string2))) continue;
                throw new IllegalArgumentException("Only the following extra parameter types are supported: Integer, Long, Double, String, and Boolean. ");
            }
        }
    }

    private static boolean zzz(Object object) {
        return object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String || object instanceof Boolean;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;
        protected zzc zzaCT = zzc.zzaCI;
        protected Bundle extras;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Builder setExtras(Bundle var1);

        public abstract Task build();

        protected void checkConditions() {
            zzx.zzb(this.gcmTaskService != null, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzdh(this.tag);
            Task.zza(this.zzaCT);
            if (this.isPersisted) {
                Task.zzA(this.extras);
            }
        }
    }
}

