/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import android.util.Log;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

class zza {
    static zza zzaCi;
    private Context mContext;

    static synchronized zza zzaz(Context context) {
        if (zzaCi == null) {
            zzaCi = new zza(context);
        }
        return zzaCi;
    }

    static boolean zzu(Bundle bundle) {
        return zza.zzc(bundle, "gcm.n.icon") != null;
    }

    static String zzc(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzv(Bundle bundle) {
        try {
            Notification notification = this.zzw(bundle);
            this.zza(zza.zzc(bundle, "gcm.n.tag"), notification);
            return true;
        }
        catch (zza zza2) {
            Log.w((String)"GcmNotification", (String)("Failed to show notification: " + zza2.getMessage()));
            return false;
        }
    }

    private Notification zzw(Bundle bundle) {
        Notification notification;
        String string2 = this.zzd(bundle, "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new zza("Missing title");
        }
        String string3 = this.zzd(bundle, "gcm.n.body");
        int n = this.zzdk(zza.zzc(bundle, "gcm.n.icon"));
        Uri uri = this.zzdl(zza.zzc(bundle, "gcm.n.sound"));
        PendingIntent pendingIntent = this.zzx(bundle);
        if (Build.VERSION.SDK_INT >= 11) {
            String string4;
            Notification.Builder builder = new Notification.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n).setContentTitle((CharSequence)string2).setContentText((CharSequence)string3);
            if (Build.VERSION.SDK_INT >= 21 && !TextUtils.isEmpty((CharSequence)(string4 = zza.zzc(bundle, "gcm.n.color")))) {
                builder.setColor(Color.parseColor((String)string4));
            }
            if (uri != null) {
                builder.setSound(uri);
            }
            if (pendingIntent != null) {
                builder.setContentIntent(pendingIntent);
            }
            notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        } else {
            Intent intent;
            if (pendingIntent == null) {
                intent = new Intent();
                intent.setPackage("com.google.example.invalidpackage");
                pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            }
            intent = new NotificationCompat.Builder(this.mContext).setSmallIcon(n).setAutoCancel(true).setContentIntent(pendingIntent).setContentTitle((CharSequence)string2).setContentText((CharSequence)string3);
            if (uri != null) {
                intent.setSound(uri);
            }
            notification = intent.build();
        }
        return notification;
    }

    private void zza(String string2, Notification notification) {
        if (Log.isLoggable((String)"GcmNotification", (int)3)) {
            Log.d((String)"GcmNotification", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "GCM-Notification:" + SystemClock.uptimeMillis();
        }
        notificationManager.notify(string2, 0, notification);
    }

    private String zzd(Bundle bundle, String string2) {
        JSONArray jSONArray;
        String string3 = zza.zzc(bundle, string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        String string4 = zza.zzc(bundle, string2 + "_loc_key");
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string4, "string", this.mContext.getPackageName());
        if (n == 0) {
            throw new zza(this.zzdj(string2 + "_loc_key") + " resource not found: " + string4);
        }
        String string5 = zza.zzc(bundle, string2 + "_loc_args");
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return resources.getString(n);
        }
        try {
            jSONArray = new JSONArray(string5);
        }
        catch (JSONException jSONException) {
            throw new zza("Malformed " + this.zzdj(string2 + "_loc_args") + ": " + string5);
        }
        Object[] objectArray = new String[jSONArray.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = jSONArray.opt(i);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            throw new zza("Missing format argument for " + string4 + ": " + missingFormatArgumentException);
        }
    }

    private String zzdj(String string2) {
        return string2.substring("gcm.n.".length());
    }

    private int zzdk(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new zza("Missing icon");
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string2, "drawable", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        n = resources.getIdentifier(string2, "mipmap", this.mContext.getPackageName());
        if (n != 0) {
            return n;
        }
        throw new zza("Icon resource not found: " + string2);
    }

    private Uri zzdl(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if ("default".equals(string2)) {
            return RingtoneManager.getDefaultUri((int)2);
        }
        throw new zza("Invalid sound: " + string2);
    }

    private PendingIntent zzx(Bundle bundle) {
        String string2 = zza.zzc(bundle, "gcm.n.click_action");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        Intent intent = new Intent(string2);
        intent.setPackage(this.mContext.getPackageName());
        intent.setFlags(0x10000000);
        intent.putExtras(bundle);
        for (String string3 : bundle.keySet()) {
            if (!string3.startsWith("gcm.n.") && !string3.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string3);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzvW(), (Intent)intent, (int)0x40000000);
    }

    private int zzvW() {
        return (int)SystemClock.uptimeMillis();
    }

    private class zza
    extends IllegalArgumentException {
        private zza(String string2) {
            super(string2);
        }
    }
}

