/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;
import java.io.IOException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class InstanceID {
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    public static final String ERROR_TIMEOUT = "TIMEOUT";
    public static final String ERROR_MISSING_INSTANCEID_SERVICE = "MISSING_INSTANCEID_SERVICE";
    public static final String ERROR_BACKOFF = "RETRY_LATER";
    public static final String ERROR_MAIN_THREAD = "MAIN_THREAD";
    static Map<String, InstanceID> zzaDw = new HashMap<String, InstanceID>();
    Context mContext;
    private static zzd zzaDx;
    private static zzc zzaDy;
    KeyPair zzaDz;
    String zzaDA = "";
    long zzaDB;
    static String zzaDC;

    protected InstanceID(Context context, String subtype, Bundle options) {
        this.mContext = context.getApplicationContext();
        this.zzaDA = subtype;
    }

    static int zzaC(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"InstanceID", (String)("Never happens: can't find own package " + (Object)((Object)nameNotFoundException)));
            return 0;
        }
    }

    public static InstanceID getInstance(Context context) {
        return InstanceID.zza(context, null);
    }

    public static synchronized InstanceID zza(Context context, Bundle bundle) {
        String string2;
        String string3 = string2 = bundle == null ? "" : bundle.getString("subtype");
        if (string2 == null) {
            string2 = "";
        }
        context = context.getApplicationContext();
        if (zzaDx == null) {
            zzaDx = new zzd(context);
            zzaDy = new zzc(context);
        }
        zzaDC = Integer.toString(InstanceID.zzaC(context));
        InstanceID instanceID = zzaDw.get(string2);
        if (instanceID == null) {
            instanceID = new InstanceID(context, string2, bundle);
            zzaDw.put(string2, instanceID);
        }
        return instanceID;
    }

    static String zzm(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    KeyPair zzwm() {
        if (this.zzaDz == null) {
            this.zzaDz = zzaDx.zzdq(this.zzaDA);
        }
        if (this.zzaDz == null) {
            this.zzaDB = System.currentTimeMillis();
            this.zzaDz = zzaDx.zze(this.zzaDA, this.zzaDB);
        }
        return this.zzaDz;
    }

    public String getId() {
        return InstanceID.zza(this.zzwm());
    }

    static String zza(KeyPair keyPair) {
        byte[] byArray = keyPair.getPublic().getEncoded();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray2 = messageDigest.digest(byArray);
            int n = byArray2[0];
            n = 112 + (0xF & n);
            byArray2[0] = (byte)(n & 0xFF);
            return Base64.encodeToString((byte[])byArray2, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"InstanceID", (String)"Unexpected error, device missing required alghorithms");
            return null;
        }
    }

    public long getCreationTime() {
        String string2;
        if (this.zzaDB == 0L && (string2 = zzaDx.get(this.zzaDA, "cre")) != null) {
            this.zzaDB = Long.parseLong(string2);
        }
        return this.zzaDB;
    }

    public void deleteInstanceID() throws IOException {
        this.zzb("*", "*", null);
        this.zzwn();
    }

    void zzwn() {
        this.zzaDB = 0L;
        zzaDx.zzdr(this.zzaDA);
        this.zzaDz = null;
    }

    public void deleteToken(String authorizedEntity, String scope) throws IOException {
        this.zzb(authorizedEntity, scope, null);
    }

    public void zzb(String string2, String string3, Bundle bundle) throws IOException {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        zzaDx.zzh(this.zzaDA, string2, string3);
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("sender", string2);
        if (string3 != null) {
            bundle.putString("scope", string3);
        }
        bundle.putString("subscription", string2);
        bundle.putString("delete", "1");
        bundle.putString("X-delete", "1");
        bundle.putString("subtype", "".equals(this.zzaDA) ? string2 : this.zzaDA);
        bundle.putString("X-subtype", "".equals(this.zzaDA) ? string2 : this.zzaDA);
        Intent intent = zzaDy.zza(bundle, this.zzwm());
        zzaDy.zzp(intent);
    }

    zzd zzwo() {
        return zzaDx;
    }

    zzc zzwp() {
        return zzaDy;
    }

    public String getToken(String authorizedEntity, String scope) throws IOException {
        return this.getToken(authorizedEntity, scope, null);
    }

    public String getToken(String authorizedEntity, String scope, Bundle extras) throws IOException {
        String string2;
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IOException(ERROR_MAIN_THREAD);
        }
        boolean bl = true;
        String string3 = string2 = this.zzwq() ? null : zzaDx.zzg(this.zzaDA, authorizedEntity, scope);
        if (string2 != null) {
            return string2;
        }
        if (extras == null) {
            extras = new Bundle();
        }
        if (extras.getString("ttl") != null) {
            bl = false;
        }
        if ("jwt".equals(extras.getString("type"))) {
            bl = false;
        }
        string2 = this.zzc(authorizedEntity, scope, extras);
        Log.w((String)"InstanceID", (String)("token: " + string2));
        if (string2 != null && bl) {
            zzaDx.zza(this.zzaDA, authorizedEntity, scope, string2, zzaDC);
        }
        return string2;
    }

    public String zzc(String string2, String string3, Bundle bundle) throws IOException {
        String string4;
        if (string3 != null) {
            bundle.putString("scope", string3);
        }
        bundle.putString("sender", string2);
        String string5 = string4 = "".equals(this.zzaDA) ? string2 : this.zzaDA;
        if (!bundle.containsKey("legacy.register")) {
            bundle.putString("subscription", string2);
            bundle.putString("subtype", string4);
            bundle.putString("X-subscription", string2);
            bundle.putString("X-subtype", string4);
        }
        Intent intent = zzaDy.zza(bundle, this.zzwm());
        return zzaDy.zzp(intent);
    }

    boolean zzwq() {
        String string2 = zzaDx.get("appVersion");
        if (string2 == null || !string2.equals(zzaDC)) {
            return true;
        }
        String string3 = zzaDx.get("lastToken");
        if (string3 == null) {
            return true;
        }
        Long l2 = Long.parseLong(string3);
        return System.currentTimeMillis() / 1000L - l2 > 604800L;
    }
}

