/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;
import com.google.android.gms.iid.InstanceID;
import com.google.android.gms.iid.InstanceIDListenerService;
import com.google.android.gms.iid.zza;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;

public class zzd {
    SharedPreferences zzaEa;
    Context context;

    public zzd(Context context) {
        this(context, "com.google.android.gms.appid");
    }

    public zzd(Context context, String string2) {
        this.context = context;
        this.zzaEa = context.getSharedPreferences(string2, 4);
        this.zzdo(string2 + "-no-backup");
    }

    private void zzdo(String string2) {
        block4: {
            File file = new ContextCompat().getNoBackupFilesDir(this.context);
            File file2 = new File(file, string2);
            if (file2.exists()) {
                return;
            }
            try {
                if (file2.createNewFile() && !this.isEmpty()) {
                    Log.i((String)"InstanceID/Store", (String)"App restored, clearing state");
                    InstanceIDListenerService.zza(this.context, this);
                }
            }
            catch (IOException iOException) {
                if (!Log.isLoggable((String)"InstanceID/Store", (int)3)) break block4;
                Log.d((String)"InstanceID/Store", (String)("Error creating file in no backup dir: " + iOException.getMessage()));
            }
        }
    }

    boolean isEmpty() {
        return this.zzaEa.getAll().isEmpty();
    }

    private String zzf(String string2, String string3, String string4) {
        return string2 + "|T|" + string3 + "|" + string4;
    }

    synchronized String get(String subtype, String key) {
        return this.zzaEa.getString(subtype + "|S|" + key, null);
    }

    synchronized String get(String key) {
        return this.zzaEa.getString(key, null);
    }

    synchronized void zza(SharedPreferences.Editor editor, String string2, String string3, String string4) {
        editor.putString(string2 + "|S|" + string3, string4);
    }

    public synchronized void zzdp(String string2) {
        SharedPreferences.Editor editor = this.zzaEa.edit();
        Map map = this.zzaEa.getAll();
        for (String string3 : map.keySet()) {
            if (!string3.startsWith(string2)) continue;
            editor.remove(string3);
        }
        editor.commit();
    }

    public synchronized void zzwt() {
        this.zzaEa.edit().clear().commit();
    }

    public synchronized String zzg(String string2, String string3, String string4) {
        String string5 = this.zzf(string2, string3, string4);
        String string6 = this.zzaEa.getString(string5, null);
        return string6;
    }

    public synchronized void zza(String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.zzf(string2, string3, string4);
        SharedPreferences.Editor editor = this.zzaEa.edit();
        editor.putString(string7, string5);
        editor.putString("appVersion", string6);
        editor.putString("lastToken", Long.toString(System.currentTimeMillis() / 1000L));
        editor.commit();
    }

    public synchronized void zzh(String string2, String string3, String string4) {
        String string5 = this.zzf(string2, string3, string4);
        SharedPreferences.Editor editor = this.zzaEa.edit();
        editor.remove(string5);
        editor.commit();
    }

    public KeyPair zzdq(String string2) {
        return this.zzdt(string2);
    }

    synchronized KeyPair zze(String string2, long l2) {
        KeyPair keyPair = zza.zzwl();
        SharedPreferences.Editor editor = this.zzaEa.edit();
        this.zza(editor, string2, "|P|", InstanceID.zzm(keyPair.getPublic().getEncoded()));
        this.zza(editor, string2, "|K|", InstanceID.zzm(keyPair.getPrivate().getEncoded()));
        this.zza(editor, string2, "cre", Long.toString(l2));
        editor.commit();
        return keyPair;
    }

    void zzdr(String string2) {
        this.zzdp(string2 + "|");
    }

    public void zzds(String string2) {
        this.zzdp(string2 + "|T|");
    }

    KeyPair zzdt(String string2) {
        String string3 = this.get(string2, "|P|");
        String string4 = this.get(string2, "|K|");
        if (string4 == null) {
            return null;
        }
        try {
            byte[] byArray = Base64.decode((String)string3, (int)8);
            byte[] byArray2 = Base64.decode((String)string4, (int)8);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
            PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
            return new KeyPair(publicKey, privateKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            Log.w((String)"InstanceID/Store", (String)("Invalid key stored " + generalSecurityException));
            InstanceIDListenerService.zza(this.context, this);
            return null;
        }
    }
}

