/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzao;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zziz;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public final class zzdj {
    public static final zzdk zzxo = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
        }
    };
    public static final zzdk zzxp = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzb.zzaH("URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zziz2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zziz2.zzb("openableURLs", hashMap);
        }
    };
    public static final zzdk zzxq = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zziz2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zziz2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zziz2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error parsing the intent data.", jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                String string9 = jSONObject3.optString("f");
                String string10 = jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzb.zzb("Error constructing openable urls response.", jSONException);
                }
            }
            zziz2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzdk zzxr = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaH("URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zziz2.zzhg();
                if (object != null && ((zzan)object).zzb(uri)) {
                    uri = ((zzan)object).zza(uri, zziz2.getContext());
                }
            }
            catch (zzao zzao2) {
                zzb.zzaH("Unable to append parameter to URL: " + string2);
            }
            string2 = uri.toString();
            object = new zzij(zziz2.getContext(), zziz2.zzhh().zzJu, string2);
            ((zzhz)object).zzgz();
        }
    };
    public static final zzdk zzxs = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            zzd zzd2 = zziz2.zzhc();
            if (zzd2 != null) {
                zzd2.close();
            } else {
                zzd zzd3 = zziz2.zzhd();
                if (zzd3 != null) {
                    zzd3.close();
                } else {
                    zzb.zzaH("A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzdk zzxt = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            zziz2.zzD("1".equals(map.get("custom_close")));
        }
    };
    public static final zzdk zzxu = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzb.zzaH("URL missing from httpTrack GMSG.");
                return;
            }
            zzij zzij2 = new zzij(zziz2.getContext(), zziz2.zzhh().zzJu, string2);
            zzij2.zzgz();
        }
    };
    public static final zzdk zzxv = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            zzb.zzaG("Received log message: " + map.get("string"));
        }
    };
    public static final zzdk zzxw = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzan zzan2 = zziz2.zzhg();
                if (zzan2 != null) {
                    zzaj zzaj2 = zzan2.zzab();
                    zzaj2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzb.zzaH("Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzdk zzxx = new zzdk(){

        @Override
        public void zza(zziz zziz2, Map<String, String> map) {
            if (!zzby.zzvs.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zziz2.zzE(!bl);
        }
    };
    public static final zzdk zzxy = new zzds();
    public static final zzdk zzxz = new zzdw();
    public static final zzdk zzxA = new zzdi();
}

