/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzfi;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@zzgr
public class zzfc
extends zzfh {
    static final Set<String> zzAb = new HashSet<String>(Arrays.asList("top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"));
    private String zzAc = "top-right";
    private boolean zzAd = true;
    private int zzAe = 0;
    private int zzAf = 0;
    private int zznR = -1;
    private int zzAg = 0;
    private int zzAh = 0;
    private int zznQ = -1;
    private final Object zzpd = new Object();
    private final zziz zzoM;
    private final Activity zzAi;
    private AdSizeParcel zzzm;
    private ImageView zzAj;
    private LinearLayout zzAk;
    private zzfi zzAl;
    private PopupWindow zzAm;
    private RelativeLayout zzAn;
    private ViewGroup zzAo;

    public zzfc(zziz zziz2, zzfi zzfi2) {
        super(zziz2, "resize");
        this.zzoM = zziz2;
        this.zzAi = zziz2.zzgZ();
        this.zzAl = zzfi2;
    }

    private void zzf(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zznQ = zzp.zzbv().zzaA(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zznR = zzp.zzbv().zzaA(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzAg = zzp.zzbv().zzaA(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzAh = zzp.zzbv().zzaA(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzAd = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzAc = string2;
        }
    }

    boolean zzed() {
        return this.zznQ > -1 && this.zznR > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzg(Map<String, String> map) {
        Object object = this.zzpd;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzAi == null) {
                this.zzak("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzoM.zzaN() == null) {
                this.zzak("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzoM.zzaN().zztf) {
                this.zzak("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzoM.zzhi()) {
                this.zzak("Cannot resize an expanded banner.");
                return;
            }
            this.zzf(map);
            if (!this.zzed()) {
                this.zzak("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzAi.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzak("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzee();
            if (nArray == null) {
                this.zzak("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzl.zzcF().zzb((Context)this.zzAi, this.zznQ);
            int n2 = zzl.zzcF().zzb((Context)this.zzAi, this.zznR);
            ViewParent viewParent = this.zzoM.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzoM.getView());
                if (this.zzAm == null) {
                    this.zzAo = (ViewGroup)viewParent;
                    bitmap = zzp.zzbv().zzk(this.zzoM.getView());
                    this.zzAj = new ImageView((Context)this.zzAi);
                    this.zzAj.setImageBitmap(bitmap);
                    this.zzzm = this.zzoM.zzaN();
                    this.zzAo.addView((View)this.zzAj);
                } else {
                    this.zzAm.dismiss();
                }
            } else {
                this.zzak("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzAn = new RelativeLayout((Context)this.zzAi);
            this.zzAn.setBackgroundColor(0);
            this.zzAn.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzAm = zzp.zzbv().zza((View)this.zzAn, n, n2, false);
            this.zzAm.setOutsideTouchable(true);
            this.zzAm.setTouchable(true);
            this.zzAm.setClippingEnabled(!this.zzAd);
            this.zzAn.addView(this.zzoM.getView(), -1, -1);
            this.zzAk = new LinearLayout((Context)this.zzAi);
            bitmap = new RelativeLayout.LayoutParams(zzl.zzcF().zzb((Context)this.zzAi, 50), zzl.zzcF().zzb((Context)this.zzAi, 50));
            switch (this.zzAc) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzAk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzfc.this.zzn(true);
                }
            });
            this.zzAk.setContentDescription((CharSequence)"Close button");
            this.zzAn.addView((View)this.zzAk, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzAm.showAtLocation(window.getDecorView(), 0, zzl.zzcF().zzb((Context)this.zzAi, nArray[0]), zzl.zzcF().zzb((Context)this.zzAi, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                this.zzak("Cannot show popup window: " + runtimeException.getMessage());
                this.zzAn.removeView(this.zzoM.getView());
                if (this.zzAo != null) {
                    this.zzAo.removeView((View)this.zzAj);
                    this.zzAo.addView(this.zzoM.getView());
                    this.zzoM.zza(this.zzzm);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzoM.zza(new AdSizeParcel((Context)this.zzAi, new AdSize(this.zznQ, this.zznR)));
            this.zzc(nArray[0], nArray[1]);
            this.zzam("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            if (this.zzAm != null) {
                this.zzAm.dismiss();
                this.zzAn.removeView(this.zzoM.getView());
                if (this.zzAo != null) {
                    this.zzAo.removeView((View)this.zzAj);
                    this.zzAo.addView(this.zzoM.getView());
                    this.zzoM.zza(this.zzzm);
                }
                if (bl) {
                    this.zzam("default");
                    if (this.zzAl != null) {
                        this.zzAl.zzbc();
                    }
                }
                this.zzAm = null;
                this.zzAn = null;
                this.zzAo = null;
                this.zzAk = null;
            }
        }
    }

    private int[] zzee() {
        if (!this.zzeg()) {
            return null;
        }
        if (this.zzAd) {
            return new int[]{this.zzAe + this.zzAg, this.zzAf + this.zzAh};
        }
        int[] nArray = zzp.zzbv().zzh(this.zzAi);
        int[] nArray2 = zzp.zzbv().zzj(this.zzAi);
        int n = nArray[0];
        int n2 = this.zzAe + this.zzAg;
        int n3 = this.zzAf + this.zzAh;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zznQ > n) {
            n2 = n - this.zznQ;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zznR > nArray2[1]) {
            n3 = nArray2[1] - this.zznR;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzAe = n;
            this.zzAf = n2;
            if (this.zzAm != null && bl) {
                int[] nArray = this.zzee();
                if (nArray != null) {
                    this.zzAm.update(zzl.zzcF().zzb((Context)this.zzAi, nArray[0]), zzl.zzcF().zzb((Context)this.zzAi, nArray[1]), this.zzAm.getWidth(), this.zzAm.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzn(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzAl != null) {
            this.zzAl.zza(n, n2, this.zznQ, this.zznR);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzp.zzbv().zzj(this.zzAi)[0];
        this.zzb(n, n2 - n3, this.zznQ, this.zznR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzef() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzAm != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzAe = n;
        this.zzAf = n2;
    }

    boolean zzeg() {
        int[] nArray = zzp.zzbv().zzh(this.zzAi);
        int[] nArray2 = zzp.zzbv().zzj(this.zzAi);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zznQ < 50 || this.zznQ > n) {
            zzb.zzaH("Width is too small or too large.");
            return false;
        }
        if (this.zznR < 50 || this.zznR > n2) {
            zzb.zzaH("Height is too small or too large.");
            return false;
        }
        if (this.zznR == n2 && this.zznQ == n) {
            zzb.zzaH("Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzAd) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzAc) {
                case "top-left": {
                    n3 = this.zzAe + this.zzAg;
                    n4 = this.zzAf + this.zzAh;
                    break;
                }
                case "top-center": {
                    n3 = this.zzAe + this.zzAg + this.zznQ / 2 - 25;
                    n4 = this.zzAf + this.zzAh;
                    break;
                }
                case "center": {
                    n3 = this.zzAe + this.zzAg + this.zznQ / 2 - 25;
                    n4 = this.zzAf + this.zzAh + this.zznR / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzAe + this.zzAg;
                    n4 = this.zzAf + this.zzAh + this.zznR - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzAe + this.zzAg + this.zznQ / 2 - 25;
                    n4 = this.zzAf + this.zzAh + this.zznR - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzAe + this.zzAg + this.zznQ - 50;
                    n4 = this.zzAf + this.zzAh + this.zznR - 50;
                    break;
                }
                default: {
                    n3 = this.zzAe + this.zzAg + this.zznQ - 50;
                    n4 = this.zzAf + this.zzAh;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

