/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;
import java.util.Map;

@zzgr
public class zzfe
extends zzfh {
    private final Map<String, String> zzvS;
    private final Context mContext;

    public zzfe(zziz zziz2, Map<String, String> map) {
        super(zziz2, "storePicture");
        this.zzvS = map;
        this.mContext = zziz2.zzgZ();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzak("Activity context is not available");
            return;
        }
        zzbq zzbq2 = zzp.zzbv().zzL(this.mContext);
        if (!zzbq2.zzcY()) {
            this.zzak("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzvS.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzak("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzak("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzaj(string2);
        if (!zzp.zzbv().zzaB(string3)) {
            this.zzak("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzp.zzbv().zzK(this.mContext);
        builder.setTitle((CharSequence)zzp.zzby().zzd(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzp.zzby().zzd(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzp.zzby().zzd(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzfe.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzfe.this.zzg(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzfe.this.zzak("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzp.zzby().zzd(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzfe.this.zzak("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzg(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzp.zzbx().zza(request);
        return request;
    }

    String zzaj(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

