/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.formats.zzc;
import com.google.android.gms.ads.internal.formats.zzf;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzan;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zziq;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzmt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public class zzgm
implements Callable<zzhs> {
    private static final long zzDE = TimeUnit.SECONDS.toMillis(60L);
    private final Context mContext;
    private final zzih zzDF;
    private final zzn zzDG;
    private final zzan zzwL;
    private final zzbc zzDH;
    private final Object zzpd = new Object();
    private final zzhs.zza zzDe;
    private boolean zzDI;
    private int zzDv;
    private List<String> zzDJ;

    public zzgm(Context context, zzn zzn2, zzbc zzbc2, zzih zzih2, zzan zzan2, zzhs.zza zza2) {
        this.mContext = context;
        this.zzDG = zzn2;
        this.zzDF = zzih2;
        this.zzDH = zzbc2;
        this.zzDe = zza2;
        this.zzwL = zzan2;
        this.zzDI = false;
        this.zzDv = -2;
        this.zzDJ = null;
    }

    public zzhs zzfB() {
        try {
            zzbb zzbb2 = this.zzfC();
            JSONObject jSONObject = this.zzb(zzbb2);
            zza zza2 = this.zzd(jSONObject);
            zzh.zza zza3 = this.zza(zzbb2, zza2, jSONObject);
            this.zza(zza3, zzbb2);
            zzhs zzhs2 = this.zza(zza3);
            return zzhs2;
        }
        catch (CancellationException cancellationException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JSONException jSONException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Malformed native JSON response.", jSONException);
        }
        catch (TimeoutException timeoutException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Timeout when loading native ad.", timeoutException);
        }
        if (!this.zzDI) {
            this.zzC(0);
        }
        return this.zza(null);
    }

    private zzbb zzfC() throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        if (this.zzfD()) {
            return null;
        }
        String string2 = zzby.zzvj.get();
        String string3 = this.zzDe.zzHD.zzBF.indexOf("https") == 0 ? "https:" : "http:";
        String string4 = string3 + string2;
        zzbb zzbb2 = this.zzDH.zza(this.mContext, this.zzDe.zzHC.zzqj, string4, this.zzwL).get(zzDE, TimeUnit.MILLISECONDS);
        zzbb2.zza(this.zzDG, this.zzDG, this.zzDG, this.zzDG, false, null, null, null, null);
        return zzbb2;
    }

    private JSONObject zzb(final zzbb zzbb2) throws TimeoutException, JSONException {
        zzdk zzdk2;
        if (this.zzfD()) {
            return null;
        }
        final zzin zzin2 = new zzin();
        final zzb zzb2 = new zzb();
        zzb2.zzDZ = zzdk2 = new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                zzbb2.zzb("/nativeAdPreProcess", zzb2.zzDZ);
                try {
                    String string2 = map.get("success");
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        zzin2.zzf(new JSONObject(string2).getJSONArray("ads").getJSONObject(0));
                        return;
                    }
                }
                catch (JSONException jSONException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Malformed native JSON response.", jSONException);
                }
                zzgm.this.zzC(0);
                zzx.zza(zzgm.this.zzfD(), (Object)"Unable to set the ad state error!");
                zzin2.zzf(null);
            }
        };
        zzbb2.zza("/nativeAdPreProcess", zzdk2);
        JSONObject jSONObject = new JSONObject(this.zzDe.zzHD.body);
        zzbb2.zza("google.afma.nativeAds.preProcessJsonGmsg", jSONObject);
        return (JSONObject)zzin2.get(zzDE, TimeUnit.MILLISECONDS);
    }

    protected zza zzd(JSONObject jSONObject) throws JSONException, TimeoutException {
        boolean bl;
        if (this.zzfD()) {
            return null;
        }
        String string2 = jSONObject.getString("template_id");
        boolean bl2 = this.zzDe.zzHC.zzqB != null ? this.zzDe.zzHC.zzqB.zzwR : false;
        boolean bl3 = bl = this.zzDe.zzHC.zzqB != null ? this.zzDe.zzHC.zzqB.zzwT : false;
        if ("2".equals(string2)) {
            return new zzgn(bl2, bl);
        }
        if ("1".equals(string2)) {
            return new zzgo(bl2, bl);
        }
        if ("3".equals(string2)) {
            final String string3 = jSONObject.getString("custom_template_id");
            final zzin zzin2 = new zzin();
            zzid.zzIE.post(new Runnable(){

                @Override
                public void run() {
                    zzin2.zzf(zzgm.this.zzDG.zzbo().get(string3));
                }
            });
            if (zzin2.get(zzDE, TimeUnit.MILLISECONDS) != null) {
                return new zzgp(bl2);
            }
            com.google.android.gms.ads.internal.util.client.zzb.e("No handler for custom template: " + jSONObject.getString("custom_template_id"));
        } else {
            this.zzC(0);
        }
        return null;
    }

    private void zza(zzh.zza zza2, zzbb zzbb2) {
        zzdk zzdk2;
        if (!(zza2 instanceof zzf)) {
            return;
        }
        final zzf zzf2 = (zzf)zza2;
        zzb zzb2 = new zzb();
        zzb2.zzDZ = zzdk2 = new zzdk(){

            @Override
            public void zza(zziz zziz2, Map<String, String> map) {
                String string2 = map.get("asset");
                zzgm.this.zzb(zzf2, string2);
            }
        };
        zzbb2.zza("/nativeAdCustomClick", zzdk2);
    }

    private void zzb(zzcu zzcu2, String string2) {
        try {
            zzcy zzcy2 = this.zzDG.zzr(zzcu2.getCustomTemplateId());
            if (zzcy2 != null) {
                zzcy2.zza(zzcu2, string2);
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Failed to call onCustomClick for asset " + string2 + ".", remoteException);
        }
    }

    private zzh.zza zza(zzbb zzbb2, zza zza2, JSONObject jSONObject) throws ExecutionException, InterruptedException, JSONException {
        if (this.zzfD()) {
            return null;
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("tracking_urls_and_actions");
        String[] stringArray = this.zzc(jSONObject2, "impression_tracking_urls");
        this.zzDJ = stringArray == null ? null : Arrays.asList(stringArray);
        Object t = zza2.zza(this, jSONObject);
        if (t == null) {
            com.google.android.gms.ads.internal.util.client.zzb.e("Failed to retrieve ad assets.");
            return null;
        }
        t.zza(new zzh(this.mContext, this.zzDG, zzbb2, this.zzwL, jSONObject, (zzh.zza)t, this.zzDe.zzHC.zzqj));
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzhs zza(zzh.zza zza2) {
        int n;
        Object object = this.zzpd;
        synchronized (object) {
            n = this.zzDv;
            if (zza2 == null && this.zzDv == -2) {
                n = 0;
            }
        }
        if (n != -2) {
            zza2 = null;
        }
        return new zzhs(this.zzDe.zzHC.zzEn, null, this.zzDe.zzHD.zzyY, n, this.zzDe.zzHD.zzyZ, this.zzDJ, this.zzDe.zzHD.orientation, this.zzDe.zzHD.zzzc, this.zzDe.zzHC.zzEq, false, null, null, null, null, null, 0L, this.zzDe.zzqn, this.zzDe.zzHD.zzEJ, this.zzDe.zzHz, this.zzDe.zzHA, this.zzDe.zzHD.zzEP, this.zzDe.zzHw, zza2);
    }

    public zziq<com.google.android.gms.ads.internal.formats.zza> zze(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject.optJSONObject("attribution");
        if (jSONObject2 == null) {
            return new zzio<Object>(null);
        }
        final String string2 = jSONObject2.optString("text");
        final int n = jSONObject2.optInt("text_size", -1);
        final Integer n2 = this.zzb(jSONObject2, "text_color");
        final Integer n3 = this.zzb(jSONObject2, "bg_color");
        final int n4 = jSONObject2.optInt("animation_ms", 1000);
        final int n5 = jSONObject2.optInt("presentation_ms", 4000);
        ArrayList arrayList = new ArrayList<zziq<zzc>>();
        if (jSONObject2.optJSONArray("images") != null) {
            arrayList = this.zza(jSONObject2, "images", false, false, true);
        } else {
            arrayList.add(this.zza(jSONObject2, "image", false, false));
        }
        zziq zziq2 = zzip.zzh(arrayList);
        return zzip.zza(zziq2, new zzip.zza<List<zzc>, com.google.android.gms.ads.internal.formats.zza>(){

            public com.google.android.gms.ads.internal.formats.zza zzf(List<zzc> list) {
                try {
                    return list == null || list.isEmpty() ? null : new com.google.android.gms.ads.internal.formats.zza(string2, zzgm.zzd(list), n3, n2, n > 0 ? Integer.valueOf(n) : null, n5 + n4);
                }
                catch (RemoteException remoteException) {
                    com.google.android.gms.ads.internal.util.client.zzb.zzb("Could not get attribution icon", remoteException);
                    return null;
                }
            }

            @Override
            public /* synthetic */ Object zze(Object object) {
                return this.zzf((List)object);
            }
        });
    }

    private Integer zzb(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            int n = jSONObject2.getInt("r");
            int n2 = jSONObject2.getInt("g");
            int n3 = jSONObject2.getInt("b");
            return Color.rgb((int)n, (int)n2, (int)n3);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public Future<zzc> zza(JSONObject jSONObject, String string2, boolean bl) throws JSONException {
        JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
        boolean bl2 = jSONObject2.optBoolean("require", true);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl2, bl);
    }

    public zziq<zzc> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2) throws JSONException {
        JSONObject jSONObject2 = bl ? jSONObject.getJSONObject(string2) : jSONObject.optJSONObject(string2);
        jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
        return this.zza(jSONObject2, bl, bl2);
    }

    public List<zziq<zzc>> zza(JSONObject jSONObject, String string2, boolean bl, boolean bl2, boolean bl3) throws JSONException {
        JSONArray jSONArray = bl ? jSONObject.getJSONArray(string2) : jSONObject.optJSONArray(string2);
        ArrayList<zziq<zzc>> arrayList = new ArrayList<zziq<zzc>>();
        if (jSONArray == null || jSONArray.length() == 0) {
            this.zza(0, bl);
            return arrayList;
        }
        int n = bl3 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            jSONObject2 = jSONObject2 == null ? new JSONObject() : jSONObject2;
            arrayList.add(this.zza(jSONObject2, bl, bl2));
        }
        return arrayList;
    }

    private zziq<zzc> zza(JSONObject jSONObject, final boolean bl, boolean bl2) throws JSONException {
        final String string2 = bl ? jSONObject.getString("url") : jSONObject.optString("url");
        final double d = jSONObject.optDouble("scale", 1.0);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zza(0, bl);
            return new zzio<Object>(null);
        }
        if (bl2) {
            return new zzio<zzc>(new zzc(null, Uri.parse((String)string2), d));
        }
        return this.zzDF.zza(string2, new zzih.zza<zzc>(){

            public zzc zzfE() {
                zzgm.this.zza(2, bl);
                return null;
            }

            public zzc zzg(InputStream inputStream) {
                byte[] byArray = null;
                try {
                    byArray = zzmt.zzk(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray == null) {
                    zzgm.this.zza(2, bl);
                    return null;
                }
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                if (bitmap == null) {
                    zzgm.this.zza(2, bl);
                    return null;
                }
                bitmap.setDensity((int)(160.0 * d));
                return new zzc((Drawable)new BitmapDrawable(Resources.getSystem(), bitmap), Uri.parse((String)string2), d);
            }

            @Override
            public /* synthetic */ Object zzfF() {
                return this.zzfE();
            }

            @Override
            public /* synthetic */ Object zzh(InputStream inputStream) {
                return this.zzg(inputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzfD() {
        Object object = this.zzpd;
        synchronized (object) {
            return this.zzDI;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzC(int n) {
        Object object = this.zzpd;
        synchronized (object) {
            this.zzDI = true;
            this.zzDv = n;
        }
    }

    public void zza(int n, boolean bl) {
        if (bl) {
            this.zzC(n);
        }
    }

    private String[] zzc(JSONObject jSONObject, String string2) throws JSONException {
        JSONArray jSONArray = jSONObject.optJSONArray(string2);
        if (jSONArray == null) {
            return null;
        }
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            stringArray[i] = jSONArray.getString(i);
        }
        return stringArray;
    }

    private static List<Drawable> zzd(List<zzc> list) throws RemoteException {
        ArrayList<Drawable> arrayList = new ArrayList<Drawable>();
        for (zzc zzc2 : list) {
            arrayList.add((Drawable)zze.zzp(zzc2.zzdv()));
        }
        return arrayList;
    }

    @Override
    public /* synthetic */ Object call() throws Exception {
        return this.zzfB();
    }

    class zzb {
        public zzdk zzDZ;

        zzb() {
        }
    }

    public static interface zza<T extends zzh.zza> {
        public T zza(zzgm var1, JSONObject var2) throws JSONException, InterruptedException, ExecutionException;
    }
}

