/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.client.zzl;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.GetRecentContextCall;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zza;
import com.google.android.gms.appindexing.AndroidAppUri;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgy;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhy;
import com.google.android.gms.internal.zzmm;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzgr
public final class zzgu {
    private static final SimpleDateFormat zzFN = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzgy zzgy2, zzhb.zza zza2, Location location, zzbr zzbr2, String string2, String string3, List<String> list) {
        try {
            StringBuilder stringBuilder;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzEm != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzEm);
            }
            zzgu.zza(hashMap, adRequestInfoParcel.zzEn);
            hashMap.put("format", adRequestInfoParcel.zzqn.zzte);
            if (adRequestInfoParcel.zzqn.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzqn.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzqn.zzti) {
                hashMap.put("fluid", "height");
            }
            if (adRequestInfoParcel.zzqn.zztg != null) {
                stringBuilder = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzqn.zztg) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzgy2.zzEz) : adSizeParcel.width);
                    stringBuilder.append("x");
                    stringBuilder.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzgy2.zzEz) : adSizeParcel.height);
                }
                hashMap.put("sz", stringBuilder);
            }
            if (adRequestInfoParcel.zzEt != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzEt);
                hashMap.put("native_templates", adRequestInfoParcel.zzqD);
                hashMap.put("native_image_orientation", zzgu.zzc(adRequestInfoParcel.zzqB));
                if (!adRequestInfoParcel.zzEE.isEmpty()) {
                    hashMap.put("native_custom_templates", adRequestInfoParcel.zzEE);
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzqh);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzEo != null) {
                hashMap.put("vc", adRequestInfoParcel.zzEo.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzEq);
            hashMap.put("session_id", adRequestInfoParcel.zzEr);
            hashMap.put("js", adRequestInfoParcel.zzqj.zzJu);
            zzgu.zza(hashMap, zzgy2, zza2);
            hashMap.put("fdz", zzbr2.zzdd());
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (adRequestInfoParcel.zzEn.versionCode >= 2 && adRequestInfoParcel.zzEn.zzsJ != null) {
                zzgu.zza(hashMap, adRequestInfoParcel.zzEn.zzsJ);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzEs);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzEv) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzEv);
            }
            stringBuilder = null;
            stringBuilder = adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzEu != null ? adRequestInfoParcel.zzEu : new Bundle();
            zzgu.zza(context, adRequestInfoParcel, (Bundle)stringBuilder);
            hashMap.put("content_info", stringBuilder);
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzEz));
                hashMap.put("sh", adRequestInfoParcel.zzEy);
                hashMap.put("sw", adRequestInfoParcel.zzEx);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzgy2.zzEz));
                hashMap.put("sh", zzgy2.zzEy);
                hashMap.put("sw", zzgy2.zzEx);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzEA)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzEA));
                    }
                    catch (JSONException jSONException) {
                        zzb.zzd("Problem serializing view hierarchy to JSON", jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzEB);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzEC);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzEG != null) {
                hashMap.put("capability", adRequestInfoParcel.zzEG.toBundle());
            }
            zzgu.zza(hashMap, string2);
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzEH)) {
                hashMap.put("anchor", adRequestInfoParcel.zzEH);
            }
            if (zzb.zzN(2)) {
                String string4 = zzp.zzbv().zzz(hashMap).toString(2);
                zzb.v("Ad Request JSON: " + string4);
            }
            return zzp.zzbv().zzz(hashMap);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Problem serializing ad request to JSON: " + jSONException.getMessage());
            return null;
        }
    }

    static void zza(Context context, AdRequestInfoParcel adRequestInfoParcel, Bundle bundle) {
        if (!zzby.zzuZ.get().booleanValue()) {
            zzb.zzaG("App index is not enabled");
            return;
        }
        if (!zzmm.zzjA()) {
            zzb.zzaG("Not on service, return");
            return;
        }
        if (zzl.zzcF().zzgT()) {
            zzb.zzaG("Cannot invoked on UI thread");
            return;
        }
        if (adRequestInfoParcel == null || adRequestInfoParcel.zzEo == null) {
            zzb.zzaH("Invalid ad request info");
            return;
        }
        String string2 = adRequestInfoParcel.zzEo.packageName;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzb.zzaH("Fail to get package name");
            return;
        }
        try {
            UsageInfo usageInfo = zzgu.zzd(context, string2);
            zzgu.zza(usageInfo, string2, bundle);
        }
        catch (RuntimeException runtimeException) {
            zzb.zzaG("Fail to add app index to content info");
        }
    }

    static void zza(UsageInfo usageInfo, String string2, Bundle bundle) {
        if (usageInfo == null || usageInfo.zzlu() == null) {
            return;
        }
        DocumentContents documentContents = usageInfo.zzlu();
        String string3 = documentContents.zzln();
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("web_url", string3);
        }
        try {
            DocumentSection documentSection = documentContents.zzbw("intent_data");
            if (documentSection != null && !TextUtils.isEmpty((CharSequence)documentSection.zzQj)) {
                Uri uri = Uri.parse((String)documentSection.zzQj);
                AndroidAppUri androidAppUri = AndroidAppUri.newAndroidAppUri(string2, uri);
                bundle.putString("app_uri", androidAppUri.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzb.zzaH("Failed to parse the third-party Android App URI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UsageInfo zzd(Context context, String string2) {
        GoogleApiClient googleApiClient = null;
        UsageInfo usageInfo = null;
        try {
            googleApiClient = new GoogleApiClient.Builder(context).addApi(zza.zzPV).build();
            googleApiClient.connect();
            GetRecentContextCall.Request request = new GetRecentContextCall.Request.zza().zzL(true).zzby(string2).zzlr();
            GetRecentContextCall.Response response = zza.zzPW.zza(googleApiClient, request).await(1L, TimeUnit.SECONDS);
            if (response == null || !response.getStatus().isSuccess()) {
                zzb.zzaG("Fail to obtain recent context call");
                UsageInfo usageInfo2 = null;
                return usageInfo2;
            }
            if (response.zzQB == null || response.zzQB.isEmpty()) {
                zzb.zzaG("Fail to obtain recent context");
                UsageInfo usageInfo3 = null;
                return usageInfo3;
            }
            usageInfo = response.zzQB.get(0);
        }
        catch (SecurityException securityException) {
            zzb.zzaH("Fail to get recent context");
        }
        finally {
            if (googleApiClient != null) {
                googleApiClient.disconnect();
            }
        }
        return usageInfo;
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        if (string2 != null) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("token", string2);
            hashMap.put("pan", hashMap2);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzhy.zzgy();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzsB != -1L) {
            hashMap.put("cust_age", zzFN.format(new Date(adRequestParcel.zzsB)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzsC != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzsC);
        }
        if (adRequestParcel.zzsD != null) {
            hashMap.put("kw", adRequestParcel.zzsD);
        }
        if (adRequestParcel.zzsF != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzsF);
        }
        if (adRequestParcel.zzsE) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzsG) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzsH)) {
                hashMap.put("ppid", adRequestParcel.zzsH);
            }
            if (adRequestParcel.zzsI != null) {
                zzgu.zza(hashMap, adRequestParcel.zzsI);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzsK != null) {
            hashMap.put("url", adRequestParcel.zzsK);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzsM != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzsM);
            }
            if (adRequestParcel.zzsN != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzsN);
            }
            if (adRequestParcel.zzsO != null) {
                hashMap.put("request_agent", adRequestParcel.zzsO);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzsP != null) {
            hashMap.put("request_pkg", adRequestParcel.zzsP);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzgy zzgy2, zzhb.zza zza2) {
        hashMap.put("am", zzgy2.zzGs);
        hashMap.put("cog", zzgu.zzx(zzgy2.zzGt));
        hashMap.put("coh", zzgu.zzx(zzgy2.zzGu));
        if (!TextUtils.isEmpty((CharSequence)zzgy2.zzGv)) {
            hashMap.put("carrier", zzgy2.zzGv);
        }
        hashMap.put("gl", zzgy2.zzGw);
        if (zzgy2.zzGx) {
            hashMap.put("simulator", 1);
        }
        if (zzgy2.zzGy) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzgu.zzx(zzgy2.zzGz));
        hashMap.put("sp", zzgu.zzx(zzgy2.zzGA));
        hashMap.put("hl", zzgy2.zzGB);
        if (!TextUtils.isEmpty((CharSequence)zzgy2.zzGC)) {
            hashMap.put("mv", zzgy2.zzGC);
        }
        hashMap.put("muv", zzgy2.zzGD);
        if (zzgy2.zzGE != -2) {
            hashMap.put("cnt", zzgy2.zzGE);
        }
        hashMap.put("gnt", zzgy2.zzGF);
        hashMap.put("pt", zzgy2.zzGG);
        hashMap.put("rm", zzgy2.zzGH);
        hashMap.put("riv", zzgy2.zzGI);
        Bundle bundle = new Bundle();
        bundle.putString("build", zzgy2.zzGN);
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("is_charging", zzgy2.zzGK);
        bundle2.putDouble("battery_level", zzgy2.zzGJ);
        bundle.putBundle("battery", bundle2);
        Bundle bundle3 = new Bundle();
        bundle3.putInt("active_network_state", zzgy2.zzGM);
        bundle3.putBoolean("active_network_metered", zzgy2.zzGL);
        if (zza2 != null) {
            Bundle bundle4 = new Bundle();
            bundle4.putInt("predicted_latency_micros", zza2.zzGS);
            bundle4.putLong("predicted_down_throughput_bps", zza2.zzGT);
            bundle4.putLong("predicted_up_throughput_bps", zza2.zzGU);
            bundle3.putBundle("predictions", bundle4);
        }
        bundle.putBundle("network", bundle3);
        hashMap.put("device", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l2 = location.getTime() * 1000L;
        Long l3 = (long)(location.getLatitude() * 1.0E7);
        Long l4 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l3);
        hashMap2.put("long", l4);
        hashMap2.put("time", l2);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zztP) != 0) {
            hashMap.put("acolor", zzgu.zzI(searchAdRequestParcel.zztP));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzgu.zzI(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zztQ) != 0 && Color.alpha((int)searchAdRequestParcel.zztR) != 0) {
            hashMap.put("gradientto", zzgu.zzI(searchAdRequestParcel.zztQ));
            hashMap.put("gradientfrom", zzgu.zzI(searchAdRequestParcel.zztR));
        }
        if (Color.alpha((int)searchAdRequestParcel.zztS) != 0) {
            hashMap.put("bcolor", zzgu.zzI(searchAdRequestParcel.zztS));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zztT));
        switch (searchAdRequestParcel.zztU) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zztV) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zztW != null) {
            hashMap.put("channel", searchAdRequestParcel.zztW);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztX) != 0) {
            hashMap.put("dcolor", zzgu.zzI(searchAdRequestParcel.zztX));
        }
        if (searchAdRequestParcel.zztY != null) {
            hashMap.put("font", searchAdRequestParcel.zztY);
        }
        if (Color.alpha((int)searchAdRequestParcel.zztZ) != 0) {
            hashMap.put("hcolor", zzgu.zzI(searchAdRequestParcel.zztZ));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzua));
        if (searchAdRequestParcel.zzub != null) {
            hashMap.put("q", searchAdRequestParcel.zzub);
        }
    }

    private static Integer zzx(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzI(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzwS : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzEt != 0;
            String string6 = bl ? jSONObject.optString("ad_json", null) : jSONObject.optString("ad_html", null);
            long l2 = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l3 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzp.zzbx().zzgH();
            } else if ("landscape".equals(string8)) {
                n = zzp.zzbx().zzgG();
            }
            AdResponseParcel adResponseParcel = null;
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    zzb.zzaH("Could not parse the mediation config: Missing required ad_base_url field");
                    return new AdResponseParcel(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzgt.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzqj.zzJu, string4, null, null, null, null, null);
                string3 = adResponseParcel.zzBF;
                string6 = adResponseParcel.body;
                l2 = adResponseParcel.zzEO;
            } else {
                zzb.zzaH("Could not parse the mediation config: Missing required " + (bl ? "ad_json" : "ad_html") + " or " + "ad_url" + " field.");
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzyY;
            if (jSONArray != null) {
                if (list3 == null) {
                    list3 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray.length(); ++i) {
                    list3.add(jSONArray.getString(i));
                }
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzyZ;
            if (jSONArray2 != null) {
                if (list2 == null) {
                    list2 = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray2.length(); ++i) {
                    list2.add(jSONArray2.getString(i));
                }
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzEM;
            if (jSONArray3 != null) {
                if (list == null) {
                    list = new LinkedList<String>();
                }
                for (int i = 0; i < jSONArray3.length(); ++i) {
                    list.add(jSONArray3.getString(i));
                }
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzEJ > 0L) {
                    l3 = adResponseParcel.zzEJ;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l4 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l5 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string11 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l3, bl3, l5, list, l4, n, string5, l2, string7, bl2, string10, string9, bl4, bl, adRequestInfoParcel.zzEv, bl5, bl6, n2, string11, bl7);
        }
        catch (JSONException jSONException) {
            zzb.zzaH("Could not parse the mediation config: " + jSONException.getMessage());
            return new AdResponseParcel(0);
        }
    }
}

