/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zziz;

@zzgr
public class zzjf
extends WebChromeClient {
    private final zziz zzoM;

    protected boolean zza(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)string2);
            if (bl) {
                zzjf.zza(context, builder, string3, string4, jsPromptResult);
            } else {
                zzjf.zza(builder, string3, jsResult);
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzb.zzd("Fail to display Dialog.", badTokenException);
        }
        return true;
    }

    private static void zza(AlertDialog.Builder builder, String string2, final JsResult jsResult) {
        builder.setMessage((CharSequence)string2).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.confirm();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsResult.cancel();
            }
        }).create().show();
    }

    private static void zza(Context context, AlertDialog.Builder builder, String string2, String string3, final JsPromptResult jsPromptResult) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText((CharSequence)string2);
        final EditText editText = new EditText(context);
        editText.setText((CharSequence)string3);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        builder.setView((View)linearLayout).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.confirm(editText.getText().toString());
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                jsPromptResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                jsPromptResult.cancel();
            }
        }).create().show();
    }

    public zzjf(zziz zziz2) {
        this.zzoM = zziz2;
    }

    public final boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)resultMsg.obj;
        WebView webView = new WebView(view.getContext());
        webView.setWebViewClient((WebViewClient)this.zzoM.zzhe());
        webViewTransport.setWebView(webView);
        resultMsg.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zziz)) {
            zzb.zzaH("Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzd zzd2 = ((zziz)webView).zzhc();
        if (zzd2 == null) {
            zzb.zzaH("Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzd2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = "JS: " + consoleMessage.message() + " (" + consoleMessage.sourceId() + ":" + consoleMessage.lineNumber() + ")";
        if (string2.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzb.e(string2);
                break;
            }
            case WARNING: {
                zzb.zzaH(string2);
                break;
            }
            case LOG: 
            case TIP: {
                zzb.zzaG(string2);
                break;
            }
            case DEBUG: {
                zzb.zzaF(string2);
                break;
            }
            default: {
                zzb.zzaG(string2);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l2;
        long l3 = 0x500000L - totalUsedQuota;
        if (l3 <= 0L) {
            quotaUpdater.updateQuota(currentQuota);
            return;
        }
        if (currentQuota == 0L) {
            l2 = estimatedSize <= l3 && estimatedSize <= 0x100000L ? estimatedSize : 0L;
        } else if (estimatedSize == 0L) {
            long l4 = Math.min(131072L, l3);
            l2 = Math.min(currentQuota + l4, 0x100000L);
        } else {
            long l5 = Math.min(0x100000L - currentQuota, l3);
            l2 = estimatedSize <= l5 ? currentQuota + estimatedSize : currentQuota;
        }
        quotaUpdater.updateQuota(l2);
    }

    public final void onHideCustomView() {
        zzd zzd2 = this.zzoM.zzhc();
        if (zzd2 == null) {
            zzb.zzaH("Could not get ad overlay when hiding custom view.");
            return;
        }
        zzd2.zzeD();
    }

    private final Context zzc(WebView webView) {
        if (!(webView instanceof zziz)) {
            return webView.getContext();
        }
        zziz zziz2 = (zziz)webView;
        Activity activity = zziz2.zzgZ();
        return activity != null ? activity : zziz2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String url, String message, JsResult result) {
        return this.zza(this.zzc(webView), url, message, null, result, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String url, String message, String defaultValue, JsPromptResult result) {
        return this.zza(this.zzc(webView), url, message, defaultValue, null, result, true);
    }

    public final void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long l2 = 0x500000L - totalUsedQuota;
        long l3 = spaceNeeded + 131072L;
        if (l2 < l3) {
            quotaUpdater.updateQuota(0L);
        } else {
            quotaUpdater.updateQuota(l3);
        }
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zza(view, -1, customViewCallback);
    }

    public final void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            callback.invoke(origin, this.zzhE(), true);
        }
    }

    private final boolean zzhE() {
        return zzp.zzbv().zza(this.zzoM.getContext().getPackageManager(), this.zzoM.getContext().getPackageName(), "android.permission.ACCESS_FINE_LOCATION") || zzp.zzbv().zza(this.zzoM.getContext().getPackageManager(), this.zzoM.getContext().getPackageName(), "android.permission.ACCESS_COARSE_LOCATION");
    }

    protected final void zza(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzd zzd2 = this.zzoM.zzhc();
        if (zzd2 == null) {
            zzb.zzaH("Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzd2.zza(view, customViewCallback);
        zzd2.setRequestedOrientation(n);
    }
}

