/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.android.gms.internal.zzb;
import com.google.android.gms.internal.zzd;
import com.google.android.gms.internal.zzi;
import com.google.android.gms.internal.zzl;
import com.google.android.gms.internal.zzm;
import com.google.android.gms.internal.zzo;
import com.google.android.gms.internal.zzr;
import com.google.android.gms.internal.zzs;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class zzk<T>
implements Comparable<zzk<T>> {
    private final zzs.zza zzD = zzs.zza.zzak ? new zzs.zza() : null;
    private final int zzE;
    private final String zzF;
    private final int zzG;
    private final zzm.zza zzH;
    private Integer zzI;
    private zzl zzJ;
    private boolean zzK = true;
    private boolean zzL = false;
    private boolean zzM = false;
    private long zzN = 0L;
    private zzo zzO;
    private zzb.zza zzP = null;

    public zzk(int n, String string2, zzm.zza zza2) {
        this.zzE = n;
        this.zzF = string2;
        this.zzH = zza2;
        this.zza(new zzd());
        this.zzG = zzk.zzb(string2);
    }

    public int getMethod() {
        return this.zzE;
    }

    public int zzg() {
        return this.zzG;
    }

    private static int zzb(String string2) {
        String string3;
        Uri uri;
        if (!TextUtils.isEmpty((CharSequence)string2) && (uri = Uri.parse((String)string2)) != null && (string3 = uri.getHost()) != null) {
            return string3.hashCode();
        }
        return 0;
    }

    public zzk<?> zza(zzo zzo2) {
        this.zzO = zzo2;
        return this;
    }

    public void zzc(String string2) {
        if (zzs.zza.zzak) {
            this.zzD.zza(string2, Thread.currentThread().getId());
        } else if (this.zzN == 0L) {
            this.zzN = SystemClock.elapsedRealtime();
        }
    }

    void zzd(final String string2) {
        if (this.zzJ != null) {
            this.zzJ.zzf(this);
        }
        if (zzs.zza.zzak) {
            final long l2 = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        zzk.this.zzD.zza(string2, l2);
                        zzk.this.zzD.zzd(this.toString());
                    }
                });
                return;
            }
            this.zzD.zza(string2, l2);
            this.zzD.zzd(this.toString());
        } else {
            long l3 = SystemClock.elapsedRealtime() - this.zzN;
            if (l3 >= 3000L) {
                zzs.zzb("%d ms: %s", l3, this.toString());
            }
        }
    }

    public zzk<?> zza(zzl zzl2) {
        this.zzJ = zzl2;
        return this;
    }

    public final zzk<?> zza(int n) {
        this.zzI = n;
        return this;
    }

    public String getUrl() {
        return this.zzF;
    }

    public String zzh() {
        return this.getUrl();
    }

    public zzk<?> zza(zzb.zza zza2) {
        this.zzP = zza2;
        return this;
    }

    public zzb.zza zzi() {
        return this.zzP;
    }

    public boolean isCanceled() {
        return this.zzL;
    }

    public Map<String, String> getHeaders() throws com.google.android.gms.internal.zza {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, String> zzj() throws com.google.android.gms.internal.zza {
        return this.zzn();
    }

    @Deprecated
    protected String zzk() {
        return this.zzo();
    }

    @Deprecated
    public String zzl() {
        return this.zzp();
    }

    @Deprecated
    public byte[] zzm() throws com.google.android.gms.internal.zza {
        Map<String, String> map = this.zzj();
        if (map != null && map.size() > 0) {
            return this.zza(map, this.zzk());
        }
        return null;
    }

    protected Map<String, String> zzn() throws com.google.android.gms.internal.zza {
        return null;
    }

    protected String zzo() {
        return "UTF-8";
    }

    public String zzp() {
        return "application/x-www-form-urlencoded; charset=" + this.zzo();
    }

    public byte[] zzq() throws com.google.android.gms.internal.zza {
        Map<String, String> map = this.zzn();
        if (map != null && map.size() > 0) {
            return this.zza(map, this.zzo());
        }
        return null;
    }

    private byte[] zza(Map<String, String> map, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(URLEncoder.encode(entry.getKey(), string2));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode(entry.getValue(), string2));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Encoding not supported: " + string2, unsupportedEncodingException);
        }
    }

    public final boolean zzr() {
        return this.zzK;
    }

    public zza zzs() {
        return zza.zzU;
    }

    public final int zzt() {
        return this.zzO.zzd();
    }

    public zzo zzu() {
        return this.zzO;
    }

    public void zzv() {
        this.zzM = true;
    }

    public boolean zzw() {
        return this.zzM;
    }

    protected abstract zzm<T> zza(zzi var1);

    protected zzr zzb(zzr zzr2) {
        return zzr2;
    }

    protected abstract void zza(T var1);

    public void zzc(zzr zzr2) {
        if (this.zzH != null) {
            this.zzH.zze(zzr2);
        }
    }

    public int zzc(zzk<T> zzk2) {
        zza zza2;
        zza zza3 = this.zzs();
        return zza3 == (zza2 = zzk2.zzs()) ? this.zzI - zzk2.zzI : zza2.ordinal() - zza3.ordinal();
    }

    public String toString() {
        String string2 = "0x" + Integer.toHexString(this.zzg());
        return (this.zzL ? "[X] " : "[ ] ") + this.getUrl() + " " + string2 + " " + (Object)((Object)this.zzs()) + " " + this.zzI;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.zzc((zzk)x0);
    }

    public static enum zza {
        zzT,
        zzU,
        zzV,
        zzW;

    }
}

