/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.games.GameManagerClient;
import com.google.android.gms.cast.games.GameManagerState;
import com.google.android.gms.cast.games.PlayerInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.cast.internal.zzo;
import com.google.android.gms.cast.internal.zzp;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class zzko
extends com.google.android.gms.cast.internal.zzc {
    static final String NAMESPACE = zzf.zzbN("com.google.cast.games");
    private static final zzl zzVo = new zzl("GameManagerChannel");
    private final Map<String, String> zzXH = new ConcurrentHashMap<String, String>();
    private final List<zzp> zzXI;
    private final SharedPreferences zzuj;
    private final String zzXJ;
    private final Cast.CastApi zzXK;
    private final GoogleApiClient zzXL;
    private zzkp zzXM;
    private boolean zzXN = false;
    private GameManagerState zzXO;
    private GameManagerState zzXP;
    private String zzXQ;
    private JSONObject zzXR;
    private long zzXS = 0L;
    private GameManagerClient.Listener zzXT;
    private String zzXU;

    public zzko(GoogleApiClient googleApiClient, String string2, Cast.CastApi castApi) throws IllegalArgumentException, IllegalStateException {
        super(NAMESPACE, "CastGameManagerChannel", null);
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("castSessionId cannot be null.");
        }
        if (googleApiClient == null || !googleApiClient.isConnected() || !googleApiClient.hasConnectedApi(Cast.API)) {
            throw new IllegalArgumentException("googleApiClient needs to be connected and contain the Cast.API API.");
        }
        this.zzXI = new ArrayList<zzp>();
        this.zzXJ = string2;
        this.zzXK = castApi;
        this.zzXL = googleApiClient;
        Context context = googleApiClient.getContext().getApplicationContext();
        String string3 = String.format(Locale.ROOT, "%s.%s", context.getPackageName(), "game_manager_channel_data");
        this.zzuj = context.getApplicationContext().getSharedPreferences(string3, 0);
        this.zzXP = null;
        this.zzXO = new zzks(0, 0, "", null, new ArrayList<PlayerInfo>(), "", -1);
    }

    public synchronized PendingResult<GameManagerClient.GameManagerInstanceResult> zza(GameManagerClient gameManagerClient) throws IllegalArgumentException {
        if (gameManagerClient == null) {
            throw new IllegalArgumentException("gameManagerClient can't be null.");
        }
        return this.zzXL.zzb(new zzc(gameManagerClient){

            @Override
            public void execute() {
                try {
                    zzko.this.zzXK.setMessageReceivedCallbacks(zzko.this.zzXL, zzko.this.getNamespace(), new Cast.MessageReceivedCallback(){

                        @Override
                        public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
                            zzko.this.zzbK(message);
                        }
                    });
                }
                catch (IOException | IllegalStateException exception) {
                    this.zzmG().zza(-1L, 8, null);
                    return;
                }
                zzko.this.zzmE();
                zzko.this.zzmD();
                zzko.this.zza(null, 1100, null, this.zzmG());
            }
        });
    }

    public synchronized void dispose() throws IllegalStateException {
        if (this.zzXN) {
            return;
        }
        this.zzXO = null;
        this.zzXP = null;
        this.zzXQ = null;
        this.zzXR = null;
        this.zzXN = true;
        try {
            this.zzXK.removeMessageReceivedCallbacks(this.zzXL, this.getNamespace());
        }
        catch (IOException iOException) {
            zzVo.zzf("Exception while detaching game manager channel.", iOException);
        }
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> zza(final String string2, final int n, final JSONObject jSONObject) throws IllegalStateException {
        this.zzmB();
        return this.zzXL.zzb(new zza(){

            @Override
            public void execute() {
                int n2 = zzkr.zzaY(n);
                if (n2 == 0) {
                    this.zzmG().zza(-1L, 2001, null);
                    zzVo.zzf("sendPlayerRequest for unsupported playerState: %d", n);
                    return;
                }
                zzko.this.zza(string2, n2, jSONObject, this.zzmG());
            }
        });
    }

    public synchronized void sendGameMessage(String playerId, JSONObject extraMessageData) throws IllegalStateException {
        this.zzmB();
        long l2 = ++this.zzXS;
        JSONObject jSONObject = this.zza(l2, playerId, 7, extraMessageData);
        if (jSONObject == null) {
            return;
        }
        this.zzXK.sendMessage(this.zzXL, this.getNamespace(), jSONObject.toString());
    }

    public synchronized PendingResult<GameManagerClient.GameManagerResult> sendGameRequest(final String playerId, final JSONObject extraMessageData) throws IllegalStateException {
        this.zzmB();
        return this.zzXL.zzb(new zza(){

            @Override
            public void execute() {
                zzko.this.zza(playerId, 6, extraMessageData, this.zzmG());
            }
        });
    }

    public synchronized GameManagerState getCurrentState() throws IllegalStateException {
        this.zzmB();
        return this.zzXO;
    }

    public synchronized String getLastUsedPlayerId() throws IllegalStateException {
        this.zzmB();
        return this.zzXU;
    }

    public synchronized String zzbJ(String string2) throws IllegalStateException {
        return string2 == null ? null : this.zzXH.get(string2);
    }

    public synchronized void setListener(GameManagerClient.Listener listener) {
        this.zzXT = listener;
    }

    @Override
    public final void zzbK(String string2) {
        boolean bl;
        zzkq zzkq2;
        zzVo.zzb("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            zzkq2 = zzkq.zzh(jSONObject);
        }
        catch (JSONException jSONException) {
            zzVo.zzf("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
            return;
        }
        if (zzkq2 == null) {
            zzVo.zzf("Could not parse game manager message from string: %s", string2);
            return;
        }
        if (!this.isInitialized() && zzkq2.zzmN() == null || this.isDisposed()) {
            return;
        }
        boolean bl2 = bl = zzkq2.zzmI() == 1;
        if (bl && !TextUtils.isEmpty((CharSequence)zzkq2.zzmM())) {
            this.zzXH.put(zzkq2.getPlayerId(), zzkq2.zzmM());
            this.zzmD();
        }
        if (zzkq2.getStatusCode() == 0) {
            this.zza(zzkq2);
        } else {
            zzVo.zzf("Not updating from game message because the message contains error code: %d", zzkq2.getStatusCode());
        }
        int n = this.zzaX(zzkq2.getStatusCode());
        if (bl) {
            this.zzb(zzkq2.getRequestId(), n, zzkq2);
        }
        if (this.isInitialized() && n == 0) {
            this.zzmC();
        }
    }

    public synchronized boolean isDisposed() {
        return this.zzXN;
    }

    public synchronized boolean isInitialized() {
        return this.zzXM != null;
    }

    @Override
    public void zzb(long l2, int n) {
        this.zzb(l2, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean zzz(long l2) {
        Iterator<zzp> iterator = this.zzXI.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzd(l2, 15)) continue;
            iterator.remove();
        }
        boolean bl = false;
        Object object = zzp.zzZJ;
        synchronized (object) {
            for (zzp zzp3 : this.zzXI) {
                if (!zzp3.zznk()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private int zzaX(int n) {
        switch (n) {
            case 4: {
                return 2151;
            }
            case 3: {
                return 2150;
            }
            case 2: {
                return 2003;
            }
            case 1: {
                return 2001;
            }
            case 0: {
                return 0;
            }
        }
        zzVo.zzf("Unknown GameManager protocol status code: " + n, new Object[0]);
        return 13;
    }

    private synchronized void zzmB() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel before it is initialized.");
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Attempted to perform an operation on the GameManagerChannel after it has been disposed.");
        }
    }

    private void zza(String string2, int n, JSONObject jSONObject, zzo zzo2) {
        long l2;
        JSONObject jSONObject2;
        if ((jSONObject2 = this.zza(l2 = ++this.zzXS, string2, n, jSONObject)) == null) {
            zzo2.zza(-1L, 2001, null);
            zzVo.zzf("Not sending request because it was invalid.", new Object[0]);
            return;
        }
        zzp zzp2 = new zzp(30000L);
        zzp2.zza(l2, zzo2);
        this.zzXI.add(zzp2);
        this.zzV(true);
        this.zzXK.sendMessage(this.zzXL, this.getNamespace(), jSONObject2.toString()).setResultCallback(new ResultCallback<Status>(){

            public void zzo(Status status) {
                if (!status.isSuccess()) {
                    zzko.this.zzb(l2, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzo((Status)x0);
            }
        });
    }

    private JSONObject zza(long l2, String string2, int n, JSONObject jSONObject) {
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", n);
            jSONObject2.put("extraMessageData", (Object)jSONObject);
            jSONObject2.put("playerId", (Object)string2);
            jSONObject2.put("playerToken", (Object)this.zzbJ(string2));
        }
        catch (JSONException jSONException) {
            zzVo.zzf("JSONException when trying to create a message: %s", jSONException.getMessage());
            jSONObject2 = null;
        }
        return jSONObject2;
    }

    private synchronized void zza(zzkq zzkq2) {
        boolean bl = zzkq2.zzmI() == 1;
        this.zzXP = this.zzXO;
        if (bl && zzkq2.zzmN() != null) {
            this.zzXM = zzkq2.zzmN();
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<PlayerInfo> arrayList = new ArrayList<PlayerInfo>();
        for (zzku zzku2 : zzkq2.zzmK()) {
            String string2 = zzku2.getPlayerId();
            zzkt zzkt2 = new zzkt(string2, zzku2.getPlayerState(), zzku2.getPlayerData(), this.zzXH.containsKey(string2));
            arrayList.add(zzkt2);
        }
        this.zzXO = new zzks(zzkq2.getLobbyState(), zzkq2.getGameplayState(), zzkq2.zzmL(), zzkq2.getGameData(), arrayList, this.zzXM.zzmH(), this.zzXM.getMaxPlayers());
        PlayerInfo playerInfo = this.zzXO.getPlayer(zzkq2.getPlayerId());
        if (playerInfo != null && playerInfo.isControllable() && zzkq2.zzmI() == 2) {
            this.zzXQ = zzkq2.getPlayerId();
            this.zzXR = zzkq2.getExtraMessageData();
        }
    }

    private void zzmC() {
        if (this.zzXT != null) {
            if (this.zzXP != null && !this.zzXO.equals(this.zzXP)) {
                this.zzXT.onStateChanged(this.zzXO, this.zzXP);
            }
            if (this.zzXR != null && this.zzXQ != null) {
                this.zzXT.onGameMessageReceived(this.zzXQ, this.zzXR);
            }
        }
        this.zzXP = null;
        this.zzXQ = null;
        this.zzXR = null;
    }

    private void zzb(long l2, int n, Object object) {
        Iterator<zzp> iterator = this.zzXI.iterator();
        while (iterator.hasNext()) {
            zzp zzp2 = iterator.next();
            if (!zzp2.zzc(l2, n, object)) continue;
            iterator.remove();
        }
    }

    private synchronized void zzmD() {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("castSessionId", (Object)this.zzXJ);
            jSONObject.put("playerTokenMap", (Object)new JSONObject(this.zzXH));
            this.zzuj.edit().putString("save_data", jSONObject.toString()).commit();
        }
        catch (JSONException jSONException) {
            zzVo.zzf("Error while saving data: %s", jSONException.getMessage());
        }
    }

    private synchronized void zzmE() {
        String string2 = this.zzuj.getString("save_data", null);
        if (string2 == null) {
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("castSessionId");
            if (this.zzXJ.equals(string3)) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("playerTokenMap");
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    this.zzXH.put(string4, jSONObject2.getString(string4));
                }
                this.zzXS = 0L;
            }
        }
        catch (JSONException jSONException) {
            zzVo.zzf("Error while loading data: %s", jSONException.getMessage());
        }
    }

    public abstract class zza
    extends zzb<GameManagerClient.GameManagerResult> {
        public zza() {
            this.zzXu = new zzo(){

                @Override
                public void zzy(long l2) {
                    zza.this.zzb(zza.this.zzq(new Status(2103)));
                }

                @Override
                public void zza(long l2, int n, Object object) {
                    try {
                        if (object == null) {
                            zza.this.zzb(new zze(new Status(n, null, null), null, l2, null));
                            return;
                        }
                        zzkq zzkq2 = (zzkq)object;
                        String string2 = zzkq2.getPlayerId();
                        if (n == 0 && string2 != null) {
                            zzko.this.zzXU = string2;
                        }
                        zza.this.zzb(new zze(new Status(n, zzkq2.zzmJ(), null), string2, zzkq2.getRequestId(), zzkq2.getExtraMessageData()));
                    }
                    catch (ClassCastException classCastException) {
                        zza.this.zzb(zza.this.zzq(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerResult zzq(Status status) {
            return new zze(status, null, -1L, null);
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzq(status);
        }
    }

    public abstract class zzc
    extends zzb<GameManagerClient.GameManagerInstanceResult> {
        private GameManagerClient zzYd;

        public zzc(GameManagerClient gameManagerClient) {
            this.zzYd = gameManagerClient;
            this.zzXu = new zzo(){

                @Override
                public void zzy(long l2) {
                    zzc.this.zzb(zzc.this.zzr(new Status(2103)));
                }

                @Override
                public void zza(long l2, int n, Object object) {
                    try {
                        if (object == null) {
                            zzc.this.zzb(new zzd(new Status(n, null, null), zzc.this.zzYd));
                            return;
                        }
                        zzkq zzkq2 = (zzkq)object;
                        zzkp zzkp2 = zzkq2.zzmN();
                        if (zzkp2 != null && !zzf.zza("1.0.0", zzkp2.getVersion())) {
                            zzc.this.zzb(zzc.this.zzr(new Status(2150, String.format(Locale.ROOT, "Incorrect Game Manager SDK version. Receiver: %s Sender: %s", zzkp2.getVersion(), "1.0.0"))));
                            zzko.this.zzXM = null;
                            return;
                        }
                        zzc.this.zzb(new zzd(new Status(n, zzkq2.zzmJ(), null), zzc.this.zzYd));
                    }
                    catch (ClassCastException classCastException) {
                        zzc.this.zzb(zzc.this.zzr(new Status(13)));
                    }
                }
            };
        }

        public GameManagerClient.GameManagerInstanceResult zzr(Status status) {
            return new zzd(status, null);
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzr(status);
        }
    }

    public abstract class zzb<R extends Result>
    extends com.google.android.gms.cast.internal.zzb<R> {
        protected zzo zzXu;

        public zzb() {
            super(zzko.this.zzXL);
        }

        @Override
        protected void zza(com.google.android.gms.cast.internal.zze zze2) {
            this.execute();
        }

        public zzo zzmG() {
            return this.zzXu;
        }

        public abstract void execute();
    }

    private static final class zze
    implements GameManagerClient.GameManagerResult {
        private final Status zzSC;
        private final String zzYf;
        private final long zzYg;
        private final JSONObject zzYh;

        zze(Status status, String string2, long l2, JSONObject jSONObject) {
            this.zzSC = status;
            this.zzYf = string2;
            this.zzYg = l2;
            this.zzYh = jSONObject;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public String getPlayerId() {
            return this.zzYf;
        }

        @Override
        public long getRequestId() {
            return this.zzYg;
        }

        @Override
        public JSONObject getExtraMessageData() {
            return this.zzYh;
        }
    }

    private static final class zzd
    implements GameManagerClient.GameManagerInstanceResult {
        private final Status zzSC;
        private final GameManagerClient zzYd;

        zzd(Status status, GameManagerClient gameManagerClient) {
            this.zzSC = status;
            this.zzYd = gameManagerClient;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public GameManagerClient getGameManagerClient() {
            return this.zzYd;
        }
    }
}

