/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.os.RemoteException;
import android.view.Display;
import android.view.Surface;
import com.google.android.gms.cast.CastRemoteDisplay;
import com.google.android.gms.cast.CastRemoteDisplayApi;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;

public class zzkw
implements CastRemoteDisplayApi {
    private static final zzl zzVo = new zzl("CastRemoteDisplayApiImpl");
    private Api.zzc<zzkx> zzZM;
    private VirtualDisplay zzZN;
    private final zzla zzZO = new zzla.zza(){

        @Override
        public void zzbg(int n) {
            zzVo.zzb("onRemoteDisplayEnded", new Object[0]);
            zzkw.this.zznl();
        }
    };

    public zzkw(Api.zzc<zzkx> zzc2) {
        this.zzZM = zzc2;
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> startRemoteDisplay(GoogleApiClient apiClient, final String appId) {
        zzVo.zzb("startRemoteDisplay", new Object[0]);
        return apiClient.zzb(new zzb(apiClient){

            @Override
            protected void zza(zzkx zzkx2) throws RemoteException {
                zzkx2.zza(new zzb.zza(zzkx2), zzkw.this.zzZO, appId);
            }
        });
    }

    @Override
    public PendingResult<CastRemoteDisplay.CastRemoteDisplaySessionResult> stopRemoteDisplay(GoogleApiClient apiClient) {
        zzVo.zzb("stopRemoteDisplay", new Object[0]);
        return apiClient.zzb(new zzb(apiClient){

            @Override
            protected void zza(zzkx zzkx2) throws RemoteException {
                zzkx2.zza(new zzb.zzb());
            }
        });
    }

    private void zznl() {
        if (this.zzZN != null) {
            Display display = this.zzZN.getDisplay();
            if (display != null) {
                zzVo.zzb("releasing virtual display: " + this.zzZN.getDisplay().getDisplayId(), new Object[0]);
            }
            this.zzZN.release();
            this.zzZN = null;
        }
    }

    private abstract class com.google.android.gms.internal.zzkw$zzb
    extends zzlb.zza<CastRemoteDisplay.CastRemoteDisplaySessionResult, zzkx> {
        public com.google.android.gms.internal.zzkw$zzb(GoogleApiClient googleApiClient) {
            super(zzkw.this.zzZM, googleApiClient);
        }

        protected CastRemoteDisplay.CastRemoteDisplaySessionResult zzs(Status status) {
            return new zzc(status);
        }

        @Override
        protected /* synthetic */ Result zzb(Status status) {
            return this.zzs(status);
        }

        protected final class zzb
        extends com.google.android.gms.internal.zzkw$zza {
            protected zzb() {
            }

            @Override
            public void onDisconnected() throws RemoteException {
                zzVo.zzb("onDisconnected", new Object[0]);
                zzkw.this.zznl();
                zzb.this.zzb(new zzc(Status.zzabb));
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzVo.zzb("onError: %d", statusCode);
                zzkw.this.zznl();
                zzb.this.zzb(new zzc(Status.zzabd));
            }
        }

        protected final class zza
        extends com.google.android.gms.internal.zzkw$zza {
            private final zzkx zzZR;

            public zza(zzkx zzkx2) {
                this.zzZR = zzkx2;
            }

            private int zzi(int n, int n2) {
                return (n < n2 ? n : n2) * 320 / 1080;
            }

            @Override
            public void zza(int n, int n2, Surface surface) {
                zzVo.zzb("onConnected", new Object[0]);
                DisplayManager displayManager = (DisplayManager)this.zzZR.getContext().getSystemService("display");
                if (displayManager == null) {
                    zzVo.zzc("Unable to get the display manager", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzabd));
                    return;
                }
                zzkw.this.zznl();
                int n3 = this.zzi(n, n2);
                zzkw.this.zzZN = displayManager.createVirtualDisplay("private_display", n, n2, n3, surface, 2);
                if (zzkw.this.zzZN == null) {
                    zzVo.zzc("Unable to create virtual display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzabd));
                    return;
                }
                Display display = zzkw.this.zzZN.getDisplay();
                if (display == null) {
                    zzVo.zzc("Virtual display does not have a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzabd));
                    return;
                }
                try {
                    this.zzZR.zza(this, zzkw.this.zzZN.getDisplay().getDisplayId());
                }
                catch (RemoteException | IllegalStateException throwable) {
                    zzVo.zzc("Unable to provision the route's new virtual Display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzabd));
                }
            }

            @Override
            public void zznn() {
                zzVo.zzb("onConnectedWithDisplay", new Object[0]);
                Display display = zzkw.this.zzZN.getDisplay();
                if (display != null) {
                    zzb.this.zzb(new zzc(display));
                } else {
                    zzVo.zzc("Virtual display no longer has a display", new Object[0]);
                    zzb.this.zzb(new zzc(Status.zzabd));
                }
            }

            @Override
            public void onError(int statusCode) throws RemoteException {
                zzVo.zzb("onError: %d", statusCode);
                zzkw.this.zznl();
                zzb.this.zzb(new zzc(Status.zzabd));
            }
        }
    }

    private abstract class zza
    extends zzky.zza {
        private zza() {
        }

        @Override
        public void zza(int n, int n2, Surface surface) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onError(int statusCode) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onDisconnected() throws RemoteException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void zznn() throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private static final class zzc
    implements CastRemoteDisplay.CastRemoteDisplaySessionResult {
        private final Status zzSC;
        private final Display zzVA;

        public zzc(Display display) {
            this.zzSC = Status.zzabb;
            this.zzVA = display;
        }

        public zzc(Status status) {
            this.zzSC = status;
            this.zzVA = null;
        }

        @Override
        public Status getStatus() {
            return this.zzSC;
        }

        @Override
        public Display getPresentationDisplay() {
            return this.zzVA;
        }
    }
}

