/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlq;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzlc<R extends Result>
extends PendingResult<R> {
    private final Object zzabh = new Object();
    protected final zza<R> zzabi;
    private final CountDownLatch zzoS = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzabj = new ArrayList();
    private ResultCallback<? super R> zzabk;
    private volatile R zzaaX;
    private volatile boolean zzabl;
    private boolean zzL;
    private boolean zzabm;
    private zzq zzabn;
    private Integer zzabo;
    private volatile zzlq<R> zzabp;

    protected zzlc(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzabi = new zza(looper);
    }

    @Deprecated
    protected zzlc(Looper looper) {
        this.zzabi = new zza(looper);
    }

    public final boolean isReady() {
        return this.zzoS.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        zzx.zza(!this.zzabl, (Object)"Result has already been consumed");
        zzx.zza(this.zzabp == null, (Object)"Cannot await if then() has been called.");
        try {
            this.zzoS.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzabc);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        zzx.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzx.zza(!this.zzabl, (Object)"Result has already been consumed.");
        zzx.zza(this.zzabp == null, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzoS.await(time, units);
            if (!bl) {
                this.zzw(Status.zzabe);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzw(Status.zzabc);
        }
        zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback) {
        zzx.zza(!this.zzabl, (Object)"Result has already been consumed.");
        Object object = this.zzabh;
        synchronized (object) {
            zzx.zza(this.zzabp == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzabi.zza(callback, (R)this.get());
            } else {
                this.zzabk = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback, long time, TimeUnit units) {
        zzx.zza(!this.zzabl, (Object)"Result has already been consumed.");
        Object object = this.zzabh;
        synchronized (object) {
            zzx.zza(this.zzabp == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzabi.zza(callback, (R)this.get());
            } else {
                this.zzabk = callback;
                this.zzabi.zza(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzx.zza(!this.zzabl, (Object)"Result has already been consumed.");
        zzx.zzb(zza2 != null, (Object)"Callback cannot be null.");
        Object object = this.zzabh;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzt(this.zzaaX.getStatus());
            } else {
                this.zzabj.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzabh;
        synchronized (object) {
            if (this.zzL || this.zzabl) {
                return;
            }
            if (this.zzabn != null) {
                try {
                    this.zzabn.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzlc.zzd(this.zzaaX);
            this.zzabk = null;
            this.zzL = true;
            this.zzc(this.zzb(Status.zzabf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzabh;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(R r) {
        Object object = this.zzabh;
        synchronized (object) {
            if (this.zzabm || this.zzL) {
                zzlc.zzd(r);
                return;
            }
            zzx.zza(!this.isReady(), (Object)"Results have already been set");
            zzx.zza(!this.zzabl, (Object)"Result has already been consumed");
            this.zzc(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzw(Status status) {
        Object object = this.zzabh;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzb(this.zzb(status));
                this.zzabm = true;
            }
        }
    }

    protected abstract R zzb(Status var1);

    protected void zznL() {
    }

    @Override
    public Integer zznF() {
        return this.zzabo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzq zzq2) {
        Object object = this.zzabh;
        synchronized (object) {
            this.zzabn = zzq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzabh;
        synchronized (object) {
            zzx.zza(!this.zzabl, (Object)"Result has already been consumed.");
            zzx.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzaaX;
            this.zzaaX = null;
            this.zzabk = null;
            this.zzabl = true;
        }
        this.zznL();
        return r;
    }

    private void zzc(R r) {
        this.zzaaX = r;
        this.zzabn = null;
        this.zzoS.countDown();
        Status status = this.zzaaX.getStatus();
        if (this.zzabk != null) {
            this.zzabi.zznM();
            if (!this.zzL) {
                this.zzabi.zza(this.zzabk, (R)this.get());
            }
        }
        for (PendingResult.zza zza2 : this.zzabj) {
            zza2.zzt(status);
        }
        this.zzabj.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"BasePendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzlc<R> zzlc2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, zzlc2), l2);
        }

        public void zznM() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzlc zzlc2 = (zzlc)msg.obj;
                    zzlc2.zzw(Status.zzabe);
                    return;
                }
            }
            Log.wtf((String)"BasePendingResult", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzlc.zzd(r);
                throw runtimeException;
            }
        }
    }
}

