/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlf;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzlj;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlo;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class zzli
extends GoogleApiClient {
    private final Lock zzabt = new ReentrantLock();
    private final Condition zzabY;
    final zzk zzabZ;
    private final int zzaaM;
    private final Context mContext;
    private final Looper zzaaO;
    final Queue<zzf<?>> zzaca = new LinkedList();
    private volatile boolean zzacb;
    private long zzacc = 120000L;
    private long zzacd = 5000L;
    private final zza zzace;
    private final GoogleApiAvailability zzaaP;
    zzd zzacf;
    final Map<Api.zzc<?>, Api.zzb> zzacg = new HashMap();
    final Map<Api.zzc<?>, ConnectionResult> zzach = new HashMap();
    Set<Scope> zzaci = new HashSet<Scope>();
    final com.google.android.gms.common.internal.zzf zzabI;
    final Map<Api<?>, Integer> zzabJ;
    final Api.zza<? extends zzqw, zzqx> zzaaQ;
    private volatile zzlj zzacj;
    private ConnectionResult zzack = null;
    private final Set<zzlm<?>> zzacl = Collections.newSetFromMap(new WeakHashMap());
    final Set<zzf<?>> zzacm = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private com.google.android.gms.common.api.zza zzacn;
    private final zze zzaco = new zze(){

        @Override
        public void zzc(zzf<?> zzf2) {
            zzli.this.zzacm.remove(zzf2);
            if (zzf2.zznF() != null && zzli.this.zzacn != null) {
                zzli.this.zzacn.remove(zzf2.zznF());
            }
        }
    };
    private final GoogleApiClient.ConnectionCallbacks zzacp = new GoogleApiClient.ConnectionCallbacks(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(Bundle connectionHint) {
            zzli.this.zzabt.lock();
            try {
                zzli.this.zzacj.onConnected(connectionHint);
            }
            finally {
                zzli.this.zzabt.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionSuspended(int cause) {
            zzli.this.zzabt.lock();
            try {
                zzli.this.zzacj.onConnectionSuspended(cause);
            }
            finally {
                zzli.this.zzabt.unlock();
            }
        }
    };
    private final zzk.zza zzacq = new zzk.zza(){

        @Override
        public boolean isConnected() {
            return zzli.this.isConnected();
        }

        @Override
        public Bundle zzmS() {
            return null;
        }
    };

    private static void zza(zzf<?> zzf2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
        if (zzf2.isReady()) {
            zzc zzc2 = new zzc(zzf2, zza2, iBinder);
            zzf2.zza(zzc2);
        } else if (iBinder != null && iBinder.isBinderAlive()) {
            zzc zzc3 = new zzc(zzf2, zza2, iBinder);
            zzf2.zza(zzc3);
            try {
                iBinder.linkToDeath((IBinder.DeathRecipient)zzc3, 0);
            }
            catch (RemoteException remoteException) {
                zzf2.cancel();
                zza2.remove(zzf2.zznF());
            }
        } else {
            zzf2.zza(null);
            zzf2.cancel();
            zza2.remove(zzf2.zznF());
        }
    }

    private GoogleApiClient.OnConnectionFailedListener zza(final Api<?> api, final int n) {
        return new GoogleApiClient.OnConnectionFailedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnectionFailed(ConnectionResult result) {
                zzli.this.zzabt.lock();
                try {
                    zzli.this.zzacj.zza(result, api, n);
                }
                finally {
                    zzli.this.zzabt.unlock();
                }
            }
        };
    }

    public zzli(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzqw, zzqx> zza2, Map<Api<?>, Api.ApiOptions> map, ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList, ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList2, int n) {
        this.mContext = context;
        this.zzabZ = new zzk(looper, this.zzacq);
        this.zzaaO = looper;
        this.zzace = new zza(looper);
        this.zzaaP = googleApiAvailability;
        this.zzaaM = n;
        this.zzabJ = new HashMap();
        this.zzabY = this.zzabt.newCondition();
        this.zzacj = new zzlh(this);
        for (GoogleApiClient.ConnectionCallbacks iterator : arrayList) {
            this.zzabZ.registerConnectionCallbacks(iterator);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList2) {
            this.zzabZ.registerConnectionFailedListener(onConnectionFailedListener);
        }
        Map<Api<?>, zzf.zza> map2 = zzf2.zzoM();
        for (Api<?> api : map.keySet()) {
            Api.ApiOptions apiOptions = map.get(api);
            int n2 = 0;
            if (map2.get(api) != null) {
                n2 = ((zzf.zza)map2.get(api)).zzafk ? 1 : 2;
            }
            this.zzabJ.put(api, n2);
            zzac<Object> zzac2 = api.zzny() ? zzli.zza(api.zznw(), (Object)apiOptions, context, looper, zzf2, this.zzacp, this.zza(api, n2)) : zzli.zza(api.zznv(), (Object)apiOptions, context, looper, zzf2, this.zzacp, this.zza(api, n2));
            this.zzacg.put(api.zznx(), zzac2);
        }
        this.zzabI = zzf2;
        this.zzaaQ = zza2;
    }

    private static <C extends Api.zzb, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return zza2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
    }

    private static <C extends Api.zzd, O> zzac zza(Api.zze<C, O> zze2, Object object, Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return new zzac(context, looper, zze2.zznA(), connectionCallbacks, onConnectionFailedListener, zzf2, (Api.zzd)zze2.zzn(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlb.zza<R, A>> T zza(T t) {
        zzx.zzb(t.zznx() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        zzx.zzb(this.zzacg.containsKey(t.zznx()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzabt.lock();
        try {
            T t2 = this.zzacj.zza(t);
            return t2;
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, T extends zzlb.zza<? extends Result, A>> T zzb(T t) {
        zzx.zzb(t.zznx() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzabt.lock();
        try {
            if (this.zzoc()) {
                Object object;
                this.zzaca.add(t);
                while (!this.zzaca.isEmpty()) {
                    object = this.zzaca.remove();
                    this.zzb((zzf<A>)object);
                    object.zzv(Status.zzabd);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzacj.zzb(t);
            return t2;
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzlm<L> zzo(L l2) {
        zzx.zzb(l2, (Object)"Listener must not be null");
        this.zzabt.lock();
        try {
            zzlm<L> zzlm2 = new zzlm<L>(this.zzaaO, l2);
            this.zzacl.add(zzlm2);
            zzlm<L> zzlm3 = zzlm2;
            return zzlm3;
        }
        finally {
            this.zzabt.unlock();
        }
    }

    @Override
    public <C extends Api.zzb> C zza(Api.zzc<C> zzc2) {
        Api.zzb zzb2 = this.zzacg.get(zzc2);
        zzx.zzb(zzb2, (Object)"Appropriate Api was not requested.");
        return (C)zzb2;
    }

    @Override
    public boolean zza(Api<?> api) {
        return this.zzacg.containsKey(api.zznx());
    }

    @Override
    public boolean hasConnectedApi(Api<?> api) {
        Api.zzb zzb2 = this.zzacg.get(api.zznx());
        return zzb2 != null && zzb2.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult getConnectionResult(Api<?> api) {
        Api.zzc<?> zzc2 = api.zznx();
        this.zzabt.lock();
        try {
            if (!this.isConnected() && !this.zzoc()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzacg.containsKey(zzc2)) {
                if (this.zzacg.get(zzc2).isConnected()) {
                    ConnectionResult connectionResult = ConnectionResult.zzZY;
                    return connectionResult;
                }
                if (this.zzach.containsKey(zzc2)) {
                    ConnectionResult connectionResult = this.zzach.get(zzc2);
                    return connectionResult;
                }
                Log.i((String)"GoogleApiClientImpl", (String)this.zzog());
                Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed connections map"), (Throwable)new Exception());
                ConnectionResult connectionResult = new ConnectionResult(8, null);
                return connectionResult;
            }
        }
        finally {
            this.zzabt.unlock();
        }
        throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzabt.lock();
        try {
            this.zzacj.connect();
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzabt.lock();
        try {
            this.connect();
            while (this.isConnecting()) {
                try {
                    this.zzabY.await();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    this.zzabt.unlock();
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzZY;
                return connectionResult;
            }
            if (this.zzack != null) {
                ConnectionResult connectionResult = this.zzack;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, TimeUnit unit) {
        zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        zzx.zzb(unit, (Object)"TimeUnit must not be null");
        this.zzabt.lock();
        try {
            this.connect();
            long l2 = unit.toNanos(timeout);
            while (this.isConnecting()) {
                try {
                    l2 = this.zzabY.awaitNanos(l2);
                    if (l2 > 0L) continue;
                    ConnectionResult connectionResult = new ConnectionResult(14, null);
                    return connectionResult;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    ConnectionResult connectionResult = new ConnectionResult(15, null);
                    return connectionResult;
                }
            }
            if (this.isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.zzZY;
                return connectionResult;
            }
            if (this.zzack != null) {
                ConnectionResult connectionResult = this.zzack;
                return connectionResult;
            }
            ConnectionResult connectionResult = new ConnectionResult(13, null);
            return connectionResult;
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzabt.lock();
        try {
            this.zzof();
            this.zzacj.disconnect();
        }
        finally {
            this.zzabt.unlock();
        }
    }

    void zznY() {
        for (zzf<?> object : this.zzacm) {
            object.zza(null);
            if (object.zznF() == null) {
                object.cancel();
                continue;
            }
            object.zznJ();
            IBinder iBinder = this.zza(object.zznx()).zznz();
            zzli.zza(object, this.zzacn, iBinder);
        }
        this.zzacm.clear();
        for (zzlm zzlm2 : this.zzacl) {
            zzlm2.clear();
        }
        this.zzacl.clear();
    }

    void zznZ() {
        for (Api.zzb zzb2 : this.zzacg.values()) {
            zzb2.disconnect();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzoa() {
        this.zzabt.lock();
        try {
            this.zzacj = new zzlg(this, this.zzabI, this.zzabJ, this.zzaaP, this.zzaaQ, this.zzabt, this.mContext);
            this.zzacj.begin();
            this.zzabY.signalAll();
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzob() {
        this.zzabt.lock();
        try {
            this.zzof();
            this.zzacj = new zzlf(this);
            this.zzacj.begin();
            this.zzabY.signalAll();
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(ConnectionResult connectionResult) {
        this.zzabt.lock();
        try {
            this.zzack = connectionResult;
            this.zzacj = new zzlh(this);
            this.zzacj.begin();
            this.zzabY.signalAll();
        }
        finally {
            this.zzabt.unlock();
        }
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzx.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        final zzlo zzlo2 = new zzlo(this);
        if (this.zzacg.containsKey(zzlx.zzRk)) {
            this.zza(this, zzlo2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzli.this.zza((GoogleApiClient)atomicReference.get(), zzlo2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(ConnectionResult result) {
                    zzlo2.zzb(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzlx.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzace).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzlo2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzlo zzlo2, final boolean bl) {
        zzlx.zzagw.zzb(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzo(Status status) {
                if (status.isSuccess() && zzli.this.isConnected()) {
                    zzli.this.reconnect();
                }
                zzlo2.zzb(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.zzo((Status)x0);
            }
        });
    }

    @Override
    public void stopAutoManage(final FragmentActivity lifecycleActivity) {
        if (this.zzaaM >= 0) {
            zzlp zzlp2 = zzlp.zza(lifecycleActivity);
            if (zzlp2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (lifecycleActivity.isFinishing() || lifecycleActivity.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        zzlp.zzb(lifecycleActivity).zzbp(zzli.this.zzaaM);
                    }
                });
            } else {
                zzlp2.zzbp(this.zzaaM);
            }
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzacj instanceof zzlf;
    }

    @Override
    public boolean isConnecting() {
        return this.zzacj instanceof zzlg;
    }

    boolean zzoc() {
        return this.zzacb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzabt.lock();
        try {
            if (this.zzoc()) {
                this.connect();
            }
        }
        finally {
            this.zzabt.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzod() {
        this.zzabt.lock();
        try {
            boolean bl = this.zzof();
            if (bl) {
                this.connect();
            }
        }
        finally {
            this.zzabt.unlock();
        }
    }

    void zzoe() {
        if (this.zzoc()) {
            return;
        }
        this.zzacb = true;
        if (this.zzacf == null) {
            this.zzacf = zzll.zza(this.mContext.getApplicationContext(), new zzd(this), this.zzaaP);
        }
        this.zzace.sendMessageDelayed(this.zzace.obtainMessage(1), this.zzacc);
        this.zzace.sendMessageDelayed(this.zzace.obtainMessage(2), this.zzacd);
    }

    boolean zzof() {
        if (!this.zzoc()) {
            return false;
        }
        this.zzacb = false;
        this.zzace.removeMessages(2);
        this.zzace.removeMessages(1);
        if (this.zzacf != null) {
            this.zzacf.unregister();
            this.zzacf = null;
        }
        return true;
    }

    void zza(zzb zzb2) {
        Message message = this.zzace.obtainMessage(3, zzb2);
        this.zzace.sendMessage(message);
    }

    void zza(RuntimeException runtimeException) {
        Message message = this.zzace.obtainMessage(4, runtimeException);
        this.zzace.sendMessage(message);
    }

    <A extends Api.zzb> void zzb(zzf<A> zzf2) {
        this.zzacm.add(zzf2);
        zzf2.zza(this.zzaco);
    }

    @Override
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzabZ.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzabZ.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.zzabZ.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzabZ.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzabZ.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzabZ.unregisterConnectionFailedListener(listener);
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzaaO;
    }

    String zzog() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("mState=").append(this.zzacj.getName());
        writer.append(" mResuming=").print(this.zzacb);
        writer.append(" mWorkQueue.size()=").print(this.zzaca.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzacm.size());
        String string2 = prefix + "  ";
        for (Api<?> api : this.zzabJ.keySet()) {
            writer.append(prefix).append(api.getName()).println(":");
            Api.zzb zzb2 = this.zzacg.get(api.zznx());
            zzb2.dump(string2, fd, writer, args);
        }
    }

    @Override
    public int getSessionId() {
        return System.identityHashCode(this);
    }

    static abstract class zzb {
        private final zzlj zzacy;

        protected zzb(zzlj zzlj2) {
            this.zzacy = zzlj2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzg(zzli zzli2) {
            zzli2.zzabt.lock();
            try {
                if (zzli2.zzacj != this.zzacy) {
                    return;
                }
                this.zznO();
            }
            finally {
                zzli2.zzabt.unlock();
            }
        }

        protected abstract void zznO();
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzli.this.zzod();
                    break;
                }
                case 2: {
                    zzli.this.resume();
                    break;
                }
                case 3: {
                    zzb zzb2 = (zzb)msg.obj;
                    zzb2.zzg(zzli.this);
                    break;
                }
                case 4: {
                    throw (RuntimeException)msg.obj;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    static class zzd
    extends zzll {
        private WeakReference<zzli> zzacC;

        zzd(zzli zzli2) {
            this.zzacC = new WeakReference<zzli>(zzli2);
        }

        @Override
        public void zzoi() {
            zzli zzli2 = (zzli)this.zzacC.get();
            if (zzli2 == null) {
                return;
            }
            zzli2.resume();
        }
    }

    private static class zzc
    implements IBinder.DeathRecipient,
    zze {
        private final WeakReference<zzf<?>> zzacz;
        private final WeakReference<com.google.android.gms.common.api.zza> zzacA;
        private final WeakReference<IBinder> zzacB;

        private zzc(zzf zzf2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
            this.zzacA = new WeakReference<com.google.android.gms.common.api.zza>(zza2);
            this.zzacz = new WeakReference<zzf>(zzf2);
            this.zzacB = new WeakReference<IBinder>(iBinder);
        }

        @Override
        public void zzc(zzf<?> zzf2) {
            this.zzoh();
        }

        public void binderDied() {
            this.zzoh();
        }

        private void zzoh() {
            zzf zzf2 = (zzf)this.zzacz.get();
            com.google.android.gms.common.api.zza zza2 = (com.google.android.gms.common.api.zza)this.zzacA.get();
            if (zza2 != null && zzf2 != null) {
                zza2.remove(zzf2.zznF());
            }
            IBinder iBinder = (IBinder)this.zzacB.get();
            if (this.zzacB != null) {
                iBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    }

    static interface zzf<A extends Api.zzb> {
        public void cancel();

        public Api.zzc<A> zznx();

        public void zzb(A var1) throws DeadObjectException;

        public void zzw(Status var1);

        public void zzv(Status var1);

        public void zza(zze var1);

        public void zznJ();

        public int zznK();

        public Integer zznF();

        public boolean isReady();
    }

    static interface zze {
        public void zzc(zzf<?> var1);
    }
}

