/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import java.util.Map;

public class zzmi<K, V> {
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    int[] mHashes;
    Object[] mArray;
    int mSize;

    int indexOf(Object key, int hash) {
        int n;
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = zzmf.binarySearch(this.mHashes, n2, hash);
        if (n3 < 0) {
            return n3;
        }
        if (key.equals(this.mArray[n3 << 1])) {
            return n3;
        }
        for (n = n3 + 1; n < n2 && this.mHashes[n] == hash; ++n) {
            if (!key.equals(this.mArray[n << 1])) continue;
            return n;
        }
        for (int i = n3 - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~n;
    }

    int indexOfNull() {
        int n;
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = zzmf.binarySearch(this.mHashes, n2, 0);
        if (n3 < 0) {
            return n3;
        }
        if (null == this.mArray[n3 << 1]) {
            return n3;
        }
        for (n = n3 + 1; n < n2 && this.mHashes[n] == 0; ++n) {
            if (null != this.mArray[n << 1]) continue;
            return n;
        }
        for (int i = n3 - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void zzbO(int n) {
        if (n == 8) {
            Class<zzme> clazz = zzme.class;
            // MONITORENTER : com.google.android.gms.internal.zzme.class
            if (mTwiceBaseCache != null) {
                Object[] objectArray = mTwiceBaseCache;
                this.mArray = objectArray;
                mTwiceBaseCache = (Object[])objectArray[0];
                this.mHashes = (int[])objectArray[1];
                objectArray[1] = null;
                objectArray[0] = null;
                --mTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        } else if (n == 4) {
            Class<zzme> clazz = zzme.class;
            // MONITORENTER : com.google.android.gms.internal.zzme.class
            if (mBaseCache != null) {
                Object[] objectArray = mBaseCache;
                this.mArray = objectArray;
                mBaseCache = (Object[])objectArray[0];
                this.mHashes = (int[])objectArray[1];
                objectArray[1] = null;
                objectArray[0] = null;
                --mBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[n];
        this.mArray = new Object[n << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void zza(int[] nArray, Object[] objectArray, int n) {
        if (nArray.length == 8) {
            Class<zzme> clazz = zzme.class;
            synchronized (zzme.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                objectArray[0] = mTwiceBaseCache;
                objectArray[1] = nArray;
                for (int i = (n << 1) - 1; i >= 2; --i) {
                    objectArray[i] = null;
                }
                mTwiceBaseCache = objectArray;
                ++mTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (nArray.length != 4) return;
        Class<zzme> clazz = zzme.class;
        synchronized (zzme.class) {
            if (mBaseCacheSize >= 10) return;
            objectArray[0] = mBaseCache;
            objectArray[1] = nArray;
            for (int i = (n << 1) - 1; i >= 2; --i) {
                objectArray[i] = null;
            }
            mBaseCache = objectArray;
            ++mBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public zzmi() {
        this.mHashes = zzmf.EMPTY_INTS;
        this.mArray = zzmf.EMPTY_OBJECTS;
        this.mSize = 0;
    }

    public zzmi(int n) {
        if (n == 0) {
            this.mHashes = zzmf.EMPTY_INTS;
            this.mArray = zzmf.EMPTY_OBJECTS;
        } else {
            this.zzbO(n);
        }
        this.mSize = 0;
    }

    public void clear() {
        if (this.mSize != 0) {
            zzmi.zza(this.mHashes, this.mArray, this.mSize);
            this.mHashes = zzmf.EMPTY_INTS;
            this.mArray = zzmf.EMPTY_OBJECTS;
            this.mSize = 0;
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        if (this.mHashes.length < minimumCapacity) {
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.zzbO(minimumCapacity);
            if (this.mSize > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, this.mSize);
                System.arraycopy(objectArray, 0, this.mArray, 0, this.mSize << 1);
            }
            zzmi.zza(nArray, objectArray, this.mSize);
        }
    }

    public boolean containsKey(Object key) {
        return key == null ? this.indexOfNull() >= 0 : this.indexOf(key, key.hashCode()) >= 0;
    }

    int indexOfValue(Object value) {
        int n = this.mSize * 2;
        Object[] objectArray = this.mArray;
        if (value == null) {
            for (int i = 1; i < n; i += 2) {
                if (objectArray[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < n; i += 2) {
                if (!value.equals(objectArray[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public V get(Object key) {
        int n = key == null ? this.indexOfNull() : this.indexOf(key, key.hashCode());
        return (V)(n >= 0 ? this.mArray[(n << 1) + 1] : null);
    }

    public K keyAt(int index) {
        return (K)this.mArray[index << 1];
    }

    public V valueAt(int index) {
        return (V)this.mArray[(index << 1) + 1];
    }

    public V setValueAt(int index, V value) {
        index = (index << 1) + 1;
        Object object = this.mArray[index];
        this.mArray[index] = value;
        return (V)object;
    }

    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    public V put(K key, V value) {
        int n;
        int n2;
        if (key == null) {
            n2 = 0;
            n = this.indexOfNull();
        } else {
            n2 = key.hashCode();
            n = this.indexOf(key, n2);
        }
        if (n >= 0) {
            n = (n << 1) + 1;
            Object object = this.mArray[n];
            this.mArray[n] = value;
            return (V)object;
        }
        n ^= 0xFFFFFFFF;
        if (this.mSize >= this.mHashes.length) {
            int n3 = this.mSize >= 8 ? this.mSize + (this.mSize >> 1) : (this.mSize >= 4 ? 8 : 4);
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.zzbO(n3);
            if (this.mHashes.length > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, nArray.length);
                System.arraycopy(objectArray, 0, this.mArray, 0, objectArray.length);
            }
            zzmi.zza(nArray, objectArray, this.mSize);
        }
        if (n < this.mSize) {
            System.arraycopy(this.mHashes, n, this.mHashes, n + 1, this.mSize - n);
            System.arraycopy(this.mArray, n << 1, this.mArray, n + 1 << 1, this.mSize - n << 1);
        }
        this.mHashes[n] = n2;
        this.mArray[n << 1] = key;
        this.mArray[(n << 1) + 1] = value;
        ++this.mSize;
        return null;
    }

    public V remove(Object key) {
        int n;
        int n2 = n = key == null ? this.indexOfNull() : this.indexOf(key, key.hashCode());
        if (n >= 0) {
            return this.removeAt(n);
        }
        return null;
    }

    public V removeAt(int index) {
        Object object = this.mArray[(index << 1) + 1];
        if (this.mSize <= 1) {
            zzmi.zza(this.mHashes, this.mArray, this.mSize);
            this.mHashes = zzmf.EMPTY_INTS;
            this.mArray = zzmf.EMPTY_OBJECTS;
            this.mSize = 0;
        } else if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
            int n = this.mSize > 8 ? this.mSize + (this.mSize >> 1) : 8;
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.zzbO(n);
            --this.mSize;
            if (index > 0) {
                System.arraycopy(nArray, 0, this.mHashes, 0, index);
                System.arraycopy(objectArray, 0, this.mArray, 0, index << 1);
            }
            if (index < this.mSize) {
                System.arraycopy(nArray, index + 1, this.mHashes, index, this.mSize - index);
                System.arraycopy(objectArray, index + 1 << 1, this.mArray, index << 1, this.mSize - index << 1);
            }
        } else {
            --this.mSize;
            if (index < this.mSize) {
                System.arraycopy(this.mHashes, index + 1, this.mHashes, index, this.mSize - index);
                System.arraycopy(this.mArray, index + 1 << 1, this.mArray, index << 1, this.mSize - index << 1);
            }
            this.mArray[this.mSize << 1] = null;
            this.mArray[(this.mSize << 1) + 1] = null;
        }
        return (V)object;
    }

    public int size() {
        return this.mSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K k = this.keyAt(i);
                    V v2 = this.valueAt(i);
                    Object v3 = map.get(k);
                    if (!(v2 == null ? v3 != null || !map.containsKey(k) : !v2.equals(v3))) continue;
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int[] nArray = this.mHashes;
        Object[] objectArray = this.mArray;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = this.mSize;
        while (n2 < n4) {
            Object object = objectArray[n3];
            n += nArray[n2] ^ (object == null ? 0 : object.hashCode());
            ++n2;
            n3 += 2;
        }
        return n;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.mSize * 28);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            K k;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if ((k = this.keyAt(i)) != this) {
                stringBuilder.append(k);
            } else {
                stringBuilder.append("(this Map)");
            }
            stringBuilder.append('=');
            V v2 = this.valueAt(i);
            if (v2 != this) {
                stringBuilder.append(v2);
                continue;
            }
            stringBuilder.append("(this Map)");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

