/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.HistoryApi;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.request.DailyTotalRequest;
import com.google.android.gms.fitness.request.DataDeleteRequest;
import com.google.android.gms.fitness.request.DataInsertRequest;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.DailyTotalResult;
import com.google.android.gms.fitness.result.DataReadResult;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzou;

public class zzop
implements HistoryApi {
    @Override
    public PendingResult<Status> insertData(GoogleApiClient client, DataSet dataSet) {
        return this.zza(client, dataSet, false);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final DataSet dataSet, final boolean bl) {
        zzx.zzb(dataSet, (Object)"Must set the data set");
        zzx.zza(!dataSet.getDataPoints().isEmpty(), (Object)"Cannot use an empty data set");
        zzx.zzb(dataSet.getDataSource().zzsr(), (Object)"Must set the app package name for the data source");
        return googleApiClient.zza(new zzno.zzc(googleApiClient){

            @Override
            protected void zza(zzno zzno2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zznz)zzno2.zzpc()).zza(new DataInsertRequest(dataSet, zzou2, bl));
            }
        });
    }

    @Override
    public PendingResult<Status> deleteData(GoogleApiClient client, final DataDeleteRequest request) {
        return client.zza(new zzno.zzc(client){

            @Override
            protected void zza(zzno zzno2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zznz)zzno2.zzpc()).zza(new DataDeleteRequest(request, zzou2));
            }
        });
    }

    @Override
    public PendingResult<DataReadResult> readData(GoogleApiClient client, final DataReadRequest request) {
        return client.zza(new zzno.zza<DataReadResult>(client){

            @Override
            protected void zza(zzno zzno2) throws RemoteException {
                zza zza2 = new zza(this);
                ((zznz)zzno2.zzpc()).zza(new DataReadRequest(request, zza2));
            }

            protected DataReadResult zzJ(Status status) {
                return DataReadResult.zza(status, request);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzJ(status);
            }
        });
    }

    @Override
    public PendingResult<DailyTotalResult> readDailyTotal(GoogleApiClient client, final DataType dataType) {
        return client.zza(new zzno.zza<DailyTotalResult>(client){

            @Override
            protected void zza(zzno zzno2) throws RemoteException {
                zznt.zza zza2 = new zznt.zza(){

                    @Override
                    public void zza(DailyTotalResult dailyTotalResult) throws RemoteException {
                        this.zzb(dailyTotalResult);
                    }
                };
                DailyTotalRequest dailyTotalRequest = new DailyTotalRequest(zza2, dataType);
                ((zznz)zzno2.zzpc()).zza(dailyTotalRequest);
            }

            protected DailyTotalResult zzK(Status status) {
                return DailyTotalResult.zza(status, dataType);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzK(status);
            }
        });
    }

    private static class zza
    extends zznu.zza {
        private final zzlb.zzb<DataReadResult> zzagy;
        private int zzarA = 0;
        private DataReadResult zzarB = null;

        private zza(zzlb.zzb<DataReadResult> zzb2) {
            this.zzagy = zzb2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(DataReadResult dataReadResult) {
            zza zza2 = this;
            synchronized (zza2) {
                Log.v((String)"Fitness", (String)"Received batch result");
                if (this.zzarB == null) {
                    this.zzarB = dataReadResult;
                } else {
                    this.zzarB.zzb(dataReadResult);
                }
                ++this.zzarA;
                if (this.zzarA == this.zzarB.zztn()) {
                    this.zzagy.zzp(this.zzarB);
                }
            }
        }
    }
}

