/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.SessionsApi;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.request.SessionRegistrationRequest;
import com.google.android.gms.fitness.request.SessionStartRequest;
import com.google.android.gms.fitness.request.SessionStopRequest;
import com.google.android.gms.fitness.request.SessionUnregistrationRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzns;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoi;
import com.google.android.gms.internal.zzou;
import java.util.concurrent.TimeUnit;

public class zzot
implements SessionsApi {
    @Override
    public PendingResult<Status> startSession(GoogleApiClient client, final Session session) {
        zzx.zzb(session, (Object)"Session cannot be null");
        zzx.zzb(session.getEndTime(TimeUnit.MILLISECONDS) == 0L, (Object)"Cannot start a session which has already ended");
        return client.zzb(new zzns.zzc(client){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zzod)zzns2.zzpc()).zza(new SessionStartRequest(session, zzou2));
            }
        });
    }

    private PendingResult<SessionStopResult> zza(GoogleApiClient googleApiClient, final String string2, final String string3) {
        return googleApiClient.zzb(new zzns.zza<SessionStopResult>(googleApiClient){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zzb zzb2 = new zzb(this);
                ((zzod)zzns2.zzpc()).zza(new SessionStopRequest(string2, string3, zzb2));
            }

            protected SessionStopResult zzN(Status status) {
                return SessionStopResult.zzU(status);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzN(status);
            }
        });
    }

    @Override
    public PendingResult<SessionStopResult> stopSession(GoogleApiClient client, String identifier) {
        String string2 = null;
        return this.zza(client, string2, identifier);
    }

    @Override
    public PendingResult<Status> insertSession(GoogleApiClient client, final SessionInsertRequest request) {
        return client.zza(new zzns.zzc(client){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zzod)zzns2.zzpc()).zza(new SessionInsertRequest(request, zzou2));
            }
        });
    }

    @Override
    public PendingResult<SessionReadResult> readSession(GoogleApiClient client, final SessionReadRequest request) {
        return client.zza(new zzns.zza<SessionReadResult>(client){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zza zza2 = new zza(this);
                ((zzod)zzns2.zzpc()).zza(new SessionReadRequest(request, zza2));
            }

            protected SessionReadResult zzO(Status status) {
                return SessionReadResult.zzT(status);
            }

            @Override
            protected /* synthetic */ Result zzb(Status status) {
                return this.zzO(status);
            }
        });
    }

    @Override
    public PendingResult<Status> registerForSessions(GoogleApiClient client, PendingIntent intent) {
        return this.zza(client, intent, 0);
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final int n) {
        return googleApiClient.zzb(new zzns.zzc(googleApiClient){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zzod)zzns2.zzpc()).zza(new SessionRegistrationRequest(pendingIntent, zzou2, n));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterForSessions(GoogleApiClient client, final PendingIntent intent) {
        return client.zzb(new zzns.zzc(client){

            @Override
            protected void zza(zzns zzns2) throws RemoteException {
                zzou zzou2 = new zzou(this);
                ((zzod)zzns2.zzpc()).zza(new SessionUnregistrationRequest(intent, zzou2));
            }
        });
    }

    private static class zza
    extends zzoh.zza {
        private final zzlb.zzb<SessionReadResult> zzagy;

        private zza(zzlb.zzb<SessionReadResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(SessionReadResult sessionReadResult) throws RemoteException {
            this.zzagy.zzp(sessionReadResult);
        }
    }

    private static class zzb
    extends zzoi.zza {
        private final zzlb.zzb<SessionStopResult> zzagy;

        private zzb(zzlb.zzb<SessionStopResult> zzb2) {
            this.zzagy = zzb2;
        }

        @Override
        public void zza(SessionStopResult sessionStopResult) {
            this.zzagy.zzp(sessionStopResult);
        }
    }
}

