/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzpu
implements Connections {
    public static final Api.zzc<zzpt> zzRk = new Api.zzc();
    public static final Api.zza<zzpt, Api.ApiOptions.NoOptions> zzRl = new Api.zza<zzpt, Api.ApiOptions.NoOptions>(){

        public zzpt zzo(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzpt(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        @Override
        public /* synthetic */ Api.zzb zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzo(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzpt zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        zzx.zza(googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzpu.zze(googleApiClient, bl);
    }

    public static zzpt zze(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza(googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? googleApiClient.zza(zzRk) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzpu.zzd(apiClient, true).zzAO();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzpu.zzd(apiClient, true).zzAP();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzlm<Connections.ConnectionRequestListener> zzlm2 = apiClient.zzo(connectionRequestListener);
        return apiClient.zzb(new zzb(apiClient){

            @Override
            protected void zza(zzpt zzpt2) throws RemoteException {
                zzpt2.zza(this, name, appMetadata, durationMillis, zzlm2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzpu.zzd(apiClient, false).zzAQ();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzlm<Connections.EndpointDiscoveryListener> zzlm2 = apiClient.zzo(listener);
        return apiClient.zzb(new zzc(apiClient){

            @Override
            protected void zza(zzpt zzpt2) throws RemoteException {
                zzpt2.zza((zzlb.zzb<Status>)this, serviceId, durationMillis, zzlm2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzpu.zzd(apiClient, false).zzej(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzlm<Connections.ConnectionResponseCallback> zzlm2 = apiClient.zzo(connectionResponseCallback);
        final zzlm<Connections.MessageListener> zzlm3 = apiClient.zzo(messageListener);
        return apiClient.zzb(new zzc(apiClient){

            @Override
            protected void zza(zzpt zzpt2) throws RemoteException {
                zzpt2.zza(this, name, remoteEndpointId, payload, zzlm2, zzlm3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzlm<Connections.MessageListener> zzlm2 = apiClient.zzo(messageListener);
        return apiClient.zzb(new zzc(apiClient){

            @Override
            protected void zza(zzpt zzpt2) throws RemoteException {
                zzpt2.zza((zzlb.zzb<Status>)this, remoteEndpointId, payload, zzlm2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb(new zzc(apiClient){

            @Override
            protected void zza(zzpt zzpt2) throws RemoteException {
                zzpt2.zzp(this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzpu.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzpu.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzpu.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzpu.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzpu.zzd(apiClient, false).zzek(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzpu.zzd(apiClient, false).zzAR();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzd(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzd(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaU(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                @Override
                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result zzb(Status status) {
            return this.zzaU(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzlb.zza<R, zzpt> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzRk, googleApiClient);
        }
    }
}

