/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzg;
import com.google.android.gms.common.stats.zzi;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;

public class zzqy {
    private static String TAG = "WakeLock";
    private static boolean DEBUG = false;
    private final PowerManager.WakeLock zzaVs;
    private WorkSource zzaVt;
    private final int zzaVu;
    private final String zzaia;
    private final String zzaVv;
    private final Context mContext;
    private boolean zzaVw = true;
    private int zzaVx;
    private int zzaVy;

    public zzqy(Context context, int n, String string2, String string3, String string4) {
        zzx.zzh(string2, "Wake lock name can NOT be empty");
        this.zzaVu = n;
        this.zzaia = string2;
        this.zzaVv = string3;
        this.mContext = context.getApplicationContext();
        this.zzaVs = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string2);
        if (zznc.zzar(this.mContext)) {
            String string5;
            if (zznb.zzcA(string4)) {
                if (zzd.zzaeK && zzlr.isInitialized()) {
                    Log.e((String)TAG, (String)("callingPackage is not supposed to be empty for wakelock " + this.zzaia + "!"), (Throwable)new IllegalArgumentException());
                    string5 = "com.google.android.gms";
                } else {
                    string5 = context.getPackageName();
                }
            } else {
                string5 = string4;
            }
            this.zzaVt = zznc.zzm(context, string5);
            this.zzc(this.zzaVt);
        }
    }

    public zzqy(Context context, int n, String string2) {
        this(context, n, string2, null, null);
    }

    public void acquire(long timeout) {
        if (!zzmx.zzqx() && this.zzaVw) {
            Log.wtf((String)TAG, (String)("Do not acquire with timeout on reference counted WakeLocks before ICS. wakelock: " + this.zzaia));
        }
        this.zzi(null, timeout);
        this.zzaVs.acquire(timeout);
    }

    public void release() {
        this.zzeu(null);
        this.zzaVs.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string2, long l2) {
        boolean bl = this.zzev(string2);
        String string3 = this.zzj(string2, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Acquire:\n mWakeLockName: " + this.zzaia + "\n mSecondaryName: " + this.zzaVv + "\nmReferenceCounted: " + this.zzaVw + "\nreason: " + string2 + "\nmOpenEventCount" + this.zzaVy + "\nuseWithReason: " + bl + "\ntrackingName: " + string3 + "\ntimeout: " + l2));
        }
        zzqy zzqy2 = this;
        synchronized (zzqy2) {
            if (this.zzaVw && (this.zzaVx++ == 0 || bl) || !this.zzaVw && this.zzaVy == 0) {
                zzi.zzqr().zza(this.mContext, zzg.zza(this.zzaVs, string3), 7, this.zzaia, string3, this.zzaVu, zznc.zzb(this.zzaVt), l2);
                ++this.zzaVy;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeu(String string2) {
        boolean bl = this.zzev(string2);
        String string3 = this.zzj(string2, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Release:\n mWakeLockName: " + this.zzaia + "\n mSecondaryName: " + this.zzaVv + "\nmReferenceCounted: " + this.zzaVw + "\nreason: " + string2 + "\n mOpenEventCount" + this.zzaVy + "\nuseWithReason: " + bl + "\ntrackingName: " + string3));
        }
        zzqy zzqy2 = this;
        synchronized (zzqy2) {
            if (this.zzaVw && (--this.zzaVx == 0 || bl) || !this.zzaVw && this.zzaVy == 1) {
                zzi.zzqr().zza(this.mContext, zzg.zza(this.zzaVs, string3), 8, this.zzaia, string3, this.zzaVu, zznc.zzb(this.zzaVt));
                --this.zzaVy;
            }
        }
    }

    private boolean zzev(String string2) {
        return !TextUtils.isEmpty((CharSequence)string2) && !string2.equals(this.zzaVv);
    }

    private String zzj(String string2, boolean bl) {
        return this.zzaVw ? (bl ? string2 : this.zzaVv) : this.zzaVv;
    }

    public void setReferenceCounted(boolean value) {
        this.zzaVs.setReferenceCounted(value);
        this.zzaVw = value;
    }

    public boolean isHeld() {
        return this.zzaVs.isHeld();
    }

    public void zzc(WorkSource workSource) {
        if (zznc.zzar(this.mContext) && workSource != null) {
            if (this.zzaVt != null) {
                this.zzaVt.add(workSource);
            } else {
                this.zzaVt = workSource;
            }
            this.zzaVs.setWorkSource(this.zzaVt);
        }
    }
}

