/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zze;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
implements SafeParcelable {
    static final List<Location> zzaEJ = Collections.emptyList();
    private final int mVersionCode;
    private final List<Location> zzaEK;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zze();

    public static LocationResult create(List<Location> locations) {
        if (locations == null) {
            locations = zzaEJ;
        }
        return new LocationResult(2, locations);
    }

    LocationResult(int versionCode, List<Location> locations) {
        this.mVersionCode = versionCode;
        this.zzaEK = locations;
    }

    public Location getLastLocation() {
        int n = this.zzaEK.size();
        if (n == 0) {
            return null;
        }
        return this.zzaEK.get(n - 1);
    }

    public List<Location> getLocations() {
        return this.zzaEK;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public int hashCode() {
        int n = 17;
        for (Location location : this.zzaEK) {
            long l2 = location.getTime();
            int n2 = (int)(l2 ^ l2 >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)other;
        if (locationResult.zzaEK.size() != this.zzaEK.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzaEK.iterator();
        Iterator<Location> iterator2 = this.zzaEK.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "LocationResult[locations: " + this.zzaEK + "]";
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

