/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.LocationRequestUpdateData;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzp;
import com.google.android.gms.location.zzc;
import com.google.android.gms.location.zzd;
import java.util.HashMap;
import java.util.Map;

public class zzk {
    private final zzp<zzi> zzaFb;
    private final Context mContext;
    private ContentProviderClient zzaFv = null;
    private boolean zzaFw = false;
    private Map<LocationListener, zzc> zzaqR = new HashMap<LocationListener, zzc>();
    private Map<LocationCallback, zza> zzaFx = new HashMap<LocationCallback, zza>();

    public zzk(Context context, zzp<zzi> zzp2) {
        this.mContext = context;
        this.zzaFb = zzp2;
    }

    public Location getLastLocation() {
        this.zzaFb.zzpb();
        try {
            return this.zzaFb.zzpc().zzdv(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public LocationAvailability zzwD() {
        this.zzaFb.zzpb();
        try {
            return this.zzaFb.zzpc().zzdw(this.mContext.getPackageName());
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        zzc zzc2 = this.zza(locationListener, looper);
        this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), zzc2, zzg2));
    }

    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        zza zza2 = this.zza(locationCallback, looper);
        this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(locationRequestInternal, zza2, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzc zza(LocationListener locationListener, Looper looper) {
        Map<LocationListener, zzc> map = this.zzaqR;
        synchronized (map) {
            zzc zzc2 = this.zzaqR.get(locationListener);
            if (zzc2 == null) {
                zzc2 = new zzc(locationListener, looper);
            }
            this.zzaqR.put(locationListener, zzc2);
            return zzc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zza zza(LocationCallback locationCallback, Looper looper) {
        Map<LocationListener, zzc> map = this.zzaqR;
        synchronized (map) {
            zza zza2 = this.zzaFx.get(locationCallback);
            if (zza2 == null) {
                zza2 = new zza(locationCallback, looper);
            }
            this.zzaFx.put(locationCallback, zza2);
            return zza2;
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(LocationRequestInternal.zzb(locationRequest), pendingIntent, zzg2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        zzx.zzb(locationListener, (Object)"Invalid null listener");
        Map<LocationListener, zzc> map = this.zzaqR;
        synchronized (map) {
            zzc zzc2 = this.zzaqR.remove(locationListener);
            if (this.zzaFv != null && this.zzaqR.isEmpty()) {
                this.zzaFv.release();
                this.zzaFv = null;
            }
            if (zzc2 != null) {
                zzc2.release();
                this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(zzc2, zzg2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        zzx.zzb(locationCallback, (Object)"Invalid null callback");
        Map<LocationCallback, zza> map = this.zzaFx;
        synchronized (map) {
            zza zza2 = this.zzaFx.remove(locationCallback);
            if (zza2 != null) {
                zza2.release();
                this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(zza2, zzg2));
            }
        }
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaFb.zzpb();
        this.zzaFb.zzpc().zza(LocationRequestUpdateData.zzb(pendingIntent, zzg2));
    }

    public void zzah(boolean bl) throws RemoteException {
        this.zzaFb.zzpb();
        this.zzaFb.zzpc().zzah(bl);
        this.zzaFw = bl;
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaFb.zzpb();
        this.zzaFb.zzpc().zzc(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        try {
            Map<LocationListener, zzc> map = this.zzaqR;
            synchronized (map) {
                for (zzc binder : this.zzaqR.values()) {
                    if (binder == null) continue;
                    this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(binder, null));
                }
                this.zzaqR.clear();
                for (zza zza2 : this.zzaFx.values()) {
                    if (zza2 == null) continue;
                    this.zzaFb.zzpc().zza(LocationRequestUpdateData.zza(zza2, null));
                }
                this.zzaFx.clear();
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzwE() {
        if (this.zzaFw) {
            try {
                this.zzah(false);
            }
            catch (RemoteException remoteException) {
                throw new IllegalStateException(remoteException);
            }
        }
    }

    private static class zzb
    extends Handler {
        private final LocationListener zzaFA;

        public zzb(LocationListener locationListener) {
            this.zzaFA = locationListener;
        }

        public zzb(LocationListener locationListener, Looper looper) {
            super(looper);
            this.zzaFA = locationListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Location location = new Location((Location)msg.obj);
                    this.zzaFA.onLocationChanged(location);
                    break;
                }
                default: {
                    Log.e((String)"LocationClientHelper", (String)"unknown message in LocationHandler.handleMessage");
                }
            }
        }
    }

    private static class zza
    extends zzc.zza {
        private Handler zzaFy;

        zza(final LocationCallback locationCallback, Looper looper) {
            if (looper == null) {
                looper = Looper.myLooper();
                zzx.zza(looper != null, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaFy = new Handler(looper){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            locationCallback.onLocationResult((LocationResult)msg.obj);
                            break;
                        }
                        case 1: {
                            locationCallback.onLocationAvailability((LocationAvailability)msg.obj);
                        }
                    }
                }
            };
        }

        @Override
        public void onLocationResult(LocationResult locationResult) {
            this.zzb(0, locationResult);
        }

        @Override
        public void onLocationAvailability(LocationAvailability state) {
            this.zzb(1, state);
        }

        public void release() {
            this.zzaFy = null;
        }

        private void zzb(int n, Object object) {
            if (this.zzaFy == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a data in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = n;
            message.obj = object;
            this.zzaFy.sendMessage(message);
        }
    }

    private static class zzc
    extends zzd.zza {
        private Handler zzaFy;

        zzc(LocationListener locationListener, Looper looper) {
            if (looper == null) {
                zzx.zza(Looper.myLooper() != null, (Object)"Can't create handler inside thread that has not called Looper.prepare()");
            }
            this.zzaFy = looper == null ? new zzb(locationListener) : new zzb(locationListener, looper);
        }

        @Override
        public void onLocationChanged(Location location) {
            if (this.zzaFy == null) {
                Log.e((String)"LocationClientHelper", (String)"Received a location in client after calling removeLocationUpdates.");
                return;
            }
            Message message = Message.obtain();
            message.what = 1;
            message.obj = location;
            this.zzaFy.sendMessage(message);
        }

        public void release() {
            this.zzaFy = null;
        }
    }
}

