/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.internal.zzj;
import com.google.android.gms.location.internal.zzk;
import java.util.List;

public class zzl
extends com.google.android.gms.location.internal.zzb {
    private final zzk zzaFB;

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string2, zzf.zzak(context));
    }

    public zzl(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string2, zzf zzf2) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string2, zzf2);
        this.zzaFB = new zzk(context, this.zzaFb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        zzk zzk2 = this.zzaFB;
        synchronized (zzk2) {
            if (this.isConnected()) {
                try {
                    this.zzaFB.removeAllListeners();
                    this.zzaFB.zzwE();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    @Override
    public boolean zzpe() {
        return true;
    }

    public void zza(long l2, PendingIntent pendingIntent) throws RemoteException {
        this.zzpb();
        zzx.zzw(pendingIntent);
        zzx.zzb(l2 >= 0L, (Object)"detectionIntervalMillis must be >= 0");
        ((zzi)this.zzpc()).zza(l2, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zzpb();
        zzx.zzw(pendingIntent);
        ((zzi)this.zzpc()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zzlb.zzb<Status> zzb2) throws RemoteException {
        this.zzpb();
        zzx.zzb(geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzx.zzb(pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zza zza2 = new zza(zzb2);
        ((zzi)this.zzpc()).zza(geofencingRequest, pendingIntent, zza2);
    }

    public void zza(PendingIntent pendingIntent, zzlb.zzb<Status> zzb2) throws RemoteException {
        this.zzpb();
        zzx.zzb(pendingIntent, (Object)"PendingIntent must be specified.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzpc()).zza(pendingIntent, (zzh)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zzlb.zzb<Status> zzb2) throws RemoteException {
        this.zzpb();
        zzx.zzb(list != null && list.size() > 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzx.zzb(zzb2, (Object)"ResultHolder not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = new zzb(zzb2);
        ((zzi)this.zzpc()).zza(stringArray, (zzh)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzaFB.getLastLocation();
    }

    public LocationAvailability zzwD() {
        return this.zzaFB.zzwD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaFB;
        synchronized (zzk2) {
            this.zzaFB.zza(locationRequestInternal, locationCallback, looper, zzg2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper, zzg zzg2) throws RemoteException {
        zzk zzk2 = this.zzaFB;
        synchronized (zzk2) {
            this.zzaFB.zza(locationRequest, locationListener, looper, zzg2);
        }
    }

    public void zza(LocationRequest locationRequest, PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaFB.zza(locationRequest, pendingIntent, zzg2);
    }

    public void zza(LocationListener locationListener, zzg zzg2) throws RemoteException {
        this.zzaFB.zza(locationListener, zzg2);
    }

    public void zza(PendingIntent pendingIntent, zzg zzg2) throws RemoteException {
        this.zzaFB.zza(pendingIntent, zzg2);
    }

    public void zza(LocationCallback locationCallback, zzg zzg2) throws RemoteException {
        this.zzaFB.zza(locationCallback, zzg2);
    }

    public void zzah(boolean bl) throws RemoteException {
        this.zzaFB.zzah(bl);
    }

    public void zzc(Location location) throws RemoteException {
        this.zzaFB.zzc(location);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zzlb.zzb<LocationSettingsResult> zzb2, String string2) throws RemoteException {
        this.zzpb();
        zzx.zzb(locationSettingsRequest != null, (Object)"locationSettingsRequest can't be null nor empty.");
        zzx.zzb(zzb2 != null, (Object)"listener can't be null.");
        zzc zzc2 = new zzc(zzb2);
        ((zzi)this.zzpc()).zza(locationSettingsRequest, zzc2, string2);
    }

    private static final class zzc
    extends zzj.zza {
        private zzlb.zzb<LocationSettingsResult> zzaFC;

        public zzc(zzlb.zzb<LocationSettingsResult> zzb2) {
            zzx.zzb(zzb2 != null, (Object)"listener can't be null.");
            this.zzaFC = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzaFC.zzp(locationSettingsResult);
            this.zzaFC = null;
        }
    }

    private static final class zzb
    extends zzh.zza {
        private zzlb.zzb<Status> zzaFC;

        public zzb(zzlb.zzb<Status> zzb2) {
            this.zzaFC = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onAddGeofencesResult");
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            this.zzgZ(n);
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            this.zzgZ(n);
        }

        private void zzgZ(int n) {
            if (this.zzaFC == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzgW(LocationStatusCodes.zzgV(n));
            this.zzaFC.zzp(status);
            this.zzaFC = null;
        }
    }

    private static final class zza
    extends zzh.zza {
        private zzlb.zzb<Status> zzaFC;

        public zza(zzlb.zzb<Status> zzb2) {
            this.zzaFC = zzb2;
        }

        @Override
        public void zza(int n, String[] stringArray) {
            if (this.zzaFC == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            Status status = LocationStatusCodes.zzgW(LocationStatusCodes.zzgV(n));
            this.zzaFC.zzp(status);
            this.zzaFC = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByRequestIdsResult");
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            Log.wtf((String)"LocationClientImpl", (String)"Unexpected call to onRemoveGeofencesByPendingIntentResult");
        }
    }
}

