/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.internal.PlaceLocalization;
import com.google.android.gms.location.places.internal.zzl;
import com.google.android.gms.location.places.internal.zzp;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class PlaceImpl
implements SafeParcelable,
Place {
    public static final zzl CREATOR = new zzl();
    final int mVersionCode;
    private final String zzwN;
    private final Bundle zzaHi;
    @Deprecated
    private final PlaceLocalization zzaHj;
    private final LatLng zzaFS;
    private final float zzaHk;
    private final LatLngBounds zzaHl;
    private final String zzaHm;
    private final Uri zzaFV;
    private final boolean zzaHn;
    private final float zzaHo;
    private final int zzaHp;
    private final long zzaHq;
    private final List<Integer> zzaHr;
    private final List<Integer> zzaFT;
    private final String mName;
    private final String zzapU;
    private final String zzaFU;
    private final String zzaHs;
    private final List<String> zzaHt;
    final boolean zzaHu;
    private final Map<Integer, String> zzaHv;
    private final TimeZone zzaHw;
    private Locale zzaHc;
    private zzp zzaHx;

    PlaceImpl(int versionCode, String id, List<Integer> placeTypes, List<Integer> typesDeprecated, Bundle addressComponents, String name, String address, String phoneNumber, String regularOpenHours, List<String> attributions, LatLng latlng, float levelNumber, LatLngBounds viewport, String timeZoneId, Uri websiteUri, boolean isPermanentlyClosed, float rating, int priceLevel, long timestampSecs, boolean isLoggingEnabled, PlaceLocalization localization) {
        this.mVersionCode = versionCode;
        this.zzwN = id;
        this.zzaFT = Collections.unmodifiableList(placeTypes);
        this.zzaHr = typesDeprecated;
        this.zzaHi = addressComponents != null ? addressComponents : new Bundle();
        this.mName = name;
        this.zzapU = address;
        this.zzaFU = phoneNumber;
        this.zzaHs = regularOpenHours;
        this.zzaHt = attributions != null ? attributions : Collections.emptyList();
        this.zzaFS = latlng;
        this.zzaHk = levelNumber;
        this.zzaHl = viewport;
        this.zzaHm = timeZoneId != null ? timeZoneId : "UTC";
        this.zzaFV = websiteUri;
        this.zzaHn = isPermanentlyClosed;
        this.zzaHo = rating;
        this.zzaHp = priceLevel;
        this.zzaHq = timestampSecs;
        HashMap hashMap = new HashMap();
        this.zzaHv = Collections.unmodifiableMap(hashMap);
        this.zzaHw = null;
        this.zzaHc = null;
        this.zzaHu = isLoggingEnabled;
        this.zzaHj = localization;
    }

    @Override
    public String getId() {
        this.zzdz("getId");
        return this.zzwN;
    }

    @Override
    public List<Integer> getPlaceTypes() {
        this.zzdz("getPlaceTypes");
        return this.zzaFT;
    }

    public List<Integer> zzxd() {
        this.zzdz("getTypesDeprecated");
        return this.zzaHr;
    }

    @Override
    public Locale getLocale() {
        this.zzdz("getLocale");
        return this.zzaHc;
    }

    public void setLocale(Locale locale) {
        this.zzaHc = locale;
    }

    @Override
    public String getName() {
        this.zzdz("getName");
        return this.mName;
    }

    @Override
    public String getAddress() {
        this.zzdz("getAddress");
        return this.zzapU;
    }

    @Override
    public LatLng getLatLng() {
        this.zzdz("getLatLng");
        return this.zzaFS;
    }

    public float zzxe() {
        this.zzdz("getLevelNumber");
        return this.zzaHk;
    }

    @Override
    public LatLngBounds getViewport() {
        this.zzdz("getViewport");
        return this.zzaHl;
    }

    @Override
    public Uri getWebsiteUri() {
        this.zzdz("getWebsiteUri");
        return this.zzaFV;
    }

    @Override
    public String getPhoneNumber() {
        this.zzdz("getPhoneNumber");
        return this.zzaFU;
    }

    public String zzxf() {
        this.zzdz("getRegularOpenHours");
        return this.zzaHs;
    }

    public List<String> zzxg() {
        this.zzdz("getAttributions");
        return this.zzaHt;
    }

    public boolean zzxh() {
        this.zzdz("isPermanentlyClosed");
        return this.zzaHn;
    }

    @Override
    public float getRating() {
        this.zzdz("getRating");
        return this.zzaHo;
    }

    @Override
    public int getPriceLevel() {
        this.zzdz("getPriceLevel");
        return this.zzaHp;
    }

    public long zzxi() {
        return this.zzaHq;
    }

    public String toString() {
        return zzw.zzv(this).zzg("id", this.zzwN).zzg("placeTypes", this.zzaFT).zzg("locale", this.zzaHc).zzg("name", this.mName).zzg("address", this.zzapU).zzg("phoneNumber", this.zzaFU).zzg("latlng", this.zzaFS).zzg("viewport", this.zzaHl).zzg("websiteUri", this.zzaFV).zzg("isPermanentlyClosed", this.zzaHn).zzg("priceLevel", this.zzaHp).zzg("timestampSecs", this.zzaHq).toString();
    }

    public int hashCode() {
        return zzw.hashCode(this.zzwN, this.zzaHc, this.zzaHq);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlaceImpl)) {
            return false;
        }
        PlaceImpl placeImpl = (PlaceImpl)object;
        return this.zzwN.equals(placeImpl.zzwN) && zzw.equal(this.zzaHc, placeImpl.zzaHc) && this.zzaHq == placeImpl.zzaHq;
    }

    public Bundle zzxj() {
        return this.zzaHi;
    }

    public String zzxk() {
        return this.zzaHm;
    }

    @Deprecated
    public PlaceLocalization zzxl() {
        this.zzdz("getLocalization");
        return this.zzaHj;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzl.zza(this, parcel, flags);
    }

    public void zza(zzp zzp2) {
        this.zzaHx = zzp2;
    }

    private void zzdz(String string2) {
        if (this.zzaHu && this.zzaHx != null) {
            this.zzaHx.zzE(this.zzwN, string2);
        }
    }

    public Place zzxm() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.zzxm();
    }

    public static class zza {
        private int mVersionCode = 0;
        private String zzwN;
        private Bundle zzaHy;
        private String mName;
        private LatLng zzaFS;
        private float zzaHk;
        private LatLngBounds zzaHl;
        private String zzaHm;
        private Uri zzaFV;
        private boolean zzaHn;
        private float zzaHo;
        private int zzaHp;
        private long zzaHq;
        private List<Integer> zzaHz;
        private String zzapU;
        private String zzaFU;
        private String zzaHs;
        private List<String> zzaHt;
        private boolean zzaHu;

        public zza zzdA(String string2) {
            this.zzwN = string2;
            return this;
        }

        public zza zzdB(String string2) {
            this.mName = string2;
            return this;
        }

        public zza zza(LatLng latLng) {
            this.zzaFS = latLng;
            return this;
        }

        public zza zzf(float f) {
            this.zzaHk = f;
            return this;
        }

        public zza zza(LatLngBounds latLngBounds) {
            this.zzaHl = latLngBounds;
            return this;
        }

        public zza zzl(Uri uri) {
            this.zzaFV = uri;
            return this;
        }

        public zza zzai(boolean bl) {
            this.zzaHn = bl;
            return this;
        }

        public zza zzg(float f) {
            this.zzaHo = f;
            return this;
        }

        public zza zzhs(int n) {
            this.zzaHp = n;
            return this;
        }

        public zza zzt(List<Integer> list) {
            this.zzaHz = list;
            return this;
        }

        public zza zzdC(String string2) {
            this.zzapU = string2;
            return this;
        }

        public zza zzdD(String string2) {
            this.zzaFU = string2;
            return this;
        }

        public zza zzu(List<String> list) {
            this.zzaHt = list;
            return this;
        }

        public zza zzaj(boolean bl) {
            this.zzaHu = bl;
            return this;
        }

        public PlaceImpl zzxn() {
            return new PlaceImpl(this.mVersionCode, this.zzwN, this.zzaHz, Collections.emptyList(), this.zzaHy, this.mName, this.zzapU, this.zzaFU, this.zzaHs, this.zzaHt, this.zzaFS, this.zzaHk, this.zzaHl, this.zzaHm, this.zzaFV, this.zzaHn, this.zzaHo, this.zzaHp, this.zzaHq, this.zzaHu, PlaceLocalization.zza(this.mName, this.zzapU, this.zzaFU, this.zzaHs, this.zzaHt));
        }
    }
}

