/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class MapView
extends FrameLayout {
    private final zzb zzaIU;
    private GoogleMap zzaIO;

    public MapView(Context context) {
        super(context);
        this.zzaIU = new zzb((ViewGroup)this, context, null);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.zzaIU = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.zzaIU = new zzb((ViewGroup)this, context, GoogleMapOptions.createFromAttributes(context, attrs));
        this.init();
    }

    public MapView(Context context, GoogleMapOptions options) {
        super(context);
        this.zzaIU = new zzb((ViewGroup)this, context, options);
        this.init();
    }

    private void init() {
        this.setClickable(true);
    }

    @Deprecated
    public final GoogleMap getMap() {
        if (this.zzaIO != null) {
            return this.zzaIO;
        }
        this.zzaIU.zzxL();
        if (this.zzaIU.zzrZ() == null) {
            return null;
        }
        try {
            this.zzaIO = new GoogleMap(((zza)this.zzaIU.zzrZ()).zzxM().getMap());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this.zzaIO;
    }

    public final void onCreate(Bundle savedInstanceState) {
        this.zzaIU.onCreate(savedInstanceState);
        if (this.zzaIU.zzrZ() == null) {
            com.google.android.gms.dynamic.zza.zzb(this);
        }
    }

    public final void onResume() {
        this.zzaIU.onResume();
    }

    public final void onPause() {
        this.zzaIU.onPause();
    }

    public final void onDestroy() {
        this.zzaIU.onDestroy();
    }

    public final void onLowMemory() {
        this.zzaIU.onLowMemory();
    }

    public final void onSaveInstanceState(Bundle outState) {
        this.zzaIU.onSaveInstanceState(outState);
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        zzx.zzci("getMapAsync() must be called on the main thread");
        this.zzaIU.getMapAsync(callback);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        zzx.zzci("onEnterAmbient() must be called on the main thread");
        this.zzaIU.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        zzx.zzci("onExitAmbient() must be called on the main thread");
        this.zzaIU.onExitAmbient();
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final ViewGroup zzaIZ;
        private final Context mContext;
        protected zzf<zza> zzaIS;
        private final GoogleMapOptions zzaJa;
        private final List<OnMapReadyCallback> zzaIT = new ArrayList<OnMapReadyCallback>();

        zzb(ViewGroup viewGroup, Context context, GoogleMapOptions googleMapOptions) {
            this.zzaIZ = viewGroup;
            this.mContext = context;
            this.zzaJa = googleMapOptions;
        }

        @Override
        protected void zza(zzf<zza> zzf2) {
            this.zzaIS = zzf2;
            this.zzxL();
        }

        public void zzxL() {
            if (this.zzaIS != null && this.zzrZ() == null) {
                try {
                    MapsInitializer.initialize(this.mContext);
                    IMapViewDelegate iMapViewDelegate = zzy.zzaG(this.mContext).zza(zze.zzy(this.mContext), this.zzaJa);
                    if (iMapViewDelegate == null) {
                        return;
                    }
                    this.zzaIS.zza(new zza(this.zzaIZ, iMapViewDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaIT) {
                        ((zza)this.zzrZ()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaIT.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).getMapAsync(callback);
            } else {
                this.zzaIT.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final ViewGroup zzaIV;
        private final IMapViewDelegate zzaIW;
        private View zzaIX;

        public zza(ViewGroup viewGroup, IMapViewDelegate iMapViewDelegate) {
            this.zzaIW = zzx.zzw(iMapViewDelegate);
            this.zzaIV = zzx.zzw(viewGroup);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onInflate not allowed on MapViewDelegate");
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaIW.onCreate(savedInstanceState);
                this.zzaIX = (View)zze.zzp(this.zzaIW.getView());
                this.zzaIV.removeAllViews();
                this.zzaIV.addView(this.zzaIX);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            throw new UnsupportedOperationException("onCreateView not allowed on MapViewDelegate");
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.zzaIW.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.zzaIW.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            throw new UnsupportedOperationException("onDestroyView not allowed on MapViewDelegate");
        }

        @Override
        public void onDestroy() {
            try {
                this.zzaIW.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.zzaIW.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaIW.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapViewDelegate zzxM() {
            return this.zzaIW;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaIW.getMapAsync(new zzl.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaIW.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaIW.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

