/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzx;
import com.google.android.gms.maps.internal.zzy;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzaJA = new zzb(this);
    private GoogleMap zzaIO;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions options) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate zzxK() {
        this.zzaJA.zzxL();
        if (this.zzaJA.zzrZ() == null) {
            return null;
        }
        return ((zza)this.zzaJA.zzrZ()).zzxK();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zzxK();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzaIO == null || this.zzaIO.zzxy().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzaIO = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzaIO;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzaJA.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.zzaJA.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzaJA.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.zzaJA.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = this.zzaJA.onCreateView(inflater, container, savedInstanceState);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzaJA.onResume();
    }

    public void onPause() {
        this.zzaJA.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzaJA.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzaJA.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzaJA.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.zzaJA.onSaveInstanceState(outState);
    }

    public final void onEnterAmbient(Bundle ambientDetails) {
        com.google.android.gms.common.internal.zzx.zzci("onEnterAmbient must be called on the main thread.");
        this.zzaJA.onEnterAmbient(ambientDetails);
    }

    public final void onExitAmbient() {
        com.google.android.gms.common.internal.zzx.zzci("onExitAmbient must be called on the main thread.");
        this.zzaJA.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback callback) {
        com.google.android.gms.common.internal.zzx.zzci("getMapAsync must be called on the main thread.");
        this.zzaJA.getMapAsync(callback);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzafl;
        protected zzf<zza> zzaIS;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzaIT = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzafl = fragment;
        }

        @Override
        protected void zza(zzf<zza> zzf2) {
            this.zzaIS = zzf2;
            this.zzxL();
        }

        public void zzxL() {
            if (this.mActivity != null && this.zzaIS != null && this.zzrZ() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzy.zzaG((Context)this.mActivity).zzt(zze.zzy(this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzaIS.zza(new zza(this.zzafl, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaIT) {
                        ((zza)this.zzrZ()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaIT.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzxL();
        }

        public void getMapAsync(OnMapReadyCallback callback) {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).getMapAsync(callback);
            } else {
                this.zzaIT.add(callback);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).onEnterAmbient(ambientDetails);
            }
        }

        public void onExitAmbient() {
            if (this.zzrZ() != null) {
                ((zza)this.zzrZ()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzafl;
        private final IMapFragmentDelegate zzaIP;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzaIP = com.google.android.gms.common.internal.zzx.zzw(iMapFragmentDelegate);
            this.zzafl = com.google.android.gms.common.internal.zzx.zzw(fragment);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.zzaIP.onInflate(zze.zzy(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.zzafl.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    zzx.zza(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.zzaIP.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            zzd zzd2;
            try {
                zzd2 = this.zzaIP.onCreateView(zze.zzy(inflater), zze.zzy(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzp(zzd2);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.zzaIP.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.zzaIP.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            try {
                this.zzaIP.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onDestroy() {
            try {
                this.zzaIP.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.zzaIP.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaIP.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zzxK() {
            return this.zzaIP;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback callback) {
            try {
                this.zzaIP.getMapAsync(new zzl.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        callback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle ambientDetails) {
            try {
                this.zzaIP.onEnterAmbient(ambientDetails);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaIP.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

