/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zze;

public final class LatLng
implements SafeParcelable {
    public static final zze CREATOR = new zze();
    private final int mVersionCode;
    public final double latitude;
    public final double longitude;

    LatLng(int versionCode, double latitude, double longitude) {
        this.mVersionCode = versionCode;
        this.longitude = -180.0 <= longitude && longitude < 180.0 ? longitude : ((longitude - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        this.latitude = Math.max(-90.0, Math.min(90.0, latitude));
    }

    public LatLng(double latitude, double longitude) {
        this(1, latitude, longitude);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public void writeToParcel(Parcel out, int flags) {
        zze.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l2 = Double.doubleToLongBits(this.latitude);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.longitude);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLng)) {
            return false;
        }
        LatLng latLng = (LatLng)o;
        return Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(latLng.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(latLng.longitude);
    }

    public String toString() {
        return "lat/lng: (" + this.latitude + "," + this.longitude + ")";
    }
}

