/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.maps.model.zzk;

public class StreetViewPanoramaLink
implements SafeParcelable {
    public static final zzk CREATOR = new zzk();
    private final int mVersionCode;
    public final String panoId;
    public final float bearing;

    StreetViewPanoramaLink(int versionCode, String panoId, float bearing) {
        this.mVersionCode = versionCode;
        this.panoId = panoId;
        this.bearing = ((double)bearing <= 0.0 ? bearing % 360.0f + 360.0f : bearing) % 360.0f;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzk.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return zzw.hashCode(this.panoId, Float.valueOf(this.bearing));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreetViewPanoramaLink)) {
            return false;
        }
        StreetViewPanoramaLink streetViewPanoramaLink = (StreetViewPanoramaLink)o;
        return this.panoId.equals(streetViewPanoramaLink.panoId) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaLink.bearing);
    }

    public String toString() {
        return zzw.zzv(this).zzg("panoId", this.panoId).zzg("bearing", Float.valueOf(this.bearing)).toString();
    }
}

