/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class zzag
extends zzx {
    zzag(zzv zzv2) {
        super(zzv2);
    }

    void zzc(String string2, int n, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException(string2 + " name is required and can't be null");
        }
        if (string3.length() == 0) {
            throw new IllegalArgumentException(string2 + " name is required and can't be empty");
        }
        char c = string3.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            throw new IllegalArgumentException(string2 + " name must start with a letter or _");
        }
        for (int i = 1; i < string3.length(); ++i) {
            char c2 = string3.charAt(i);
            if (c2 == '_' || Character.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException(string2 + " name must consist of letters, digits or _ (underscores)");
        }
        if (string3.length() > n) {
            throw new IllegalArgumentException(string2 + " name is too long. The maximum supported length is " + n);
        }
    }

    public void zzef(String string2) {
        this.zzc("user attribute", this.zzzt().zzyT(), string2);
    }

    private Object zzc(int n, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Float) {
            return object;
        }
        if (object instanceof Integer) {
            long l2 = ((Integer)object).intValue();
            return l2;
        }
        if (object instanceof Byte) {
            long l3 = ((Byte)object).byteValue();
            return l3;
        }
        if (object instanceof Short) {
            long l4 = ((Short)object).shortValue();
            return l4;
        }
        if (object instanceof Boolean) {
            long l5 = (Boolean)object != false ? 1L : 0L;
            return l5;
        }
        if (object instanceof Double) {
            float f = (float)((Double)object).doubleValue();
            return Float.valueOf(f);
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string2 = String.valueOf(object);
            if (string2.length() > n) {
                return null;
            }
            return string2;
        }
        return null;
    }

    public Object zzC(Object object) {
        return this.zzc(this.zzzt().zzyU(), object);
    }

    public Object zzD(Object object) {
        return this.zzc(this.zzzt().zzyV(), object);
    }

    public void zza(zzpk.zze zze2, Object object) {
        com.google.android.gms.common.internal.zzx.zzw(object);
        zze2.zzagS = null;
        zze2.zzaOH = null;
        zze2.zzaOB = null;
        if (object instanceof String) {
            zze2.zzagS = (String)object;
        } else if (object instanceof Long) {
            zze2.zzaOH = (Long)object;
        } else if (object instanceof Float) {
            zze2.zzaOB = (Float)object;
        } else {
            this.zzyd().zzzK().zzj("Ignoring invalid (type) user attribute value", object);
        }
    }

    public void zza(zzpk.zzb zzb2, Object object) {
        com.google.android.gms.common.internal.zzx.zzw(object);
        zzb2.zzagS = null;
        zzb2.zzaOH = null;
        zzb2.zzaOB = null;
        if (object instanceof String) {
            zzb2.zzagS = (String)object;
        } else if (object instanceof Long) {
            zzb2.zzaOH = (Long)object;
        } else if (object instanceof Float) {
            zzb2.zzaOB = (Float)object;
        } else {
            this.zzyd().zzzK().zzj("Ignoring invalid (type) event param value", object);
        }
    }

    public void zza(Bundle bundle, String string2, Object object) {
        if (object instanceof Long) {
            bundle.putLong(string2, ((Long)object).longValue());
            return;
        }
        if (object instanceof Float) {
            bundle.putFloat(string2, ((Float)object).floatValue());
            return;
        }
        if (object instanceof String) {
            String string3 = String.valueOf(object);
            bundle.putString(string2, string3);
            return;
        }
        if (string2 != null) {
            this.zzyd().zzzN().zze("Not putting event parameter. Invalid value type. name, type", string2, object.getClass().getSimpleName());
        }
    }

    public byte[] zzg(byte[] byArray) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            this.zzyd().zzzK().zzj("Failed to gzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zzp(byte[] byArray) throws IOException {
        try {
            int n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            byteArrayInputStream.close();
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return byArray3;
        }
        catch (IOException iOException) {
            this.zzyd().zzzK().zzj("Failed to ungzip content", iOException);
            throw iOException;
        }
    }

    public byte[] zza(zzpk.zzc zzc2) {
        try {
            int n = zzc2.zzFR();
            byte[] byArray = new byte[n];
            zzrx zzrx2 = zzrx.zzC(byArray);
            zzc2.zza(zzrx2);
            zzrx2.zzFE();
            return byArray;
        }
        catch (IOException iOException) {
            this.zzyd().zzzK().zzj("Data loss. Failed to serialize batch", iOException);
            return null;
        }
    }

    public boolean zzc(long l2, long l3) {
        if (l2 == 0L || l3 <= 0L) {
            return true;
        }
        return Math.abs(this.zzit().currentTimeMillis() - l2) > l3;
    }

    public static boolean zza(Context context, Class<? extends BroadcastReceiver> clazz, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, clazz), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zza(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public boolean zzbh(String string2) {
        this.zzis();
        int n = this.getContext().checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE");
        return n == 0;
    }
}

