/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.zzl;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class zzn
extends zzy {
    private static final X500Principal zzaMG = new X500Principal("CN=Android Debug,O=Android,C=US");
    private String zzaLl;
    private String zzPa;
    private String zzaMH;
    private String zzOZ;
    private long zzaMI;
    private String zzaLL;

    zzn(zzv zzv2) {
        super(zzv2);
    }

    @Override
    protected void zzhR() {
        String string2;
        String string3 = "Unknown";
        String string4 = "Unknown";
        PackageManager packageManager = this.getContext().getPackageManager();
        String string5 = packageManager.getInstallerPackageName(string2 = this.getContext().getPackageName());
        if (string5 == null) {
            string5 = "manual_install";
        } else if ("com.android.vending".equals(string5)) {
            string5 = "";
        }
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
            if (packageInfo != null) {
                CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                    string4 = charSequence.toString();
                }
                string3 = packageInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzyd().zzzK().zzj("Error retrieving package info: appName", string4);
        }
        this.zzaLl = string2;
        this.zzaMH = string5;
        this.zzPa = string3;
        this.zzOZ = string4;
        long l2 = 0L;
        try {
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("MD5");
            if (!this.zzzJ()) {
                PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 64);
                if (messageDigest != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                    byte[] byArray = messageDigest.digest(packageInfo.signatures[0].toByteArray());
                    l2 = zzn.zzo(byArray);
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.zzyd().zzzK().zzj("Could not get MD5 instance", noSuchAlgorithmException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzyd().zzzK().zzj("Package name not found", (Object)nameNotFoundException);
        }
        this.zzaMI = l2;
    }

    AppMetadata zzzG() {
        return new AppMetadata(this.zzaLl, this.zzzH(), this.zzPa, this.zzaMH, this.zzzt().zzzb(), this.zzzI());
    }

    String zzzH() {
        block8: {
            this.zziE();
            if (this.zzzt().zzjA()) {
                return "";
            }
            if (this.zzaLL == null) {
                Status status = zzl.zzaK(this.getContext());
                if (status != null && status.isSuccess()) {
                    try {
                        if (zzl.zzzE()) {
                            String string2 = zzl.zzzC();
                            this.zzaLL = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
                            break block8;
                        }
                        this.zzaLL = "";
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.zzaLL = "";
                        this.zzyd().zzzK().zzj("getGoogleAppId or isMeasurementEnabled failed with exception", illegalStateException);
                    }
                } else {
                    this.zzaLL = "";
                    this.zzyd().zzzK().zzj("getGoogleAppId failed with status", status == null ? 0 : status.getStatusCode());
                    if (status != null && status.getStatusMessage() != null) {
                        this.zzyd().zzzP().zzec(status.getStatusMessage());
                    }
                }
            }
        }
        return this.zzaLL;
    }

    long zzzI() {
        this.zziE();
        return this.zzaMI;
    }

    static long zzo(byte[] byArray) {
        zzx.zzw(byArray);
        zzx.zzZ(byArray.length > 0);
        long l2 = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l2 += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l2;
    }

    boolean zzzJ() {
        try {
            PackageInfo packageInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
                return x509Certificate.getSubjectX500Principal().equals(zzaMG);
            }
        }
        catch (CertificateException certificateException) {
            this.zzyd().zzzK().zzj("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzyd().zzzK().zzj("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }
}

