/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.SharedPreferences;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.UUID;

class zzs
extends zzy {
    static final Pair<String, Long> zzaNg = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzPC;
    public final zzb zzaNh = new zzb("health_monitor", this.zzzt().zzkg());
    public final zza zzaNi = new zza("last_upload", 0L);
    public final zza zzaNj = new zza("last_upload_attempt", 0L);
    public final zza zzaNk = new zza("backoff", 0L);
    public final zza zzaNl = new zza("last_delete_stale", 0L);
    private String zzaNm;
    private boolean zzaNn;
    private long zzaNo;

    Pair<String, Boolean> zzzS() {
        this.zzis();
        long l2 = this.zzit().elapsedRealtime();
        if (this.zzaNm != null && l2 < this.zzaNo) {
            return new Pair((Object)this.zzaNm, (Object)this.zzaNn);
        }
        this.zzaNo = l2 + this.zzzt().zzza();
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck(true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo(this.getContext());
            this.zzaNm = info.getId();
            this.zzaNn = info.isLimitAdTrackingEnabled();
        }
        catch (Throwable throwable) {
            this.zzyd().zzzP().zzj("Unable to get advertising id", throwable);
            this.zzaNm = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck(false);
        return new Pair((Object)this.zzaNm, (Object)this.zzaNn);
    }

    String zzzT() {
        String string2 = (String)this.zzzS().first;
        MessageDigest messageDigest = zzs.zzbs("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    static MessageDigest zzbs(String string2) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string2);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    String zzzU() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    zzs(zzv zzv2) {
        super(zzv2);
    }

    @Override
    protected void zzhR() {
        this.zzPC = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
    }

    private SharedPreferences zzzV() {
        this.zzis();
        this.zziE();
        return this.zzPC;
    }

    Boolean zzzW() {
        this.zzis();
        if (!this.zzzV().contains("use_service")) {
            return null;
        }
        return this.zzzV().getBoolean("use_service", false);
    }

    void zzan(boolean bl) {
        this.zzis();
        this.zzyd().zzzQ().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzzV().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    public final class zza {
        private final String zzue;
        private final long zzaNp;
        private boolean zzaNq;
        private long zzavc;

        public zza(String string2, long l2) {
            zzx.zzcr(string2);
            this.zzue = string2;
            this.zzaNp = l2;
        }

        private void zzzX() {
            if (this.zzaNq) {
                return;
            }
            this.zzaNq = true;
            this.zzavc = zzs.this.zzPC.getLong(this.zzue, this.zzaNp);
        }

        public long get() {
            this.zzzX();
            return this.zzavc;
        }

        public void set(long value) {
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            editor.putLong(this.zzue, value);
            editor.apply();
            this.zzavc = value;
        }
    }

    public final class zzb {
        final String zzaNs;
        private final String zzaNt;
        private final String zzaNu;
        private final long zzPG;

        private zzb(String string2, long l2) {
            zzx.zzcr(string2);
            zzx.zzaa(l2 > 0L);
            this.zzaNs = string2 + ":start";
            this.zzaNt = string2 + ":count";
            this.zzaNu = string2 + ":value";
            this.zzPG = l2;
        }

        private void zzkU() {
            zzs.this.zzis();
            long l2 = zzs.this.zzit().currentTimeMillis();
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            editor.remove(this.zzaNt);
            editor.remove(this.zzaNu);
            editor.putLong(this.zzaNs, l2);
            editor.apply();
        }

        private long zzkV() {
            zzs.this.zzis();
            long l2 = this.zzkX();
            if (l2 == 0L) {
                this.zzkU();
                return 0L;
            }
            return Math.abs(l2 - zzs.this.zzit().currentTimeMillis());
        }

        public void zzbn(String string2) {
            long l2;
            zzs.this.zzis();
            long l3 = this.zzkX();
            if (l3 == 0L) {
                this.zzkU();
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((l2 = zzs.this.zzPC.getLong(this.zzaNt, 0L)) <= 0L) {
                SharedPreferences.Editor editor = zzs.this.zzPC.edit();
                editor.putString(this.zzaNu, string2);
                editor.putLong(this.zzaNt, 1L);
                editor.apply();
                return;
            }
            UUID uUID = UUID.randomUUID();
            long l4 = uUID.getLeastSignificantBits() & Long.MAX_VALUE;
            boolean bl = l4 < Long.MAX_VALUE / (l2 + 1L);
            SharedPreferences.Editor editor = zzs.this.zzPC.edit();
            if (bl) {
                editor.putString(this.zzaNu, string2);
            }
            editor.putLong(this.zzaNt, l2 + 1L);
            editor.apply();
        }

        public Pair<String, Long> zzkW() {
            zzs.this.zzis();
            long l2 = this.zzkV();
            if (l2 < this.zzPG) {
                return null;
            }
            if (l2 > this.zzPG * 2L) {
                this.zzkU();
                return null;
            }
            String string2 = zzs.this.zzzV().getString(this.zzaNu, null);
            long l3 = zzs.this.zzzV().getLong(this.zzaNt, 0L);
            this.zzkU();
            if (string2 == null || l3 <= 0L) {
                return zzaNg;
            }
            return new Pair((Object)string2, (Object)l3);
        }

        private long zzkX() {
            return zzs.this.zzzV().getLong(this.zzaNs, 0L);
        }
    }
}

