/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzy;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class zzu
extends zzy {
    private final zzc zzaND = new zzc("Measurement Worker");
    private final zzc zzaNE = new zzc("Measurement Network");
    private final zzt zzaNF;
    private volatile boolean zzaNG;
    private volatile boolean zzLA;

    zzu(zzv zzv2) {
        super(zzv2);
        this.zzaND.setUncaughtExceptionHandler(new zzb("Thread death: Uncaught exception on worker thread"));
        this.zzaNE.setUncaughtExceptionHandler(new zzb("Thread death: Uncaught exception on network thread"));
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(this.zzaND.getId());
        hashSet.add(this.zzaNE.getId());
        this.zzaNF = new zzt(hashSet);
    }

    @Override
    protected void zzhR() {
        this.zzaND.start();
        this.zzaNE.start();
    }

    @Override
    public void zzis() {
        if (Thread.currentThread() != this.zzaND) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public void zzzn() {
        if (Thread.currentThread() != this.zzaNE) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public void zzh(Runnable runnable) throws IllegalStateException {
        this.zza(runnable, this.zzaND, "Task exception on worker thread");
    }

    public void zzi(Runnable runnable) throws IllegalStateException {
        this.zza(runnable, this.zzaNE, "Task exception on network thread");
    }

    private void zza(Runnable runnable, zzc zzc2, String string2) throws IllegalStateException {
        this.zziE();
        zzx.zzw(runnable);
        zzc2.zza(new zza(runnable, string2));
    }

    private final class zzb
    implements Thread.UncaughtExceptionHandler {
        private final String zzaNH;

        public zzb(String string2) {
            zzx.zzw(string2);
            this.zzaNH = string2;
        }

        @Override
        public synchronized void uncaughtException(Thread thread, Throwable error) {
            zzu.this.zzyd().zzzK().zzj(this.zzaNH, error);
        }
    }

    private final class zza<V>
    extends FutureTask<V> {
        private final String zzaNH;

        zza(Runnable runnable, String string2) {
            super(runnable, null);
            zzx.zzw(string2);
            this.zzaNH = string2;
        }

        @Override
        protected void setException(Throwable error) {
            zzu.this.zzyd().zzzK().zzj(this.zzaNH, error);
            super.setException(error);
        }
    }

    private final class zzc
    extends Thread {
        private final BlockingQueue<FutureTask<?>> zzaNJ;

        public zzc(String string2) {
            zzx.zzw(string2);
            this.zzaNJ = new LinkedBlockingQueue();
            this.setName(string2);
        }

        public void zza(FutureTask<?> futureTask) throws IllegalStateException {
            zzx.zzw(futureTask);
            if (zzu.this.zzLA) {
                throw new IllegalStateException("Cannot schedule task; thread was already shut down.");
            }
            try {
                this.zzaNJ.put(futureTask);
                zzu.this.zzaNF.zzb(this);
            }
            catch (InterruptedException interruptedException) {
                this.zza(interruptedException);
            }
        }

        @Override
        public void run() {
            boolean bl = false;
            while (!zzu.this.zzaNG || !bl) {
                try {
                    FutureTask<?> futureTask;
                    while ((futureTask = this.zzaNJ.poll(0L, TimeUnit.MICROSECONDS)) != null) {
                        futureTask.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
                try {
                    bl = zzu.this.zzaNF.zzzY();
                }
                catch (InterruptedException interruptedException) {
                    this.zza(interruptedException);
                }
            }
            zzu.this.zzyd().zzzP().zzec("Scheduler thread exiting");
        }

        private void zza(InterruptedException interruptedException) {
            zzu.this.zzyd().zzzL().zzj(this.getName() + " was interrupted", interruptedException);
        }
    }
}

