/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.measurement.AppMeasurementReceiver;
import com.google.android.gms.measurement.AppMeasurementService;
import com.google.android.gms.measurement.internal.AppMetadata;
import com.google.android.gms.measurement.internal.EventParams;
import com.google.android.gms.measurement.internal.EventParcel;
import com.google.android.gms.measurement.internal.UserAttributeParcel;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzu;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import com.google.android.gms.measurement.internal.zzz;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class zzv {
    private static zzz zzaNK;
    private static volatile zzv zzaNL;
    private final Context mContext;
    private final zzc zzaNM;
    private final zzs zzaNN;
    private final zzp zzaNO;
    private final zzu zzaNP;
    private final com.google.android.gms.measurement.zza zzaNQ;
    private final zzag zzaNR;
    private final zzd zzaNS;
    private final zzq zzaNT;
    private final zzmn zzpW;
    private final zzab zzaNU;
    private final zzf zzaNV;
    private final zzaa zzaNW;
    private final zzn zzaNX;
    private final zzr zzaNY;
    private final zzad zzaNZ;
    private final boolean zzMF;
    private Boolean zzaOa;
    private List<Long> zzaOb;
    private int zzaOc;
    private int zzaOd;

    zzv(zzz zzz2) {
        com.google.android.gms.common.internal.zzx.zzw(zzz2);
        this.mContext = zzz2.mContext;
        this.zzpW = zzz2.zzj(this);
        this.zzaNM = zzz2.zza(this);
        zzs zzs2 = zzz2.zzb(this);
        zzs2.zza();
        this.zzaNN = zzs2;
        zzp zzp2 = zzz2.zzc(this);
        zzp2.zza();
        this.zzaNO = zzp2;
        this.zzaNR = zzz2.zzg(this);
        zzf zzf2 = zzz2.zzl(this);
        zzf2.zza();
        this.zzaNV = zzf2;
        zzn zzn2 = zzz2.zzm(this);
        zzn2.zza();
        this.zzaNX = zzn2;
        zzd zzd2 = zzz2.zzh(this);
        zzd2.zza();
        this.zzaNS = zzd2;
        zzq zzq2 = zzz2.zzi(this);
        zzq2.zza();
        this.zzaNT = zzq2;
        zzab zzab2 = zzz2.zzk(this);
        zzab2.zza();
        this.zzaNU = zzab2;
        zzaa zzaa2 = zzz2.zzf(this);
        zzaa2.zza();
        this.zzaNW = zzaa2;
        zzad zzad2 = zzz2.zzo(this);
        zzad2.zza();
        this.zzaNZ = zzad2;
        this.zzaNY = zzz2.zzn(this);
        this.zzaNQ = zzz2.zze(this);
        zzu zzu2 = zzz2.zzd(this);
        zzu2.zza();
        this.zzaNP = zzu2;
        if (this.zzaOc != this.zzaOd) {
            this.zzyd().zzzK().zze("Not all components initialized", this.zzaOc, this.zzaOd);
        }
        this.zzMF = true;
        this.zzaNP.zzh(new Runnable(){

            @Override
            public void run() {
                zzv.this.start();
            }
        });
    }

    void zziE() {
        if (!this.zzMF) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    protected boolean zzAa() {
        this.zziE();
        this.zzis();
        if (this.zzaOa == null) {
            this.zzaOa = this.zzzq().zzbh("android.permission.INTERNET") && this.zzzq().zzbh("android.permission.ACCESS_NETWORK_STATE") && AppMeasurementReceiver.zzV(this.getContext()) && AppMeasurementService.zzW(this.getContext());
            if (this.zzaOa.booleanValue() && !this.zzzt().zzjA()) {
                this.zzaOa = !TextUtils.isEmpty((CharSequence)this.zzzo().zzzH());
            }
        }
        return this.zzaOa;
    }

    protected void start() {
        this.zzis();
        this.zzyd().zzzO().zzec("App measurement is starting up");
        this.zzyd().zzzP().zzec("Debug logging enabled");
        if (!this.zzAa()) {
            if (!this.zzzq().zzbh("android.permission.INTERNET")) {
                this.zzyd().zzzK().zzec("App is missing INTERNET permission");
            }
            if (!this.zzzq().zzbh("android.permission.ACCESS_NETWORK_STATE")) {
                this.zzyd().zzzK().zzec("App is missing ACCESS_NETWORK_STATE permission");
            }
            if (!AppMeasurementReceiver.zzV(this.getContext())) {
                this.zzyd().zzzK().zzec("AppMeasurementReceiver not registered/enabled");
            }
            if (!AppMeasurementService.zzW(this.getContext())) {
                this.zzyd().zzzK().zzec("AppMeasurementService not registered/enabled");
            }
            this.zzyd().zzzK().zzec("Uploading is not possible. App measurement disabled");
        } else if (!this.zzzt().zzjA() && !TextUtils.isEmpty((CharSequence)this.zzzo().zzzH())) {
            this.zzAc().zzAr();
        }
        this.zzAm();
    }

    public zzc zzzt() {
        return this.zzaNM;
    }

    public zzs zzzs() {
        this.zza((zzx)this.zzaNN);
        return this.zzaNN;
    }

    public zzp zzyd() {
        this.zza(this.zzaNO);
        return this.zzaNO;
    }

    public zzu zzzr() {
        this.zza(this.zzaNP);
        return this.zzaNP;
    }

    zzu zzAb() {
        return this.zzaNP;
    }

    public zzaa zzAc() {
        this.zza(this.zzaNW);
        return this.zzaNW;
    }

    public zzag zzzq() {
        this.zza(this.zzaNR);
        return this.zzaNR;
    }

    public zzd zzAd() {
        this.zza(this.zzaNS);
        return this.zzaNS;
    }

    public zzq zzAe() {
        this.zza(this.zzaNT);
        return this.zzaNT;
    }

    public Context getContext() {
        return this.mContext;
    }

    public zzmn zzit() {
        return this.zzpW;
    }

    public zzab zzzp() {
        this.zza(this.zzaNU);
        return this.zzaNU;
    }

    public zzf zzAf() {
        this.zza(this.zzaNV);
        return this.zzaNV;
    }

    public zzn zzzo() {
        this.zza(this.zzaNX);
        return this.zzaNX;
    }

    public zzr zzAg() {
        if (this.zzaNY == null) {
            throw new IllegalStateException("Network broadcast receiver not created");
        }
        return this.zzaNY;
    }

    public zzad zzAh() {
        this.zza(this.zzaNZ);
        return this.zzaNZ;
    }

    public void zzis() {
        this.zzzr().zzis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzv zzaL(Context context) {
        com.google.android.gms.common.internal.zzx.zzw(context);
        com.google.android.gms.common.internal.zzx.zzw(context.getApplicationContext());
        if (zzaNL != null) return zzaNL;
        Class<zzv> clazz = zzv.class;
        synchronized (zzv.class) {
            if (zzaNL != null) return zzaNL;
            zzz zzz2 = zzaNK != null ? zzaNK : new zzz(context);
            zzaNL = zzz2.zzAq();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaNL;
        }
    }

    private void zza(zzy zzy2) {
        if (zzy2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzy2.isInitialized()) {
            throw new IllegalStateException("Component not initialized");
        }
    }

    private void zza(zzx zzx2) {
        if (zzx2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    protected boolean zzAi() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(EventParcel eventParcel, AppMetadata appMetadata) {
        this.zzis();
        this.zziE();
        com.google.android.gms.common.internal.zzx.zzcr(appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaLP)) {
            return;
        }
        this.zzyd().zzzQ().zzj("Logging event", eventParcel);
        zzg zzg2 = new zzg(this, eventParcel.zzaMl, appMetadata.packageName, eventParcel.name, eventParcel.zzaMm, 0L, eventParcel.zzaMk.zzzB());
        this.zzAd().beginTransaction();
        try {
            zzh zzh2;
            this.zzc(appMetadata);
            zzh zzh3 = this.zzAd().zzH(appMetadata.packageName, zzg2.mName);
            if (zzh3 == null) {
                zzh2 = new zzh(appMetadata.packageName, zzg2.mName, 1L, 1L, zzg2.zzZH);
            } else {
                zzg2 = zzg2.zza(this, zzh3.zzaMg);
                zzh2 = zzh3.zzO(zzg2.zzZH);
            }
            this.zzAd().zza(zzh2);
            zzpk.zzd zzd2 = this.zza(new zzg[]{zzg2}, appMetadata);
            this.zzAd().zza(zzd2);
            this.zzAd().setTransactionSuccessful();
            this.zzyd().zzzP().zzj("Event logged", zzg2);
        }
        finally {
            this.zzAd().endTransaction();
        }
        this.zzAm();
    }

    void zzir() {
        if (this.zzzt().zzjA()) {
            throw new IllegalStateException("Unexpected call on package side");
        }
    }

    zzpk.zzd zza(zzg[] zzgArray, AppMetadata appMetadata) {
        zzse zzse2;
        int n;
        com.google.android.gms.common.internal.zzx.zzw(appMetadata);
        com.google.android.gms.common.internal.zzx.zzw(zzgArray);
        this.zzis();
        zzpk.zzd zzd2 = new zzpk.zzd();
        zzd2.zzaOK = 1;
        zzd2.zzaOS = "android";
        zzd2.zzaOX = appMetadata.packageName;
        zzd2.zzaLQ = appMetadata.zzaLQ;
        zzd2.zzaDC = appMetadata.zzaDC;
        zzd2.zzaOY = appMetadata.zzaLR;
        zzd2.zzaLP = appMetadata.zzaLP;
        zzd2.zzaPd = appMetadata.zzaLS == 0L ? null : Long.valueOf(appMetadata.zzaLS);
        Pair<String, Boolean> pair = this.zzzs().zzzS();
        if (pair != null && pair.first != null && pair.second != null) {
            zzd2.zzaPa = (String)pair.first;
            zzd2.zzaPb = (Boolean)pair.second;
        }
        zzd2.zzaOU = this.zzAf().zzgE();
        zzd2.zzaOT = this.zzAf().zzzy();
        zzd2.zzaOW = (int)this.zzAf().zzzz();
        zzd2.zzaOV = this.zzAf().zzzA();
        zzd2.zzaOZ = null;
        zzd2.zzaON = null;
        zzd2.zzaOO = zzgArray[0].zzZH;
        zzd2.zzaOP = zzgArray[0].zzZH;
        for (int i = 1; i < zzgArray.length; ++i) {
            zzd2.zzaOO = Math.min(zzd2.zzaOO, zzgArray[i].zzZH);
            zzd2.zzaOP = Math.max(zzd2.zzaOP, zzgArray[i].zzZH);
        }
        zza zza2 = this.zzAd().zzea(appMetadata.packageName);
        if (zza2 == null) {
            zza2 = new zza(appMetadata.packageName, this.zzzs().zzzU(), appMetadata.zzaLP, this.zzzs().zzzT(), 0L, 0L);
        }
        zza zza3 = zza2.zza(this.zzyd(), zzd2.zzaOP);
        this.zzAd().zza(zza3);
        zzd2.zzaPc = zza3.zzaLK;
        zzd2.zzaPe = (int)zza3.zzaLN;
        zzd2.zzaOQ = zzd2.zzaOR = zza2.zzaLO == 0L ? null : Long.valueOf(zza2.zzaLO);
        List<zzae> list = this.zzAd().zzdZ(appMetadata.packageName);
        zzd2.zzaOM = new zzpk.zze[list.size()];
        for (n = 0; n < list.size(); ++n) {
            zzd2.zzaOM[n] = zzse2 = new zzpk.zze();
            zzse2.name = list.get((int)n).mName;
            zzse2.zzaPi = list.get((int)n).zzaOy;
            this.zzzq().zza((zzpk.zze)zzse2, list.get((int)n).zzJy);
        }
        zzd2.zzaOL = new zzpk.zza[zzgArray.length];
        for (n = 0; n < zzgArray.length; ++n) {
            zzse2 = new zzpk.zza();
            zzd2.zzaOL[n] = zzse2;
            ((zzpk.zza)zzse2).name = zzgArray[n].mName;
            ((zzpk.zza)zzse2).zzaOE = zzgArray[n].zzZH;
            ((zzpk.zza)zzse2).zzaOD = new zzpk.zzb[zzgArray[n].zzaMd.size()];
            int n2 = 0;
            for (String string2 : zzgArray[n].zzaMd) {
                zzpk.zzb zzb2 = new zzpk.zzb();
                ((zzpk.zza)zzse2).zzaOD[n2++] = zzb2;
                zzb2.name = string2;
                Object object = zzgArray[n].zzaMd.get(string2);
                this.zzzq().zza(zzb2, object);
            }
        }
        zzd2.zzaPf = this.zzyd().zzzR();
        return zzd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzis();
        this.zziE();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaLP)) {
            return;
        }
        this.zzzq().zzef(userAttributeParcel.name);
        Object object = this.zzzq().zzD(userAttributeParcel.getValue());
        if (object == null) {
            return;
        }
        zzae zzae2 = new zzae(appMetadata.packageName, userAttributeParcel.name, userAttributeParcel.zzaOz, object);
        this.zzyd().zzzP().zze("Setting user attribute", zzae2.mName, object);
        this.zzAd().beginTransaction();
        try {
            this.zzc(appMetadata);
            this.zzAd().zza(zzae2);
            this.zzAd().setTransactionSuccessful();
            this.zzyd().zzzP().zze("User attribute set", zzae2.mName, zzae2.zzJy);
        }
        finally {
            this.zzAd().endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzc(UserAttributeParcel userAttributeParcel, AppMetadata appMetadata) {
        this.zzis();
        this.zziE();
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaLP)) {
            return;
        }
        this.zzyd().zzzP().zzj("Removing user attribute", userAttributeParcel.name);
        this.zzAd().beginTransaction();
        try {
            this.zzc(appMetadata);
            this.zzAd().zzI(appMetadata.packageName, userAttributeParcel.name);
            this.zzAd().setTransactionSuccessful();
            this.zzyd().zzzP().zzj("User attribute removed", userAttributeParcel.name);
        }
        finally {
            this.zzAd().endTransaction();
        }
    }

    private boolean zzAj() {
        this.zzis();
        return this.zzaOb != null;
    }

    private void zzv(List<Long> list) {
        com.google.android.gms.common.internal.zzx.zzaa(!list.isEmpty());
        if (this.zzaOb != null) {
            this.zzyd().zzzK().zzec("Set uploading progress before finishing the previous upload");
        } else {
            this.zzaOb = new ArrayList<Long>(list);
        }
    }

    public void zzAk() {
        String string2;
        this.zzis();
        this.zziE();
        if (!this.zzzt().zzjA()) {
            Boolean bl = this.zzzs().zzzW();
            if (bl == null) {
                this.zzyd().zzzL().zzec("Upload data called on the client side before use of service was decided");
                return;
            }
            if (bl.booleanValue()) {
                this.zzyd().zzzK().zzec("Upload called in the client side when service should be used");
                return;
            }
        }
        if (this.zzAj()) {
            this.zzyd().zzzL().zzec("Uploading requested multiple times");
            return;
        }
        if (!this.zzAe().zzkK()) {
            this.zzyd().zzzL().zzec("Network not connected, ignoring upload request");
            this.zzAm();
            return;
        }
        long l2 = -1L;
        long l3 = this.zzzs().zzaNi.get();
        if (l3 != 0L) {
            l2 = Math.abs(this.zzit().currentTimeMillis() - l3);
            this.zzyd().zzzP().zzj("Uploading events. Elapsed time since last upload attempt (ms)", l2);
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = this.zzAd().zzzu()))) {
            int n = this.zzzt().zzzf();
            int n2 = this.zzzt().zzzg();
            List<Pair<zzpk.zzd, Long>> list = this.zzAd().zzn(string2, n, n2);
            if (!list.isEmpty()) {
                String string3 = null;
                for (Pair<zzpk.zzd, Long> object2 : list) {
                    zzpk.zzd zzd2 = (zzpk.zzd)object2.first;
                    if (TextUtils.isEmpty((CharSequence)zzd2.zzaPa)) continue;
                    string3 = zzd2.zzaPa;
                    break;
                }
                if (string3 != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        zzpk.zzd zzd3 = (zzpk.zzd)list.get((int)i).first;
                        if (TextUtils.isEmpty((CharSequence)zzd3.zzaPa) || zzd3.zzaPa.equals(string3)) continue;
                        list = list.subList(0, i);
                        break;
                    }
                }
                zzpk.zzc zzc2 = new zzpk.zzc();
                zzc2.zzaOI = new zzpk.zzd[list.size()];
                ArrayList<Long> arrayList = new ArrayList<Long>(list.size());
                long l4 = this.zzit().currentTimeMillis();
                for (int i = 0; i < zzc2.zzaOI.length; ++i) {
                    zzc2.zzaOI[i] = (zzpk.zzd)list.get((int)i).first;
                    arrayList.add((Long)list.get((int)i).second);
                    zzc2.zzaOI[i].zzaOZ = this.zzzt().zzzb();
                    zzc2.zzaOI[i].zzaON = l4;
                    zzc2.zzaOI[i].zzaPg = this.zzzt().zzjA();
                }
                byte[] byArray = this.zzzq().zza(zzc2);
                String string4 = this.zzzt().zzzh();
                try {
                    URL uRL = new URL(string4);
                    this.zzv(arrayList);
                    this.zzzs().zzaNj.set(this.zzit().currentTimeMillis());
                    this.zzAe().zza(uRL, byArray, new zzq.zza(){

                        @Override
                        public void zza(int n, Throwable throwable, byte[] byArray) {
                            zzv.this.zzb(n, throwable, byArray);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {
                    this.zzyd().zzzK().zzj("Failed to parse upload URL. Not uploading", string4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, Throwable throwable, byte[] byArray) {
        this.zzis();
        this.zziE();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        List<Long> list = this.zzaOb;
        this.zzaOb = null;
        if ((n == 200 || n == 204) && throwable == null) {
            this.zzzs().zzaNi.set(this.zzit().currentTimeMillis());
            this.zzzs().zzaNj.set(0L);
            this.zzAm();
            this.zzyd().zzzQ().zze("Successful upload. Got network response. code, size", n, byArray.length);
            this.zzAd().beginTransaction();
            try {
                for (Long l2 : list) {
                    this.zzAd().zzN(l2);
                }
                this.zzAd().setTransactionSuccessful();
            }
            finally {
                this.zzAd().endTransaction();
            }
            if (this.zzAe().zzkK() && this.zzAl()) {
                this.zzAk();
            } else {
                this.zzAm();
            }
        } else {
            boolean bl;
            this.zzyd().zzzQ().zze("Network upload failed. Will retry later. code, error", n, throwable);
            this.zzzs().zzaNj.set(this.zzit().currentTimeMillis());
            boolean bl2 = bl = n == 503;
            if (bl) {
                this.zzzs().zzaNk.set(this.zzit().currentTimeMillis());
            }
            this.zzAm();
        }
    }

    private boolean zzAl() {
        return !TextUtils.isEmpty((CharSequence)this.zzAd().zzzu());
    }

    private void zzAm() {
        this.zzis();
        this.zziE();
        if (!this.zzAa() || !this.zzAl()) {
            this.zzAg().unregister();
            this.zzAh().cancel();
            return;
        }
        long l2 = this.zzAn();
        if (l2 == 0L) {
            this.zzAg().unregister();
            this.zzAh().cancel();
            return;
        }
        if (!this.zzAe().zzkK()) {
            this.zzAg().zzkH();
            this.zzAh().cancel();
            return;
        }
        long l3 = this.zzzs().zzaNk.get();
        long l4 = this.zzzt().zzzi();
        if (!this.zzzq().zzc(l3, l4)) {
            l2 = Math.max(l2, l3 + l4);
        }
        this.zzAg().unregister();
        long l5 = l2 - this.zzit().currentTimeMillis();
        if (l5 <= 0L) {
            this.zzAh().zzt(1L);
        } else {
            this.zzyd().zzzQ().zzj("Upload scheduled in approximately ms", l5);
            this.zzAh().zzt(l5);
        }
    }

    private long zzAn() {
        long l2 = this.zzit().currentTimeMillis();
        long l3 = this.zzzt().zzzk();
        long l4 = this.zzzt().zzzj();
        long l5 = this.zzzs().zzaNi.get();
        long l6 = this.zzzs().zzaNj.get();
        long l7 = this.zzAd().zzzx();
        if (l7 == 0L) {
            return 0L;
        }
        l7 = l2 - Math.abs(l7 - l2);
        long l8 = l7 + l3;
        if (!this.zzzq().zzc(l5, l4)) {
            l8 = l5 + l4;
        }
        if (l6 != 0L && l6 >= l7) {
            long l9 = l8;
            for (int i = 0; i < this.zzzt().zzzm(); ++i) {
                long l10 = 1 << i;
                if ((l9 += this.zzzt().zzzl() * l10) <= l6) continue;
                return l9;
            }
            return 0L;
        }
        return l8;
    }

    public void zzI(boolean bl) {
        this.zzAm();
    }

    void zzb(zzy zzy2) {
        ++this.zzaOc;
    }

    void zzAo() {
        ++this.zzaOd;
    }

    public void zzb(AppMetadata appMetadata) {
        this.zzis();
        this.zziE();
        com.google.android.gms.common.internal.zzx.zzw(appMetadata);
        com.google.android.gms.common.internal.zzx.zzcr(appMetadata.packageName);
        if (TextUtils.isEmpty((CharSequence)appMetadata.zzaLP)) {
            return;
        }
        this.zzc(appMetadata);
        zzh zzh2 = this.zzAd().zzH(appMetadata.packageName, "_f");
        if (zzh2 == null) {
            long l2 = this.zzit().currentTimeMillis();
            long l3 = (1L + l2 / 3600000L) * 3600000L;
            UserAttributeParcel userAttributeParcel = new UserAttributeParcel("_fot", l2, l3, "auto");
            this.zzb(userAttributeParcel, appMetadata);
            Bundle bundle = new Bundle();
            bundle.putLong("_c", 1L);
            EventParcel eventParcel = new EventParcel("_f", new EventParams(bundle), "auto", l2);
            this.zzb(eventParcel, appMetadata);
            this.zzAm();
        }
    }

    private void zzc(AppMetadata appMetadata) {
        this.zzis();
        this.zziE();
        com.google.android.gms.common.internal.zzx.zzw(appMetadata);
        com.google.android.gms.common.internal.zzx.zzcr(appMetadata.packageName);
        zza zza2 = this.zzAd().zzea(appMetadata.packageName);
        String string2 = this.zzzs().zzzT();
        boolean bl = false;
        if (zza2 == null) {
            zza2 = new zza(appMetadata.packageName, this.zzzs().zzzU(), appMetadata.zzaLP, string2, 0L, 0L);
            bl = true;
        } else if (!string2.equals(zza2.zzaLM)) {
            zza2 = zza2.zzG(this.zzzs().zzzU(), string2);
            bl = true;
        }
        if (!TextUtils.isEmpty((CharSequence)appMetadata.zzaLP) && !appMetadata.zzaLP.equals(zza2.zzaLL)) {
            zza2 = zza2.zzdY(appMetadata.zzaLP);
            bl = true;
        }
        if (bl) {
            this.zzAd().zza(zza2);
        }
    }
}

