/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.measurement.zzf;
import com.google.android.gms.measurement.zzh;
import com.google.android.gms.measurement.zzi;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzg {
    private static volatile zzg zzaLc;
    private final Context mContext;
    private final List<zzh> zzaLd;
    private final com.google.android.gms.measurement.zzb zzaLe;
    private final zza zzaLf;
    private volatile zzpb zzNs;
    private Thread.UncaughtExceptionHandler zzaLg;

    zzg(Context context) {
        Context context2 = context.getApplicationContext();
        zzx.zzw(context2);
        this.mContext = context2;
        this.zzaLf = new zza();
        this.zzaLd = new CopyOnWriteArrayList<zzh>();
        this.zzaLe = new com.google.android.gms.measurement.zzb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzg zzaJ(Context context) {
        zzx.zzw(context);
        if (zzaLc != null) return zzaLc;
        Class<zzg> clazz = zzg.class;
        synchronized (zzg.class) {
            if (zzaLc != null) return zzaLc;
            zzaLc = new zzg(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaLc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzpb zzyr() {
        if (this.zzNs == null) {
            zzg zzg2 = this;
            synchronized (zzg2) {
                if (this.zzNs == null) {
                    zzpb zzpb2 = new zzpb();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string2 = this.mContext.getPackageName();
                    zzpb2.setAppId(string2);
                    zzpb2.setAppInstallerId(packageManager.getInstallerPackageName(string2));
                    String string3 = string2;
                    String string4 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string3 = charSequence.toString();
                            }
                            string4 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string3));
                    }
                    zzpb2.setAppName(string3);
                    zzpb2.setAppVersion(string4);
                    this.zzNs = zzpb2;
                }
            }
        }
        return this.zzNs;
    }

    public zzpd zzys() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzpd zzpd2 = new zzpd();
        zzpd2.setLanguage(zzam.zza(Locale.getDefault()));
        zzpd2.zzhX(displayMetrics.widthPixels);
        zzpd2.zzhY(displayMetrics.heightPixels);
        return zzpd2;
    }

    void zze(com.google.android.gms.measurement.zzc zzc2) {
        if (zzc2.zzyn()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzc2.zzyj()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final com.google.android.gms.measurement.zzc zzc3 = zzc2.zzye();
        zzc3.zzyk();
        this.zzaLf.execute(new Runnable(){

            @Override
            public void run() {
                zzf zzf2 = zzc3.zzyl();
                zzf2.zza(zzc3);
                for (zzh zzh2 : zzg.this.zzaLd) {
                    zzh2.zza(zzc3);
                }
                zzg.this.zzb(zzc3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzis() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaLg = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzb(Callable<V> callable) {
        zzx.zzw(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaLf.submit(callable);
    }

    public void zzg(Runnable runnable) {
        zzx.zzw(runnable);
        this.zzaLf.submit(runnable);
    }

    private void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzcj("deliver should be called from worker thread");
        zzx.zzb(zzc2.zzyj(), (Object)"Measurement must be submitted");
        List<zzi> list = zzc2.zzyg();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzi zzi2 : list) {
            Uri uri = zzi2.zzhI();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzi2.zzb(zzc2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaLk = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string2 = "measurement-" + zzaLk.incrementAndGet();
            return new zzc(target, string2);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string2) {
            super(runnable, string2);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzg.this.zzaLg;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

