/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.devices.NearbyDevice;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
implements SafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    private static final NearbyDevice[] zzaPY = new NearbyDevice[]{NearbyDevice.zzaQz};
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzagM;
    private final NearbyDevice[] zzaPZ;

    Message(int versionCode, byte[] content, String namespace, String type, NearbyDevice[] devices) {
        this.versionCode = versionCode;
        this.type = zzx.zzw(type);
        String string2 = this.zzagM = namespace == null ? "" : namespace;
        if (Message.zzK(this.zzagM, this.type)) {
            zzx.zzb(content == null, (Object)"Content must be null for a device presence message.");
        } else {
            zzx.zzw(content);
            zzx.zzb(content.length <= 102400, "Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", content.length, 102400);
        }
        this.content = content;
        if (devices == null || devices.length == 0) {
            devices = zzaPY;
        }
        this.zzaPZ = devices;
        zzx.zzb(type.length() <= 32, "Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", type.length(), 32);
    }

    public static boolean zzK(String string2, String string3) {
        return string2.equals("__reserved_namespace") && string3.equals("__device_presence");
    }

    public Message(byte[] content) {
        this(content, "", "");
    }

    public Message(byte[] content, String type) {
        this(content, "", type);
    }

    Message(byte[] content, String namespace, String type) {
        this(content, namespace, type, zzaPY);
    }

    Message(byte[] content, String namespace, String type, NearbyDevice[] devices) {
        this(2, content, namespace, type, devices);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzagM;
    }

    public byte[] getContent() {
        return this.content;
    }

    public NearbyDevice[] zzAS() {
        return this.zzaPZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzagM, this.type, Arrays.hashCode(this.content));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        return TextUtils.equals((CharSequence)this.zzagM, (CharSequence)message.zzagM) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content);
    }

    public String toString() {
        return "Message{namespace='" + this.zzagM + "'" + ", type='" + this.type + "'" + ", content=[" + (this.content == null ? 0 : this.content.length) + " bytes]" + ", devices=" + Arrays.toString(this.zzAS()) + "}";
    }
}

