/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.devices.NearbyDeviceFilter;
import com.google.android.gms.nearby.messages.internal.MessageType;
import com.google.android.gms.nearby.messages.zzb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageFilter
implements SafeParcelable {
    public static final Parcelable.Creator<MessageFilter> CREATOR = new zzb();
    public static final MessageFilter INCLUDE_ALL_MY_TYPES = new Builder().includeAllMyTypes().build();
    final int mVersionCode;
    private final List<MessageType> zzaQa;
    private final List<NearbyDeviceFilter> zzaQb;
    private final boolean zzaQc;

    MessageFilter(int versionCode, List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this.mVersionCode = versionCode;
        this.zzaQa = Collections.unmodifiableList(zzx.zzw(messageTypes));
        this.zzaQc = includeAllMyTypes;
        if (deviceFilters == null) {
            deviceFilters = Collections.emptyList();
        }
        this.zzaQb = Collections.unmodifiableList(deviceFilters);
    }

    private MessageFilter(List<MessageType> messageTypes, List<NearbyDeviceFilter> deviceFilters, boolean includeAllMyTypes) {
        this(1, messageTypes, deviceFilters, includeAllMyTypes);
    }

    List<MessageType> zzAT() {
        return this.zzaQa;
    }

    boolean zzAU() {
        return this.zzaQc;
    }

    List<NearbyDeviceFilter> zzAV() {
        return this.zzaQb;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public String toString() {
        return "MessageFilter{includeAllMyTypes=" + this.zzaQc + ", messageTypes=" + this.zzaQa + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageFilter)) {
            return false;
        }
        MessageFilter messageFilter = (MessageFilter)o;
        return this.zzaQc == messageFilter.zzaQc && zzw.equal(this.zzaQa, messageFilter.zzaQa) && zzw.equal(this.zzaQb, messageFilter.zzaQb);
    }

    public int hashCode() {
        return zzw.hashCode(this.zzaQa, this.zzaQb, this.zzaQc);
    }

    public static final class Builder {
        private final List<MessageType> zzaQd = new ArrayList<MessageType>();
        private final List<NearbyDeviceFilter> zzaQb = new ArrayList<NearbyDeviceFilter>();
        private boolean zzaQc;

        public Builder includeAllMyTypes() {
            this.zzaQc = true;
            return this;
        }

        public Builder includeNamespacedType(String namespace, String type) {
            return this.zzL(namespace, type);
        }

        public Builder includeFilter(MessageFilter filter) {
            this.zzaQd.addAll(filter.zzAT());
            this.zzaQb.addAll(filter.zzAV());
            this.zzaQc |= filter.zzAU();
            return this;
        }

        private Builder zzL(String string2, String string3) {
            this.zzaQd.add(new MessageType(string2, string3));
            return this;
        }

        public MessageFilter build() {
            zzx.zza(this.zzaQc || !this.zzaQd.isEmpty(), (Object)"At least one of the include methods must be called.");
            return new MessageFilter(this.zzaQd, this.zzaQb, this.zzaQc);
        }
    }
}

