/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.zzd;

public class Strategy
implements SafeParcelable {
    public static final Parcelable.Creator<Strategy> CREATOR = new zzd();
    public static final int DISCOVERY_MODE_BROADCAST = 1;
    public static final int DISCOVERY_MODE_SCAN = 2;
    public static final int DISCOVERY_MODE_DEFAULT = 3;
    public static final int DISTANCE_TYPE_DEFAULT = 0;
    public static final int DISTANCE_TYPE_EARSHOT = 1;
    public static final int TTL_SECONDS_DEFAULT = 300;
    public static final int TTL_SECONDS_MAX = 86400;
    public static final int TTL_SECONDS_INFINITE = Integer.MAX_VALUE;
    public static final Strategy DEFAULT = new Builder().build();
    public static final Strategy BLE_ONLY;
    @Deprecated
    public static final Strategy zzaQi;
    final int mVersionCode;
    @Deprecated
    final int zzaQj;
    final int zzaQk;
    final int zzaQl;
    @Deprecated
    final boolean zzaQm;
    final int zzaQn;
    final int zzaQo;

    Strategy(int versionCode, int broadcastScanStrategy, int ttlSeconds, int distanceType, boolean isBleBeaconStrategy, int discoveryMedium, int discoveryMode) {
        this.mVersionCode = versionCode;
        this.zzaQj = broadcastScanStrategy;
        if (broadcastScanStrategy == 0) {
            this.zzaQo = discoveryMode;
        } else {
            switch (broadcastScanStrategy) {
                case 2: {
                    this.zzaQo = 1;
                    break;
                }
                case 3: {
                    this.zzaQo = 2;
                    break;
                }
                default: {
                    this.zzaQo = 3;
                }
            }
        }
        this.zzaQl = distanceType;
        this.zzaQm = isBleBeaconStrategy;
        if (isBleBeaconStrategy) {
            this.zzaQn = 2;
            this.zzaQk = Integer.MAX_VALUE;
        } else if (discoveryMedium == 0) {
            this.zzaQn = 1;
            this.zzaQk = ttlSeconds;
        } else {
            this.zzaQn = discoveryMedium;
            this.zzaQk = ttlSeconds;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        Strategy strategy = (Strategy)other;
        return this.mVersionCode == strategy.mVersionCode && this.zzaQo == strategy.zzaQo && this.zzaQk == strategy.zzaQk && this.zzaQl == strategy.zzaQl && this.zzaQn == strategy.zzaQn;
    }

    public int hashCode() {
        int n = this.mVersionCode;
        n = 31 * n + this.zzaQo;
        n = 31 * n + this.zzaQk;
        n = 31 * n + this.zzaQl;
        n = 31 * n + this.zzaQn;
        return n;
    }

    static {
        zzaQi = BLE_ONLY = new Builder().zziz(2).setTtlSeconds(Integer.MAX_VALUE).build();
    }

    public static class Builder {
        private int zzaQp = 3;
        private int zzaQq = 300;
        private int zzaQr = 0;
        private int zzaQs = 1;

        public Builder setDiscoveryMode(int discoveryMode) {
            this.zzaQp = discoveryMode;
            return this;
        }

        public Builder zziz(int n) {
            this.zzaQs = n;
            return this;
        }

        public Builder setTtlSeconds(int ttlSeconds) {
            zzx.zzb(ttlSeconds == Integer.MAX_VALUE || ttlSeconds > 0 && ttlSeconds <= 86400, "mTtlSeconds(%d) must either be TTL_SECONDS_INFINITE, or it must be between 1 and TTL_SECONDS_MAX(%d) inclusive", ttlSeconds, 86400);
            this.zzaQq = ttlSeconds;
            return this;
        }

        public Builder setDistanceType(int distanceType) {
            this.zzaQr = distanceType;
            return this;
        }

        public Strategy build() {
            if (this.zzaQs == 2) {
                if (this.zzaQp != 3) {
                    throw new IllegalStateException("Discovery mode must be DISCOVERY_MODE_DEFAULT.");
                }
                if (this.zzaQr == 1) {
                    throw new IllegalStateException("Cannot set EARSHOT with BLE only mode.");
                }
            }
            return new Strategy(2, 0, this.zzaQq, this.zzaQr, false, this.zzaQs, this.zzaQp);
        }
    }
}

