/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.zzbg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] zzaWv = "gtm.lifetime".toString().split("\\.");
    private static final Pattern zzaWw = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<zzb, Integer> zzaWx;
    private final Map<String, Object> zzaWy;
    private final ReentrantLock zzaWz;
    private final LinkedList<Map<String, Object>> zzaWA;
    private final zzc zzaWB;
    private final CountDownLatch zzaWC;

    DataLayer() {
        this(new zzc(){

            @Override
            public void zza(List<zza> list, long l2) {
            }

            @Override
            public void zza(zzc.zza zza2) {
                zza2.zzw(new ArrayList<zza>());
            }

            @Override
            public void zzeK(String string2) {
            }
        });
    }

    DataLayer(zzc persistentStore) {
        this.zzaWB = persistentStore;
        this.zzaWx = new ConcurrentHashMap();
        this.zzaWy = new HashMap<String, Object>();
        this.zzaWz = new ReentrantLock();
        this.zzaWA = new LinkedList();
        this.zzaWC = new CountDownLatch(1);
        this.zzCF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.zzaWy;
        synchronized (map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.zzaWy.entrySet()) {
                stringBuilder.append(String.format("{\n\tKey: %s\n\tValue: %s\n}\n", entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
    }

    public void pushEvent(String eventName, Map<String, Object> update) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(update);
        hashMap.put(EVENT_KEY, eventName);
        this.push(hashMap);
    }

    public void push(String key, Object value) {
        Map<String, Object> map = this.zzk(key, value);
        this.push(map);
    }

    public void push(Map<String, Object> update) {
        try {
            this.zzaWC.await();
        }
        catch (InterruptedException interruptedException) {
            zzbg.zzaH("DataLayer.push: unexpected InterruptedException");
        }
        this.zzL(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzL(Map<String, Object> map) {
        this.zzaWz.lock();
        try {
            this.zzaWA.offer(map);
            if (this.zzaWz.getHoldCount() == 1) {
                this.zzCG();
            }
            this.zzM(map);
        }
        finally {
            this.zzaWz.unlock();
        }
    }

    private void zzCF() {
        this.zzaWB.zza(new zzc.zza(){

            @Override
            public void zzw(List<zza> list) {
                for (zza zza2 : list) {
                    DataLayer.this.zzL(DataLayer.this.zzk(zza2.zzue, zza2.zzJy));
                }
                DataLayer.this.zzaWC.countDown();
            }
        });
    }

    private void zzM(Map<String, Object> map) {
        Long l2 = this.zzN(map);
        if (l2 == null) {
            return;
        }
        List<zza> list = this.zzP(map);
        list.remove("gtm.lifetime");
        this.zzaWB.zza(list, l2);
    }

    private Long zzN(Map<String, Object> map) {
        Object object = this.zzO(map);
        if (object == null) {
            return null;
        }
        return DataLayer.zzeJ(object.toString());
    }

    private Object zzO(Map<String, Object> map) {
        Object object = map;
        for (String string2 : zzaWv) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string2);
        }
        return object;
    }

    void zzeI(String string2) {
        this.push(string2, null);
        this.zzaWB.zzeK(string2);
    }

    private List<zza> zzP(Map<String, Object> map) {
        ArrayList<zza> arrayList = new ArrayList<zza>();
        this.zza(map, "", arrayList);
        return arrayList;
    }

    private void zza(Map<String, Object> map, String string2, Collection<zza> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string3 = string2 + (string2.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map map2 = (Map)entry.getValue();
                this.zza(map2, string3, collection);
                continue;
            }
            if (string3.equals("gtm.lifetime")) continue;
            collection.add(new zza(string3, entry.getValue()));
        }
    }

    static Long zzeJ(String string2) {
        Matcher matcher = zzaWw.matcher(string2);
        if (!matcher.matches()) {
            zzbg.zzaG("unknown _lifetime: " + string2);
            return null;
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            zzbg.zzaH("illegal number in _lifetime value: " + string2);
        }
        if (l2 <= 0L) {
            zzbg.zzaG("non-positive _lifetime: " + string2);
            return null;
        }
        String string3 = matcher.group(2);
        if (string3.length() == 0) {
            return l2;
        }
        switch (string3.charAt(0)) {
            case 's': {
                return l2 * 1000L;
            }
            case 'm': {
                return l2 * 1000L * 60L;
            }
            case 'h': {
                return l2 * 1000L * 60L * 60L;
            }
            case 'd': {
                return l2 * 1000L * 60L * 60L * 24L;
            }
        }
        zzbg.zzaH("unknown units in _lifetime: " + string2);
        return null;
    }

    private void zzCG() {
        Map<String, Object> map;
        int n = 0;
        while ((map = this.zzaWA.poll()) != null) {
            this.zzQ(map);
            if (++n <= 500) continue;
            this.zzaWA.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzQ(Map<String, Object> map) {
        Map<String, Object> map2 = this.zzaWy;
        synchronized (map2) {
            for (String string2 : map.keySet()) {
                this.zzd(this.zzk(string2, map.get(string2)), this.zzaWy);
            }
        }
        this.zzR(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<String, Object> map = this.zzaWy;
        synchronized (map) {
            String[] stringArray;
            Object object = this.zzaWy;
            for (String string2 : stringArray = key.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string2);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i] instanceof String)) {
                throw new IllegalArgumentException("key is not a string: " + objects[i]);
            }
            hashMap.put((String)objects[i], objects[i + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            arrayList.add(objects[i]);
        }
        return arrayList;
    }

    void zza(zzb zzb2) {
        this.zzaWx.put(zzb2, 0);
    }

    private void zzR(Map<String, Object> map) {
        for (zzb zzb2 : this.zzaWx.keySet()) {
            zzb2.zzJ(map);
        }
    }

    Map<String, Object> zzk(String string2, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string2.toString().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void zzd(Map<String, Object> map, Map<String, Object> map2) {
        for (String string2 : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string2);
            if (object3 instanceof List) {
                if (!(map2.get(string2) instanceof List)) {
                    map2.put(string2, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string2);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string2) instanceof Map)) {
                    map2.put(string2, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string2);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string2, object3);
        }
    }

    void zzb(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3 = list.get(i);
            if (object3 instanceof List) {
                if (!(list2.get(i) instanceof List)) {
                    list2.set(i, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i) instanceof Map)) {
                    list2.set(i, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i, object3);
        }
    }

    static interface zzc {
        public void zza(List<com.google.android.gms.tagmanager.DataLayer$zza> var1, long var2);

        public void zza(zza var1);

        public void zzeK(String var1);

        public static interface zza {
            public void zzw(List<com.google.android.gms.tagmanager.DataLayer$zza> var1);
        }
    }

    static final class zza {
        public final String zzue;
        public final Object zzJy;

        zza(String string2, Object object) {
            this.zzue = string2;
            this.zzJy = object;
        }

        public String toString() {
            return "Key: " + this.zzue + " value: " + this.zzJy.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.zzue.hashCode(), this.zzJy.hashCode()});
        }

        public boolean equals(Object o) {
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return this.zzue.equals(zza2.zzue) && this.zzJy.equals(zza2.zzJy);
        }
    }

    static interface zzb {
        public void zzJ(Map<String, Object> var1);
    }
}

